/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.account;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.account.AccountPositionFormData;
import com.aimluck.eip.account.AccountPostFormData;
import com.aimluck.eip.account.util.AccountUtils;
import com.aimluck.eip.cayenne.om.account.EipMUserPosition;
import com.aimluck.eip.cayenne.om.portlet.EipTBlog;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogFootmarkMap;
import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.cayenne.om.portlet.EipTTodoCategory;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.cayenne.om.security.TurbineUserGroupRole;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.user.beans.UserGroupLiteBean;
import com.aimluck.eip.util.ALEipUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AccountUserFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AccountUserFormData.class.getName());
    private static final String DEFAULT_VIEW_PASSWORD = "******";
    private ALStringField username;
    private ALStringField password;
    private ALStringField password2;
    private ALStringField firstname;
    private ALStringField lastname;
    private ALStringField email;
    private ALStringField disabled;
    private ALStringField in_telephone;
    private ALStringField out_telephone1;
    private ALStringField out_telephone2;
    private ALStringField out_telephone3;
    private ALStringField cellular_phone1;
    private ALStringField cellular_phone2;
    private ALStringField cellular_phone3;
    private ALStringField cellular_mail;
    private ALNumberField company_id;
    private ALNumberField position_id;
    private ALNumberField post_id;
    private Map user_post_map;
    private ALStringField first_name_kana;
    private ALStringField last_name_kana;
    private ALStringField photo = null;
    private FileuploadLiteBean filebean = null;
    private String folderName = null;
    private List postList;
    private ArrayList positionList;
    private AccountPostFormData post;
    private AccountPositionFormData position;
    private boolean is_new_post;
    private boolean is_new_position;
    private boolean dontUpdatePasswd = false;
    private String org_id;
    private DataContext dataContext;
    private byte[] facePhoto;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.folderName = rundata.getParameters().getString("folderName");
        this.is_new_post = rundata.getParameters().getBoolean("is_new_post");
        this.is_new_position = rundata.getParameters().getBoolean("is_new_position");
        this.org_id = DatabaseOrmService.getInstance().getOrgId(rundata);
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
    }

    public void initField() {
        this.username = new ALStringField();
        this.username.setFieldName("\u30ed\u30b0\u30a4\u30f3\u540d");
        this.username.setTrim(true);
        this.password = new ALStringField();
        this.password.setFieldName("\u30d1\u30b9\u30ef\u30fc\u30c9");
        this.password.setTrim(true);
        this.password2 = new ALStringField();
        this.password2.setFieldName("\u30d1\u30b9\u30ef\u30fc\u30c9\uff08\u78ba\u8a8d\u7528\uff09");
        this.password2.setTrim(true);
        this.firstname = new ALStringField();
        this.firstname.setFieldName("\u540d\u524d\uff08\u540d\uff09");
        this.firstname.setTrim(true);
        this.lastname = new ALStringField();
        this.lastname.setFieldName("\u540d\u524d\uff08\u59d3\uff09");
        this.lastname.setTrim(true);
        this.email = new ALStringField();
        this.email.setFieldName("\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9");
        this.email.setTrim(true);
        this.disabled = new ALStringField();
        this.disabled.setFieldName("\u30a2\u30ab\u30a6\u30f3\u30c8\u6709\u52b9/\u7121\u52b9");
        this.disabled.setTrim(true);
        this.in_telephone = new ALStringField();
        this.in_telephone.setFieldName("\u96fb\u8a71\u756a\u53f7\uff08\u5185\u7dda\uff09");
        this.in_telephone.setTrim(true);
        this.out_telephone1 = new ALStringField();
        this.out_telephone1.setFieldName("\u96fb\u8a71\u756a\u53f7\uff08\u5916\u7dda\uff09");
        this.out_telephone1.setTrim(true);
        this.out_telephone2 = new ALStringField();
        this.out_telephone2.setFieldName("\u96fb\u8a71\u756a\u53f7\uff08\u5916\u7dda\uff09");
        this.out_telephone2.setTrim(true);
        this.out_telephone3 = new ALStringField();
        this.out_telephone3.setFieldName("\u96fb\u8a71\u756a\u53f7\uff08\u5916\u7dda\uff09");
        this.out_telephone3.setTrim(true);
        this.cellular_phone1 = new ALStringField();
        this.cellular_phone1.setFieldName("\u96fb\u8a71\u756a\u53f7\uff08\u643a\u5e2f\uff09");
        this.cellular_phone1.setTrim(true);
        this.cellular_phone2 = new ALStringField();
        this.cellular_phone2.setFieldName("\u96fb\u8a71\u756a\u53f7\uff08\u643a\u5e2f\uff09");
        this.cellular_phone2.setTrim(true);
        this.cellular_phone3 = new ALStringField();
        this.cellular_phone3.setFieldName("\u96fb\u8a71\u756a\u53f7\uff08\u643a\u5e2f\uff09");
        this.cellular_phone3.setTrim(true);
        this.cellular_mail = new ALStringField();
        this.cellular_mail.setFieldName("\u643a\u5e2f\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9");
        this.cellular_mail.setTrim(true);
        this.first_name_kana = new ALStringField();
        this.first_name_kana.setFieldName("\u540d\u524d\uff08\u30d5\u30ea\u30ac\u30ca\uff09");
        this.first_name_kana.setTrim(true);
        this.last_name_kana = new ALStringField();
        this.last_name_kana.setFieldName("\u540d\u524d\uff08\u30d5\u30ea\u30ac\u30ca\uff09");
        this.last_name_kana.setTrim(true);
        this.photo = new ALStringField();
        this.photo.setFieldName("\u9854\u5199\u771f");
        this.photo.setTrim(true);
        this.post_id = new ALNumberField();
        this.post_id.setFieldName("\u90e8\u7f72");
        this.position_id = new ALNumberField();
        this.position_id.setFieldName("\u5f79\u8077");
        this.post = new AccountPostFormData();
        this.post.setJoinMember(false);
        this.post.initField();
        this.position = new AccountPositionFormData();
        this.position.initField();
    }

    protected boolean setFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        try {
            if (res) {
                this.post.setFormData(rundata, context, msgList);
                this.position.setFormData(rundata, context, msgList);
                ArrayList fileBeanList = FileuploadUtils.getFileuploadList((RunData)rundata);
                if (fileBeanList != null && fileBeanList.size() > 0) {
                    this.filebean = (FileuploadLiteBean)fileBeanList.get(0);
                    if (this.filebean.getFileId() > 0) {
                        String[] acceptExts = ImageIO.getWriterFormatNames();
                        this.facePhoto = FileuploadUtils.getBytesShrinkFilebean((String)this.org_id, (String)this.folderName, (int)ALEipUtils.getUserId((RunData)rundata), (FileuploadLiteBean)this.filebean, (String[])acceptExts, (int)86, (int)86, (ArrayList)msgList);
                    } else {
                        this.facePhoto = null;
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            res = false;
        }
        return res;
    }

    protected void setValidator() {
        this.username.setNotNull(true);
        this.username.setCharacterType(3);
        this.username.limitMaxLength(16);
        this.password.setNotNull(true);
        this.password.setCharacterType(3);
        this.password.limitMaxLength(16);
        this.password2.setNotNull(true);
        this.password2.setCharacterType(3);
        this.password2.limitMaxLength(16);
        this.firstname.setNotNull(true);
        this.firstname.limitMaxLength(20);
        this.lastname.setNotNull(true);
        this.lastname.limitMaxLength(20);
        this.first_name_kana.setNotNull(true);
        this.first_name_kana.limitMaxLength(20);
        this.last_name_kana.setNotNull(true);
        this.last_name_kana.limitMaxLength(20);
        this.in_telephone.setCharacterType(3);
        this.in_telephone.limitMaxLength(13);
        this.email.setCharacterType(19);
        this.email.limitMaxLength(50);
        this.out_telephone1.setCharacterType(2);
        this.out_telephone1.limitMaxLength(5);
        this.out_telephone2.setCharacterType(2);
        this.out_telephone2.limitMaxLength(4);
        this.out_telephone3.setCharacterType(2);
        this.out_telephone3.limitMaxLength(4);
        this.cellular_phone1.setCharacterType(2);
        this.cellular_phone1.limitMaxLength(5);
        this.cellular_phone2.setCharacterType(2);
        this.cellular_phone2.limitMaxLength(4);
        this.cellular_phone3.setCharacterType(2);
        this.cellular_phone3.limitMaxLength(4);
        this.cellular_mail.setCharacterType(19);
        this.post.setValidator();
        this.position.setValidator();
    }

    protected boolean validate(ArrayList msgList) {
        ArrayList dummy = new ArrayList();
        this.username.validate(msgList);
        if ("insert".equals(this.getMode())) {
            try {
                Expression exp = ExpressionFactory.matchExp((String)"loginName", (Object)this.username.getValue());
                SelectQuery query = new SelectQuery(TurbineUser.class, exp);
                List ulist = this.dataContext.performQuery((Query)query);
                if (ulist.size() > 0) {
                    TurbineUser user = (TurbineUser)ulist.get(0);
                    if ("F".equals(user.getDisabled())) {
                        msgList.add("\u30ed\u30b0\u30a4\u30f3\u540d\u300e <span class='em'>" + this.username + "</span> \u300f\u306f\u3059\u3067\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u5225\u306e\u30ed\u30b0\u30a4\u30f3\u540d\u3067\u767b\u9332\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                    } else {
                        msgList.add("\u30ed\u30b0\u30a4\u30f3\u540d\u300e <span class='em'>" + this.username + "</span> \u300f\u306f\u3059\u3067\u306b\u524a\u9664\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u4e00\u65e6\u524a\u9664\u3057\u305f\u30ed\u30b0\u30a4\u30f3\u540d\u3067\u306f\u767b\u9332\u3067\u304d\u307e\u305b\u3093\u3002");
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Exception", (Throwable)ex);
                return false;
            }
        }
        if ("insert".equals(this.getMode())) {
            if (!this.password.getValue().equals(this.password2.getValue())) {
                msgList.add("\u300e <span class='em'>\u30d1\u30b9\u30ef\u30fc\u30c9</span> \u300f\u3068\u300e <span class='em'>\u30d1\u30b9\u30ef\u30fc\u30c9\uff08\u78ba\u8a8d\u7528\uff09</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            } else {
                this.password.validate(msgList);
                this.password2.validate(msgList);
            }
        } else if ("update".equals(this.getMode())) {
            if (this.password.getValue().equals(DEFAULT_VIEW_PASSWORD) && this.password2.getValue().equals(DEFAULT_VIEW_PASSWORD)) {
                this.dontUpdatePasswd = true;
            } else if (!this.password.getValue().equals(this.password2.getValue())) {
                msgList.add("\u300e <span class='em'>\u30d1\u30b9\u30ef\u30fc\u30c9</span> \u300f\u3068\u300e <span class='em'>\u30d1\u30b9\u30ef\u30fc\u30c9\uff08\u78ba\u8a8d\u7528\uff09</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            } else {
                this.password.validate(msgList);
                this.password2.validate(msgList);
            }
        }
        this.firstname.validate(msgList);
        this.lastname.validate(msgList);
        this.first_name_kana.setValue(ALStringUtil.convertHiragana2Katakana((String)ALStringUtil.convertH2ZKana((String)this.first_name_kana.toString())));
        this.last_name_kana.setValue(ALStringUtil.convertHiragana2Katakana((String)ALStringUtil.convertH2ZKana((String)this.last_name_kana.toString())));
        this.first_name_kana.validate(msgList);
        this.last_name_kana.validate(msgList);
        this.email.validate(msgList);
        if (this.email.getValue() != null && this.email.getValue().trim().length() > 0 && !ALStringUtil.isCellPhoneMailAddress((String)this.email.getValue())) {
            msgList.add("\u300e <span class='em'> \u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9 </span>\u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        if (!(this.out_telephone1.getValue().equals("") && this.out_telephone2.getValue().equals("") && this.out_telephone3.getValue().equals(""))) {
            if (!(this.out_telephone1.validate(dummy) && this.out_telephone2.validate(dummy) && this.out_telephone3.validate(dummy))) {
                msgList.add("\u300e <span class='em'>\u96fb\u8a71\u756a\u53f7\uff08\u5916\u7dda\uff09</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            } else {
                int limit_size;
                int req_size = this.out_telephone1.getValue().length() + this.out_telephone2.getValue().length() + this.out_telephone3.getValue().length();
                if (req_size > (limit_size = this.out_telephone1.getMaxLength() + this.out_telephone2.getMaxLength() + this.out_telephone3.getMaxLength())) {
                    msgList.add("\u300e <span class='em'>\u96fb\u8a71\u756a\u53f7\uff08\u5916\u7dda\uff09</span> \u300f\u3092" + limit_size + "\u6841\u4ee5\u5185\u3067\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                }
            }
        }
        this.in_telephone.validate(msgList);
        if (!(this.cellular_phone1.getValue().equals("") && this.cellular_phone2.getValue().equals("") && this.cellular_phone3.getValue().equals("") || this.cellular_phone1.validate(dummy) && this.cellular_phone2.validate(dummy) && this.cellular_phone3.validate(dummy))) {
            msgList.add("\u300e <span class='em'>\u96fb\u8a71\u756a\u53f7\uff08\u643a\u5e2f\uff09</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        this.cellular_mail.validate(msgList);
        if (this.cellular_mail.getValue().trim().length() > 0 && !ALStringUtil.isCellPhoneMailAddress((String)this.cellular_mail.getValue())) {
            msgList.add("\u300e <span class='em'> \u643a\u5e2f\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9 </span>\u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        if (this.filebean != null && this.filebean.getFileId() > 0 && this.facePhoto == null) {
            msgList.add("\u300e <span class='em'>\u9854\u5199\u771f</span> \u300f\u306b\u306fJpeg\u753b\u50cf\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        if (this.is_new_post) {
            this.post.setMode("insert");
            this.post.validate(msgList);
        }
        if (this.is_new_position) {
            this.position.setMode("insert");
            this.position.validate(msgList);
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            StringTokenizer token;
            ALBaseUser user = AccountUtils.getBaseUser(rundata, context);
            if (user == null) {
                return false;
            }
            this.username.setValue(user.getUserName());
            this.password.setValue(DEFAULT_VIEW_PASSWORD);
            this.password2.setValue(DEFAULT_VIEW_PASSWORD);
            this.firstname.setValue(user.getFirstName());
            this.lastname.setValue(user.getLastName());
            this.email.setValue(user.getEmail());
            this.in_telephone.setValue(user.getInTelephone());
            if (user.getOutTelephone() != null && (token = new StringTokenizer(user.getOutTelephone(), "-")).countTokens() == 3) {
                this.out_telephone1.setValue(token.nextToken());
                this.out_telephone2.setValue(token.nextToken());
                this.out_telephone3.setValue(token.nextToken());
            }
            if (user.getCellularPhone() != null && (token = new StringTokenizer(user.getCellularPhone(), "-")).countTokens() == 3) {
                this.cellular_phone1.setValue(token.nextToken());
                this.cellular_phone2.setValue(token.nextToken());
                this.cellular_phone3.setValue(token.nextToken());
            }
            this.cellular_mail.setValue(user.getCellularMail());
            this.position_id.setValue((long)user.getPositionId());
            this.first_name_kana.setValue(user.getFirstNameKana());
            this.last_name_kana.setValue(user.getLastNameKana());
            if (user.getPhoto() != null) {
                this.filebean = new FileuploadLiteBean();
                this.filebean.initField();
                this.filebean.setFolderName("");
                this.filebean.setFileId(0);
                this.filebean.setFileName("\u4ee5\u524d\u306e\u5199\u771f\u30d5\u30a1\u30a4\u30eb");
            }
            this.postList = AccountUtils.getPostBeanList(Integer.parseInt(user.getUserId()));
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return false;
        }
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        boolean res = true;
        try {
            if (this.is_new_position && res && (res = this.position.insertFormData(rundata, context, msgList))) {
                this.position_id.setValue((long)this.position.getPositionId());
            }
            if (res) {
                ALBaseUser user = (ALBaseUser)JetspeedSecurity.getUserInstance();
                rundata.getParameters().setProperties((Object)user);
                user.setUserName(JetspeedSecurity.convertUserName((String)this.username.getValue()));
                Date now = new Date();
                user.setCreated(now);
                user.setModified(now);
                user.setLastLogin(now);
                user.setCreatedUserId(ALEipUtils.getUserId((RunData)rundata));
                user.setUpdatedUserId(ALEipUtils.getUserId((RunData)rundata));
                user.setConfirmed("CONFIRMED");
                user.setDisabled(this.disabled.getValue() != null);
                user.setPassword(this.password.getValue());
                user.setPasswordChanged(new Date());
                user.setInTelephone(this.in_telephone.getValue());
                if (!(this.out_telephone1.getValue().equals("") || this.out_telephone2.getValue().equals("") || this.out_telephone3.getValue().equals(""))) {
                    user.setOutTelephone(new StringBuffer().append(this.out_telephone1.getValue()).append("-").append(this.out_telephone2.getValue()).append("-").append(this.out_telephone3.getValue()).toString());
                } else {
                    user.setOutTelephone("");
                }
                if (!(this.cellular_phone1.getValue().equals("") || this.cellular_phone2.getValue().equals("") || this.cellular_phone3.getValue().equals(""))) {
                    user.setCellularPhone(new StringBuffer().append(this.cellular_phone1.getValue()).append("-").append(this.cellular_phone2.getValue()).append("-").append(this.cellular_phone3.getValue()).toString());
                } else {
                    user.setCellularPhone("");
                }
                user.setCellularMail(this.cellular_mail.getValue());
                user.setCompanyId(1);
                user.setPositionId((int)this.position_id.getValue());
                user.setPostId((int)this.post_id.getValue());
                user.setFirstNameKana(this.first_name_kana.getValue());
                user.setLastNameKana(this.last_name_kana.getValue());
                if (this.filebean != null && this.filebean.getFileId() > 0) {
                    user.setPhoto(this.facePhoto);
                }
                JetspeedSecurity.addUser((JetspeedUser)user);
                logger.debug((Object)"JOIN GROUP:LoginUser");
                String[] groups = rundata.getParameters().getStrings("group_to");
                if (groups != null && groups.length != 0) {
                    for (int i = 0; i < groups.length; ++i) {
                        JetspeedSecurity.joinGroup((String)user.getUserName(), (String)groups[i]);
                    }
                }
                ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
                ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
                aclhandler.insertDefaultRole(Integer.parseInt(user.getUserId()));
                this.dataContext.commitChanges();
            }
            File folder = FileuploadUtils.getFolder((String)this.org_id, (int)ALEipUtils.getUserId((RunData)rundata), (String)this.folderName);
            FileuploadUtils.deleteFolder((File)folder);
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            res = false;
        }
        return res;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        boolean res = true;
        try {
            if (this.is_new_post && (res = this.post.insertFormData(rundata, context, msgList))) {
                this.post_id.setValue((long)this.post.getPostId());
            }
            if (this.is_new_position && res && (res = this.position.insertFormData(rundata, context, msgList))) {
                this.position_id.setValue((long)this.position.getPositionId());
            }
            if (res) {
                ALBaseUser currentUser;
                String[] groupNameList;
                int i;
                ALBaseUser user = AccountUtils.getBaseUser(rundata, context);
                if (user == null) {
                    return false;
                }
                boolean oldDisabled = user.getDisabled();
                rundata.getParameters().setProperties((Object)user);
                user.setLastAccessDate();
                if (!this.dontUpdatePasswd) {
                    JetspeedSecurity.forcePassword((JetspeedUser)user, (String)this.password.getValue());
                } else {
                    Expression exp = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)user.getUserId());
                    SelectQuery query = new SelectQuery(TurbineUser.class, exp);
                    List list = this.dataContext.performQuery((Query)query);
                    if (list == null || list.size() == 0) {
                        return false;
                    }
                    TurbineUser tuser = (TurbineUser)list.get(0);
                    user.setPassword(tuser.getPasswordValue());
                }
                String strDisabled = this.disabled.getValue();
                boolean disabled = strDisabled != null;
                user.setDisabled(disabled);
                if (!disabled && oldDisabled && JetspeedSecurity.isDisableAccountCheckEnabled()) {
                    JetspeedSecurity.resetDisableAccountCheck((String)user.getUserName());
                }
                user.setInTelephone(this.in_telephone.getValue());
                if (!(this.out_telephone1.getValue().equals("") || this.out_telephone2.getValue().equals("") || this.out_telephone3.getValue().equals(""))) {
                    user.setOutTelephone(new StringBuffer().append(this.out_telephone1.getValue()).append("-").append(this.out_telephone2.getValue()).append("-").append(this.out_telephone3.getValue()).toString());
                } else {
                    user.setOutTelephone("");
                }
                if (!(this.cellular_phone1.getValue().equals("") || this.cellular_phone2.getValue().equals("") || this.cellular_phone3.getValue().equals(""))) {
                    user.setCellularPhone(new StringBuffer().append(this.cellular_phone1.getValue()).append("-").append(this.cellular_phone2.getValue()).append("-").append(this.cellular_phone3.getValue()).toString());
                } else {
                    user.setCellularPhone("");
                }
                user.setCellularMail(this.cellular_mail.getValue());
                user.setPositionId((int)this.position_id.getValue());
                user.setFirstNameKana(this.first_name_kana.getValue());
                user.setLastNameKana(this.last_name_kana.getValue());
                if (this.filebean != null) {
                    if (this.filebean.getFileId() > 0) {
                        user.setPhoto(this.facePhoto);
                    }
                } else {
                    user.setPhoto(null);
                }
                user.setEmail(this.email.getValue());
                JetspeedSecurity.saveUser((JetspeedUser)user);
                List postList_old = AccountUtils.getPostBeanList(Integer.parseInt(user.getUserId()));
                if (postList_old != null && postList_old.size() > 0) {
                    UserGroupLiteBean uglb = null;
                    int old_size = postList_old.size();
                    for (i = 0; i < old_size; ++i) {
                        uglb = (UserGroupLiteBean)postList_old.get(i);
                        JetspeedSecurity.unjoinGroup((String)user.getUserName(), (String)uglb.getGroupId());
                    }
                }
                if ((groupNameList = rundata.getParameters().getStrings("group_to")) != null && groupNameList.length > 0) {
                    int size = groupNameList.length;
                    for (i = 0; i < size; ++i) {
                        JetspeedSecurity.joinGroup((String)user.getUserName(), (String)groupNameList[i]);
                    }
                }
                if ((currentUser = (ALBaseUser)rundata.getUser()).getUserName().equals(user.getUserName())) {
                    currentUser.setPassword(user.getPassword());
                    currentUser.setFirstName(user.getFirstName());
                    currentUser.setLastName(user.getLastName());
                    currentUser.setEmail(user.getEmail());
                    currentUser.setInTelephone(user.getInTelephone());
                    currentUser.setOutTelephone(user.getOutTelephone());
                    currentUser.setCellularPhone(user.getCellularPhone());
                    currentUser.setCellularMail(user.getCellularMail());
                    currentUser.setPositionId(user.getPositionId());
                    currentUser.setPostId(user.getPostId());
                    currentUser.setFirstNameKana(user.getFirstNameKana());
                    currentUser.setLastNameKana(user.getLastNameKana());
                }
            }
            File folder = FileuploadUtils.getFolder((String)this.org_id, (int)ALEipUtils.getUserId((RunData)rundata), (String)this.folderName);
            FileuploadUtils.deleteFolder((File)folder);
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            res = false;
        }
        return res;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            String user_name = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            if (user_name == null) {
                return false;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            ObjectId oid_user = new ObjectId("TurbineUser", "LOGIN_NAME", (Object)user_name);
            TurbineUser user = (TurbineUser)dataContext.refetchObject(oid_user);
            user.setPositionId(Integer.valueOf(0));
            user.setDisabled("T");
            SelectQuery query = new SelectQuery(TurbineUser.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"loginName", (Object)user_name);
            query.setQualifier(exp1);
            List list3 = dataContext.performQuery((Query)query);
            int userNum = list3.size();
            if (userNum != 1) {
                return false;
            }
            TurbineUser deleteuser = (TurbineUser)list3.get(0);
            String userId = deleteuser.getUserId().toString();
            SelectQuery query2 = new SelectQuery(TurbineUserGroupRole.class);
            Expression exp2 = ExpressionFactory.matchExp((String)"turbineUser", (Object)userId);
            query2.setQualifier(exp2);
            List list4 = dataContext.performQuery((Query)query2);
            TurbineUserGroupRole ugr = null;
            for (int i = 0; i < list4.size(); ++i) {
                ugr = (TurbineUserGroupRole)list4.get(i);
                dataContext.deleteObject((Persistent)ugr);
            }
            String sql4 = "DELETE FROM EIP_T_TODO WHERE USER_ID = '" + userId + "'";
            SQLTemplate rawSelect4 = new SQLTemplate(EipTTodo.class, sql4, false);
            dataContext.performQuery((Query)rawSelect4);
            String sql5 = "DELETE FROM EIP_T_TODO_CATEGORY WHERE USER_ID = '" + userId + "'";
            SQLTemplate rawSelect5 = new SQLTemplate(EipTTodoCategory.class, sql5, false);
            dataContext.performQuery((Query)rawSelect5);
            String sql6 = "DELETE FROM EIP_T_BLOG WHERE OWNER_ID = '" + userId + "'";
            SQLTemplate rawSelect6 = new SQLTemplate(EipTBlog.class, sql6, false);
            dataContext.performQuery((Query)rawSelect6);
            String sql7 = "DELETE FROM EIP_T_BLOG_FOOTMARK_MAP WHERE USER_ID = '" + userId + "'";
            SQLTemplate rawSelect7 = new SQLTemplate(EipTBlogFootmarkMap.class, sql7, false);
            dataContext.performQuery((Query)rawSelect7);
            SelectQuery p_query = new SelectQuery(EipMUserPosition.class);
            p_query.addOrdering("position", true);
            List userPositions = dataContext.performQuery((Query)p_query);
            if (userPositions != null && userPositions.size() > 0) {
                int i;
                EipMUserPosition userPosition = null;
                int index = -1;
                int size = userPositions.size();
                for (i = 0; i < size; ++i) {
                    userPosition = (EipMUserPosition)userPositions.get(i);
                    if (!userId.equals(userPosition.getTurbineUser().toString())) continue;
                    dataContext.deleteObject((Persistent)userPosition);
                    index = i;
                    break;
                }
                if (index >= 0) {
                    for (i = index + 1; i < size; ++i) {
                        userPosition = (EipMUserPosition)userPositions.get(i);
                        userPosition.setPosition(Integer.valueOf(i));
                    }
                }
            }
            dataContext.commitChanges();
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return false;
        }
    }

    public boolean doDeleteAttachments(ALAction action, RunData rundata, Context context, String mode) {
        try {
            this.init(action, rundata, context);
            action.setMode(mode);
            this.setMode(mode);
            ArrayList msgList = new ArrayList();
            this.setValidator();
            boolean res = this.setFormData(rundata, context, msgList) && this.deleteAttachments(rundata, context, msgList);
            action.setResultData((Object)this);
            action.addErrorMessages(msgList);
            action.putData(rundata, context);
            return res;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    protected boolean deleteAttachments(RunData rundata, Context context, ArrayList msgList) {
        if (rundata == null || context == null) {
            msgList.add("\u30b7\u30b9\u30c6\u30e0\u4e0a\u306e\u554f\u984c\u306e\u305f\u3081\u3001\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            return false;
        }
        int userId = ALEipUtils.getUserId((RunData)rundata);
        ArrayList<FileuploadLiteBean> fileBeanList = new ArrayList<FileuploadLiteBean>();
        fileBeanList.add(this.filebean);
        return FileuploadUtils.deleteAttachments((String)this.org_id, (int)userId, (String)this.folderName, fileBeanList);
    }

    public ALStringField getCellularMail() {
        return this.cellular_mail;
    }

    public ALNumberField getCompanyId() {
        return this.company_id;
    }

    public ALStringField getDisabled() {
        return this.disabled;
    }

    public ALStringField getEmail() {
        return this.email;
    }

    public ALStringField getFirstNameKana() {
        return this.first_name_kana;
    }

    public ALStringField getFirstName() {
        return this.firstname;
    }

    public ALStringField getInTelephone() {
        return this.in_telephone;
    }

    public ALStringField getLastNameKana() {
        return this.last_name_kana;
    }

    public ALStringField getLastName() {
        return this.lastname;
    }

    public ALStringField getCellularPhone1() {
        return this.cellular_phone1;
    }

    public ALStringField getCellularPhone2() {
        return this.cellular_phone2;
    }

    public ALStringField getCellularPhone3() {
        return this.cellular_phone3;
    }

    public ALStringField getOutTelephone1() {
        return this.out_telephone1;
    }

    public ALStringField getOutTelephone2() {
        return this.out_telephone2;
    }

    public ALStringField getOutTelephone3() {
        return this.out_telephone3;
    }

    public ALStringField getPassword() {
        return this.password;
    }

    public ALStringField getPassword2() {
        return this.password2;
    }

    public ALNumberField getPositionId() {
        return this.position_id;
    }

    public ALNumberField getPostId() {
        return this.post_id;
    }

    public ALStringField getUserName() {
        return this.username;
    }

    public ArrayList getPositionList() {
        return this.positionList;
    }

    public List getPostList() {
        return this.postList;
    }

    public Map getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public Map getPositionMap() {
        return ALEipManager.getInstance().getPositionMap();
    }

    public AccountPostFormData getPost() {
        return this.post;
    }

    public AccountPositionFormData getPosition() {
        return this.position;
    }

    public boolean isNewPost() {
        return this.is_new_post;
    }

    public boolean isNewPosition() {
        return this.is_new_position;
    }

    public FileuploadLiteBean getFileBean() {
        return this.filebean;
    }

    public List getAttachmentFileNameList() {
        if (this.filebean == null) {
            return null;
        }
        ArrayList<FileuploadLiteBean> list = new ArrayList<FileuploadLiteBean>();
        list.add(this.filebean);
        return list;
    }

    public String getFolderName() {
        return this.folderName;
    }
}

