/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.account;

import com.aimluck.eip.account.AccountPostResultData;
import com.aimluck.eip.account.util.AccountUtils;
import com.aimluck.eip.cayenne.om.account.EipMPost;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AccountPostSelectData
extends ALAbstractSelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AccountPostSelectData.class.getName());

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p1a-sort"));
        }
        super.init(action, rundata, context);
    }

    protected List selectList(RunData rundata, Context context) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            List list = dataContext.performQuery((Query)query);
            return this.buildPaginatedList(list);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        return new SelectQuery(EipMPost.class);
    }

    protected Object selectDetail(RunData rundata, Context context) {
        return AccountUtils.getEipMPost(rundata, context);
    }

    protected Object getResultData(Object obj) {
        EipMPost record = (EipMPost)obj;
        AccountPostResultData rd = new AccountPostResultData();
        rd.initField();
        rd.setPostId(record.getPostId());
        rd.setPostName(record.getPostName());
        return rd;
    }

    protected Object getResultDataDetail(Object obj) {
        EipMPost record = (EipMPost)obj;
        AccountPostResultData rd = new AccountPostResultData();
        rd.initField();
        rd.setPostId(record.getPostId());
        rd.setPostName(record.getPostName());
        rd.setZipcode(record.getZipcode());
        rd.setAddress(record.getAddress());
        rd.setOutTelephone(record.getOutTelephone());
        rd.setInTelephone(record.getInTelephone());
        rd.setFaxNumber(record.getFaxNumber());
        rd.setGroupName(record.getGroupName());
        return rd;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("post_name", "postName");
        return map;
    }

    public List getMemberList(long postid) {
        return ALEipUtils.getUsersFromPost((int)((int)postid));
    }

    public List getMemberListByGroup(String groupname) {
        return ALEipUtils.getUsers((String)groupname);
    }
}

