/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.account;

import com.aimluck.eip.cayenne.om.account.EipMPost;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AccountPostMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AccountPostMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, ArrayList values, ArrayList msgList) {
        try {
            List list = this.getEipMPosts(rundata, context, values);
            if (list == null || list.size() == 0) {
                return false;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            int listsize = list.size();
            for (int i = 0; i < listsize; ++i) {
                EipMPost record = (EipMPost)list.get(i);
                List users = ALEipUtils.getUsers((String)record.getGroupName());
                int size = users.size();
                for (int j = 0; j < size; ++j) {
                    JetspeedSecurity.unjoinGroup((String)((ALEipUser)users.get(j)).getName().getValue(), (String)record.getGroupName());
                }
                JetspeedSecurity.removeGroup((String)record.getGroupName());
                dataContext.deleteObject((Persistent)record);
            }
            dataContext.commitChanges();
            ALEipManager.getInstance().reloadPost();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    private List getEipMPosts(RunData rundata, Context context, ArrayList values) {
        List list = null;
        try {
            Expression exp;
            SelectQuery query;
            if (values == null || values.size() == 0) {
                logger.debug((Object)"values are empty...");
                return null;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            list = dataContext.performQuery((Query)(query = new SelectQuery(EipMPost.class, exp = ExpressionFactory.inDbExp((String)"POST_ID", (Collection)values))));
            if (list == null || list.size() == 0) {
                logger.debug((Object)"Not found ID...");
                return null;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            list = null;
        }
        return list;
    }
}

