/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.account;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.account.util.AccountUtils;
import com.aimluck.eip.cayenne.om.account.EipMPost;
import com.aimluck.eip.cayenne.om.security.TurbineGroup;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AccountPostFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AccountPostFormData.class.getName());
    private ALStringField post_name;
    private ALStringField zipcode1;
    private ALStringField zipcode2;
    private ALStringField address;
    private ALStringField post_out_telephone1;
    private ALStringField post_out_telephone2;
    private ALStringField post_out_telephone3;
    private ALStringField post_in_telephone;
    private ALStringField fax_number1;
    private ALStringField fax_number2;
    private ALStringField fax_number3;
    private ArrayList memberList;
    private boolean is_join_member = true;
    private int post_id;
    private ALStringField group_name;
    private DataContext dataContext;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
    }

    public void initField() {
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        this.post_name = new ALStringField();
        this.post_name.setFieldName("\u90e8\u7f72\u540d");
        this.post_name.setTrim(true);
        this.zipcode1 = new ALStringField();
        this.zipcode1.setFieldName("\u90f5\u4fbf\u756a\u53f7");
        this.zipcode1.setTrim(true);
        this.zipcode2 = new ALStringField();
        this.zipcode2.setFieldName("\u90f5\u4fbf\u756a\u53f7");
        this.zipcode2.setTrim(true);
        this.address = new ALStringField();
        this.address.setFieldName("\u4f4f\u6240");
        this.address.setTrim(true);
        this.post_out_telephone1 = new ALStringField();
        this.post_out_telephone1.setFieldName("\u96fb\u8a71\u756a\u53f7\uff08\u5916\u7dda\uff09");
        this.post_out_telephone1.setTrim(true);
        this.post_out_telephone2 = new ALStringField();
        this.post_out_telephone2.setFieldName("\u96fb\u8a71\u756a\u53f7\uff08\u5916\u7dda\uff09");
        this.post_out_telephone2.setTrim(true);
        this.post_out_telephone3 = new ALStringField();
        this.post_out_telephone3.setFieldName("\u96fb\u8a71\u756a\u53f7\uff08\u5916\u7dda\uff09");
        this.post_out_telephone3.setTrim(true);
        this.post_in_telephone = new ALStringField();
        this.post_in_telephone.setFieldName("\u96fb\u8a71\u756a\u53f7\uff08\u5185\u7dda\uff09");
        this.post_in_telephone.setTrim(true);
        this.fax_number1 = new ALStringField();
        this.fax_number1.setFieldName("FAX\u756a\u53f7");
        this.fax_number1.setTrim(true);
        this.fax_number2 = new ALStringField();
        this.fax_number2.setFieldName("FAX\u756a\u53f7");
        this.fax_number2.setTrim(true);
        this.fax_number3 = new ALStringField();
        this.fax_number3.setFieldName("FAX\u756a\u53f7");
        this.fax_number3.setTrim(true);
        if (this.is_join_member) {
            this.memberList = new ArrayList();
        }
        this.group_name = new ALStringField();
    }

    protected boolean setFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (res) {
            try {
                if ("update".equals(this.getMode())) {
                    this.post_id = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid"));
                }
                if (this.is_join_member) {
                    Object[] str = rundata.getParameters().getStrings("member_to");
                    if (str == null) {
                        return res;
                    }
                    Expression exp = ExpressionFactory.inExp((String)"loginName", (Object[])str);
                    SelectQuery query = new SelectQuery(TurbineUser.class);
                    query.setQualifier(exp);
                    List list = this.dataContext.performQuery((Query)query);
                    int size = list.size();
                    for (int i = 0; i < size; ++i) {
                        TurbineUser record = (TurbineUser)list.get(i);
                        ALEipUser user = new ALEipUser();
                        user.initField();
                        user.setName(record.getLoginName());
                        user.setAliasName(record.getFirstName(), record.getLastName());
                        this.memberList.add(user);
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Exception", (Throwable)ex);
            }
        }
        return res;
    }

    protected void setValidator() {
        this.post_name.setNotNull(true);
        this.post_name.limitMaxLength(50);
        this.zipcode1.setCharacterType(2);
        this.zipcode1.limitLength(3, 3);
        this.zipcode2.setCharacterType(2);
        this.zipcode2.limitLength(4, 4);
        this.address.limitMaxLength(64);
        this.post_out_telephone1.setCharacterType(2);
        this.post_out_telephone1.limitMaxLength(5);
        this.post_out_telephone2.setCharacterType(2);
        this.post_out_telephone2.limitMaxLength(4);
        this.post_out_telephone3.setCharacterType(2);
        this.post_out_telephone3.limitMaxLength(4);
        this.post_in_telephone.setCharacterType(3);
        this.post_in_telephone.limitMaxLength(13);
        this.fax_number1.setCharacterType(2);
        this.fax_number1.limitMaxLength(5);
        this.fax_number2.setCharacterType(2);
        this.fax_number2.limitMaxLength(4);
        this.fax_number3.setCharacterType(2);
        this.fax_number3.limitMaxLength(4);
    }

    protected boolean validate(ArrayList msgList) {
        ArrayList dummy = new ArrayList();
        this.post_name.validate(msgList);
        this.address.validate(msgList);
        if (this.post_name.toString().lastIndexOf("/") != -1) {
            msgList.add("\u90e8\u7f72\u540d\u306b\u300e <span class='em'>/</span> \u300f\u3092\u7528\u3044\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        try {
            SelectQuery query = new SelectQuery(EipMPost.class);
            if ("insert".equals(this.getMode())) {
                Expression exp = ExpressionFactory.matchExp((String)"postName", (Object)this.post_name.getValue());
                query.setQualifier(exp);
            } else if ("update".equals(this.getMode())) {
                Expression exp1 = ExpressionFactory.matchExp((String)"postName", (Object)this.post_name.getValue());
                query.setQualifier(exp1);
                Expression exp2 = ExpressionFactory.noMatchDbExp((String)"POST_ID", (Object)this.post_id);
                query.andQualifier(exp2);
            }
            if (this.dataContext.performQuery((Query)query).size() != 0) {
                msgList.add("\u90e8\u7f72\u540d\u300e <span class='em'>" + this.post_name + "</span> \u300f\u306f\u65e2\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        if (!(this.zipcode1.getValue().equals("") && this.zipcode2.getValue().equals("") || this.zipcode1.validate(dummy) && this.zipcode2.validate(dummy))) {
            msgList.add("\u300e <span class='em'>\u90f5\u4fbf\u756a\u53f7</span> \u300f\u306f7\u6841\u306e\u534a\u89d2\u6570\u5b57\u3067\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        if (!(this.post_out_telephone1.getValue().equals("") && this.post_out_telephone2.getValue().equals("") && this.post_out_telephone3.getValue().equals("") || this.post_out_telephone1.validate(dummy) && this.post_out_telephone2.validate(dummy) && this.post_out_telephone3.validate(dummy))) {
            msgList.add("\u300e <span class='em'>\u96fb\u8a71\u756a\u53f7\uff08\u5916\u7dda\uff09</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        this.post_in_telephone.validate(msgList);
        if (!(this.fax_number1.getValue().equals("") && this.fax_number2.getValue().equals("") && this.fax_number3.getValue().equals("") || this.fax_number1.validate(dummy) && this.fax_number2.validate(dummy) && this.fax_number3.validate(dummy))) {
            msgList.add("\u300e <span class='em'>FAX\u756a\u53f7</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            StringTokenizer token;
            EipMPost record = AccountUtils.getEipMPost(rundata, context);
            if (record == null) {
                return false;
            }
            this.post_name.setValue(record.getPostName());
            if (record.getZipcode() != null && (token = new StringTokenizer(record.getZipcode(), "-")).countTokens() == 2) {
                this.zipcode1.setValue(token.nextToken());
                this.zipcode2.setValue(token.nextToken());
            }
            this.address.setValue(record.getAddress());
            if (record.getOutTelephone() != null && (token = new StringTokenizer(record.getOutTelephone(), "-")).countTokens() == 3) {
                this.post_out_telephone1.setValue(token.nextToken());
                this.post_out_telephone2.setValue(token.nextToken());
                this.post_out_telephone3.setValue(token.nextToken());
            }
            this.post_in_telephone.setValue(record.getInTelephone());
            if (record.getFaxNumber() != null && (token = new StringTokenizer(record.getFaxNumber(), "-")).countTokens() == 3) {
                this.fax_number1.setValue(token.nextToken());
                this.fax_number2.setValue(token.nextToken());
                this.fax_number3.setValue(token.nextToken());
            }
            this.post_id = record.getPostId();
            if (this.is_join_member) {
                SelectQuery query = new SelectQuery(TurbineGroup.class);
                Expression exp = ExpressionFactory.matchExp((String)"groupAliasName", (Object)this.post_name);
                query.setQualifier(exp);
                DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
                List list = dataContext.performQuery((Query)query);
                TurbineGroup tg = (TurbineGroup)list.get(0);
                this.memberList.addAll(ALEipUtils.getUsers((String)tg.getGroupName()));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            if (this.dataContext == null) {
                this.dataContext = DatabaseOrmService.getInstance().getDataContext();
            }
            TurbineGroup group = (TurbineGroup)this.dataContext.createAndRegisterNewObject(TurbineGroup.class);
            String name = this.post_name.getValue();
            String groupName = new StringBuffer().append(new Date().getTime()).append("_").append(ALEipUtils.getUserId((RunData)rundata)).toString();
            group.setGroupName(groupName);
            group.setOwnerId(Integer.valueOf(ALEipUtils.getUserId((RunData)rundata)));
            group.setGroupAliasName(name);
            group.setPublicFlag("1");
            JetspeedSecurity.addGroup((Group)group);
            EipMPost record = (EipMPost)this.dataContext.createAndRegisterNewObject(EipMPost.class);
            record.setPostName(this.post_name.getValue());
            record.setCompanyId(Integer.valueOf(1));
            if (!this.zipcode1.getValue().equals("") && !this.zipcode2.getValue().equals("")) {
                record.setZipcode(new StringBuffer().append(this.zipcode1.getValue()).append("-").append(this.zipcode2.getValue()).toString());
            } else {
                record.setZipcode("");
            }
            record.setAddress(this.address.getValue());
            if (!(this.post_out_telephone1.getValue().equals("") || this.post_out_telephone2.getValue().equals("") || this.post_out_telephone3.getValue().equals(""))) {
                record.setOutTelephone(new StringBuffer().append(this.post_out_telephone1.getValue()).append("-").append(this.post_out_telephone2.getValue()).append("-").append(this.post_out_telephone3.getValue()).toString());
            } else {
                record.setOutTelephone("");
            }
            record.setInTelephone(this.post_in_telephone.getValue());
            if (!(this.fax_number1.getValue().equals("") || this.fax_number2.getValue().equals("") || this.fax_number3.getValue().equals(""))) {
                record.setFaxNumber(new StringBuffer().append(this.fax_number1.getValue()).append("-").append(this.fax_number2.getValue()).append("-").append(this.fax_number3.getValue()).toString());
            } else {
                record.setFaxNumber("");
            }
            record.setGroupName(groupName);
            Date now = new Date();
            record.setCreateDate(now);
            record.setUpdateDate(now);
            this.dataContext.commitChanges();
            ALEipManager.getInstance().reloadPost();
            if (this.is_join_member) {
                int size = this.memberList.size();
                for (int i = 0; i < size; ++i) {
                    ALEipUtils.changePost((RunData)rundata, (String)((ALEipUser)this.memberList.get(i)).getName().getValue(), (int)record.getPostId());
                }
            }
            this.post_id = record.getPostId();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipMPost record = AccountUtils.getEipMPost(rundata, context);
            if (record == null) {
                return false;
            }
            record.setPostName(this.post_name.getValue());
            if (!this.zipcode1.getValue().equals("") && !this.zipcode2.getValue().equals("")) {
                record.setZipcode(new StringBuffer().append(this.zipcode1.getValue()).append("-").append(this.zipcode2.getValue()).toString());
            } else {
                record.setZipcode("");
            }
            record.setAddress(this.address.getValue());
            if (!(this.post_out_telephone1.getValue().equals("") || this.post_out_telephone2.getValue().equals("") || this.post_out_telephone3.getValue().equals(""))) {
                record.setOutTelephone(new StringBuffer().append(this.post_out_telephone1.getValue()).append("-").append(this.post_out_telephone2.getValue()).append("-").append(this.post_out_telephone3.getValue()).toString());
            } else {
                record.setOutTelephone("");
            }
            record.setInTelephone(this.post_in_telephone.getValue());
            if (!(this.fax_number1.getValue().equals("") || this.fax_number2.getValue().equals("") || this.fax_number3.getValue().equals(""))) {
                record.setFaxNumber(new StringBuffer().append(this.fax_number1.getValue()).append("-").append(this.fax_number2.getValue()).append("-").append(this.fax_number3.getValue()).toString());
            } else {
                record.setFaxNumber("");
            }
            record.setUpdateDate(new Date());
            this.dataContext.commitChanges();
            this.post_id = record.getPostId();
            TurbineGroup group = (TurbineGroup)JetspeedSecurity.getGroup((String)record.getGroupName());
            if (group == null) {
                return false;
            }
            group.setGroupAliasName(this.post_name.getValue());
            JetspeedSecurity.saveGroup((Group)group);
            ALEipManager.getInstance().reloadPost();
            if (this.is_join_member) {
                int i;
                List users = ALEipUtils.getUsers((String)record.getGroupName());
                int size = users.size();
                for (i = 0; i < size; ++i) {
                    JetspeedSecurity.unjoinGroup((String)((ALEipUser)users.get(i)).getName().getValue(), (String)record.getGroupName());
                }
                size = this.memberList.size();
                for (i = 0; i < size; ++i) {
                    ALEipUtils.changePost((RunData)rundata, (String)((ALEipUser)this.memberList.get(i)).getName().getValue(), (int)record.getPostId());
                }
            }
            this.dataContext.commitChanges();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipMPost record = AccountUtils.getEipMPost(rundata, context);
            if (record == null) {
                return false;
            }
            List users = ALEipUtils.getUsers((String)record.getGroupName());
            int size = users.size();
            for (int i = 0; i < size; ++i) {
                JetspeedSecurity.unjoinGroup((String)((ALEipUser)users.get(i)).getName().getValue(), (String)record.getGroupName());
            }
            JetspeedSecurity.removeGroup((String)record.getGroupName());
            this.dataContext.deleteObject((Persistent)record);
            this.dataContext.commitChanges();
            ALEipManager.getInstance().reloadPost();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public ALStringField getPostName() {
        return this.post_name;
    }

    public ALStringField getAddress() {
        return this.address;
    }

    public ALStringField getFaxNumber1() {
        return this.fax_number1;
    }

    public ALStringField getFaxNumber2() {
        return this.fax_number2;
    }

    public ALStringField getFaxNumber3() {
        return this.fax_number3;
    }

    public ALStringField getOutTelephone1() {
        return this.post_out_telephone1;
    }

    public ALStringField getOutTelephone2() {
        return this.post_out_telephone2;
    }

    public ALStringField getOutTelephone3() {
        return this.post_out_telephone3;
    }

    public ALStringField getInTelephone() {
        return this.post_in_telephone;
    }

    public ALStringField getZipcode1() {
        return this.zipcode1;
    }

    public ALStringField getZipcode2() {
        return this.zipcode2;
    }

    public ArrayList getMemberList() {
        return this.memberList;
    }

    public ALStringField getGroupName() {
        return this.group_name;
    }

    public List getUsers(String groupname) {
        try {
            return ALEipUtils.getUsers((String)groupname);
        }
        catch (Exception e) {
            logger.error((Object)"[ERROR}", (Throwable)e);
            return new ArrayList();
        }
    }

    public Map getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public void setJoinMember(boolean bool) {
        this.is_join_member = bool;
    }

    public boolean isJoinMember() {
        return this.is_join_member;
    }

    public int getPostId() {
        return this.post_id;
    }
}

