/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.account;

import com.aimluck.eip.cayenne.om.account.EipMPosition;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.orm.DatabaseOrmService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AccountPositionMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AccountPositionMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, ArrayList values, ArrayList msgList) {
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        try {
            List list = this.getEipMPositions(rundata, context, dataContext, values);
            if (list == null || list.size() == 0) {
                return false;
            }
            EipMPosition position = null;
            ArrayList<Integer> ids = new ArrayList<Integer>();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                position = (EipMPosition)list.get(i);
                ids.add(position.getPositionId());
            }
            Expression exp = ExpressionFactory.inDbExp((String)"POSITION_ID", ids);
            SelectQuery query = new SelectQuery(EipMPosition.class, exp);
            List postisions = dataContext.performQuery((Query)query);
            int psize = postisions.size();
            for (int i = 0; i < psize; ++i) {
                dataContext.deleteObject((Persistent)((EipMPosition)list.get(i)));
            }
            int idssize = ids.size();
            for (int i = 0; i < idssize; ++i) {
                String sql = "UPDATE TURBINE_USER set POSITION_ID = 0 where POSITION_ID = " + (Integer)ids.get(i);
                SQLTemplate rawSelect = new SQLTemplate(TurbineUser.class, sql, false);
                dataContext.performQuery((Query)rawSelect);
            }
            dataContext.commitChanges();
            ALEipManager.getInstance().reloadPosition();
        }
        catch (Exception ex) {
            dataContext.rollbackChanges();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    private List getEipMPositions(RunData rundata, Context context, DataContext dataContext, ArrayList values) {
        List list = null;
        try {
            if (values == null || values.size() == 0) {
                logger.debug((Object)"values are empty...");
                return null;
            }
            Expression exp = ExpressionFactory.inDbExp((String)"POSITION_ID", (Collection)values);
            SelectQuery query = new SelectQuery(EipMPosition.class, exp);
            list = dataContext.performQuery((Query)query);
            if (list == null || list.size() == 0) {
                logger.debug((Object)"Not found ID...");
                return null;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            list = null;
        }
        return list;
    }
}

