/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.account;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.account.util.AccountUtils;
import com.aimluck.eip.cayenne.om.account.EipMPosition;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Date;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AccountPositionFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AccountPositionFormData.class.getName());
    private ALStringField position_name;
    private int position_id;
    private DataContext dataContext;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
    }

    public void initField() {
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        this.position_name = new ALStringField();
        this.position_name.setFieldName("\u5f79\u8077\u540d");
        this.position_name.setTrim(true);
    }

    protected void setValidator() {
        this.position_name.setNotNull(true);
        this.position_name.limitMaxLength(50);
    }

    protected boolean setFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (res) {
            try {
                if ("update".equals(this.getMode())) {
                    this.position_id = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid"));
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Exception", (Throwable)ex);
            }
        }
        return res;
    }

    protected boolean validate(ArrayList msgList) {
        this.position_name.validate(msgList);
        try {
            SelectQuery query = new SelectQuery(EipMPosition.class);
            if ("insert".equals(this.getMode())) {
                Expression exp = ExpressionFactory.matchExp((String)"positionName", (Object)this.position_name.getValue());
                query.setQualifier(exp);
            } else if ("update".equals(this.getMode())) {
                Expression exp1 = ExpressionFactory.matchExp((String)"positionName", (Object)this.position_name.getValue());
                query.setQualifier(exp1);
                Expression exp2 = ExpressionFactory.noMatchDbExp((String)"POSITION_ID", (Object)this.position_id);
                query.andQualifier(exp2);
            }
            if (this.dataContext.performQuery((Query)query).size() != 0) {
                msgList.add("\u5f79\u8077\u540d\u300e <span class='em'>" + this.position_name + "</span> \u300f\u306f\u65e2\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipMPosition record = AccountUtils.getEipMPosition(rundata, context);
            if (record == null) {
                return false;
            }
            this.position_name.setValue(record.getPositionName());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            if (this.dataContext == null) {
                this.dataContext = DatabaseOrmService.getInstance().getDataContext();
            }
            EipMPosition position = (EipMPosition)this.dataContext.createAndRegisterNewObject(EipMPosition.class);
            position.setPositionName(this.position_name.getValue());
            Date now = new Date();
            position.setCreateDate(now);
            position.setUpdateDate(now);
            this.dataContext.commitChanges();
            this.position_id = position.getPositionId();
            ALEipManager.getInstance().reloadPosition();
        }
        catch (Exception ex) {
            this.dataContext.rollbackChanges();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipMPosition record = AccountUtils.getEipMPosition(rundata, context);
            if (record == null) {
                return false;
            }
            record.setPositionName(this.position_name.getValue());
            record.setUpdateDate(new Date());
            this.dataContext.commitChanges();
            ALEipManager.getInstance().reloadPosition();
        }
        catch (Exception ex) {
            this.dataContext.rollbackChanges();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipMPosition record = AccountUtils.getEipMPosition(rundata, context);
            if (record == null) {
                return false;
            }
            this.dataContext.deleteObject((Persistent)record);
            this.dataContext.commitChanges();
            String id = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            String sql = "UPDATE TURBINE_USER set POSITION_ID = 0 where POSITION_ID = " + id;
            SQLTemplate rawSelect = new SQLTemplate(TurbineUser.class, sql, false);
            this.dataContext.performQuery((Query)rawSelect);
            ALEipManager.getInstance().reloadPosition();
        }
        catch (Exception ex) {
            this.dataContext.rollbackChanges();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public ALStringField getPositionName() {
        return this.position_name;
    }

    public int getPositionId() {
        return this.position_id;
    }
}

