/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.account;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AccountEditFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AccountEditFormData.class.getName());
    private ALStringField firstname;
    private ALStringField lastname;
    private ALStringField email;
    private ALStringField in_telephone;
    private ALStringField out_telephone1;
    private ALStringField out_telephone2;
    private ALStringField out_telephone3;
    private ALStringField cellular_phone1;
    private ALStringField cellular_phone2;
    private ALStringField cellular_phone3;
    private ALStringField cellular_mail;
    private ALStringField first_name_kana;
    private ALStringField last_name_kana;
    private ALStringField photo = null;
    private FileuploadLiteBean filebean = null;
    private String folderName = null;
    private String org_id;
    private byte[] facePhoto;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"entityid", (String)rundata.getUser().getUserName());
        }
        this.folderName = rundata.getParameters().getString("folderName");
        this.org_id = DatabaseOrmService.getInstance().getOrgId(rundata);
    }

    public void initField() {
        this.firstname = new ALStringField();
        this.firstname.setFieldName("\u540d\u524d\uff08\u540d\uff09");
        this.firstname.setTrim(true);
        this.lastname = new ALStringField();
        this.lastname.setFieldName("\u540d\u524d\uff08\u59d3\uff09");
        this.lastname.setTrim(true);
        this.email = new ALStringField();
        this.email.setFieldName("\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9");
        this.email.setTrim(true);
        this.in_telephone = new ALStringField();
        this.in_telephone.setFieldName("\u96fb\u8a71\u756a\u53f7\uff08\u5185\u7dda\uff09");
        this.in_telephone.setTrim(true);
        this.out_telephone1 = new ALStringField();
        this.out_telephone1.setFieldName("\u96fb\u8a71\u756a\u53f7\uff08\u5916\u7dda\uff09");
        this.out_telephone1.setTrim(true);
        this.out_telephone2 = new ALStringField();
        this.out_telephone2.setFieldName("\u96fb\u8a71\u756a\u53f7\uff08\u5916\u7dda\uff09");
        this.out_telephone2.setTrim(true);
        this.out_telephone3 = new ALStringField();
        this.out_telephone3.setFieldName("\u96fb\u8a71\u756a\u53f7\uff08\u5916\u7dda\uff09");
        this.out_telephone3.setTrim(true);
        this.cellular_phone1 = new ALStringField();
        this.cellular_phone1.setFieldName("\u96fb\u8a71\u756a\u53f7\uff08\u643a\u5e2f\uff09");
        this.cellular_phone1.setTrim(true);
        this.cellular_phone2 = new ALStringField();
        this.cellular_phone2.setFieldName("\u96fb\u8a71\u756a\u53f7\uff08\u643a\u5e2f\uff09");
        this.cellular_phone2.setTrim(true);
        this.cellular_phone3 = new ALStringField();
        this.cellular_phone3.setFieldName("\u96fb\u8a71\u756a\u53f7\uff08\u643a\u5e2f\uff09");
        this.cellular_phone3.setTrim(true);
        this.cellular_mail = new ALStringField();
        this.cellular_mail.setFieldName("\u643a\u5e2f\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9");
        this.cellular_mail.setTrim(true);
        this.first_name_kana = new ALStringField();
        this.first_name_kana.setFieldName("\u30d5\u30ea\u30ac\u30ca\uff08\u540d\uff09");
        this.first_name_kana.setTrim(true);
        this.last_name_kana = new ALStringField();
        this.last_name_kana.setFieldName("\u30d5\u30ea\u30ac\u30ca\uff08\u59d3\uff09");
        this.last_name_kana.setTrim(true);
        this.photo = new ALStringField();
        this.photo.setFieldName("\u9854\u5199\u771f");
        this.photo.setTrim(true);
    }

    protected boolean setFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        try {
            ArrayList fileBeanList;
            if (res && (fileBeanList = FileuploadUtils.getFileuploadList((RunData)rundata)) != null && fileBeanList.size() > 0) {
                this.filebean = (FileuploadLiteBean)fileBeanList.get(0);
                if (this.filebean.getFileId() > 0) {
                    String[] acceptExts = ImageIO.getWriterFormatNames();
                    this.facePhoto = FileuploadUtils.getBytesShrinkFilebean((String)this.org_id, (String)this.folderName, (int)ALEipUtils.getUserId((RunData)rundata), (FileuploadLiteBean)this.filebean, (String[])acceptExts, (int)86, (int)86, (ArrayList)msgList);
                } else {
                    this.facePhoto = null;
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            res = false;
        }
        return res;
    }

    protected void setValidator() {
        this.firstname.setNotNull(true);
        this.firstname.limitMaxLength(50);
        this.lastname.setNotNull(true);
        this.lastname.limitMaxLength(50);
        this.first_name_kana.setNotNull(true);
        this.first_name_kana.limitMaxLength(50);
        this.last_name_kana.setNotNull(true);
        this.last_name_kana.limitMaxLength(50);
        this.in_telephone.setCharacterType(19);
        this.in_telephone.limitMaxLength(13);
        this.email.setCharacterType(19);
        this.out_telephone1.setCharacterType(2);
        this.out_telephone1.limitMaxLength(5);
        this.out_telephone2.setCharacterType(2);
        this.out_telephone2.limitMaxLength(4);
        this.out_telephone3.setCharacterType(2);
        this.out_telephone3.limitMaxLength(4);
        this.cellular_phone1.setCharacterType(2);
        this.cellular_phone1.limitMaxLength(5);
        this.cellular_phone2.setCharacterType(2);
        this.cellular_phone2.limitMaxLength(4);
        this.cellular_phone3.setCharacterType(2);
        this.cellular_phone3.limitMaxLength(4);
        this.cellular_mail.setCharacterType(19);
        this.cellular_mail.limitMaxLength(50);
    }

    protected boolean validate(ArrayList msgList) {
        ArrayList dummy = new ArrayList();
        this.firstname.validate(msgList);
        this.lastname.validate(msgList);
        this.first_name_kana.setValue(ALStringUtil.convertHiragana2Katakana((String)ALStringUtil.convertH2ZKana((String)this.first_name_kana.toString())));
        this.last_name_kana.setValue(ALStringUtil.convertHiragana2Katakana((String)ALStringUtil.convertH2ZKana((String)this.last_name_kana.toString())));
        this.first_name_kana.validate(msgList);
        this.last_name_kana.validate(msgList);
        this.in_telephone.validate(msgList);
        this.email.validate(msgList);
        if (this.email.getValue() != null && this.email.getValue().trim().length() > 0 && !ALStringUtil.isMailAddress((String)this.email.getValue())) {
            msgList.add("\u300e <span class='em'> \u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9 </span>\u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        this.cellular_mail.validate(msgList);
        if (this.cellular_mail.getValue().trim().length() > 0 && !ALStringUtil.isCellPhoneMailAddress((String)this.cellular_mail.getValue())) {
            msgList.add("\u300e <span class='em'> \u643a\u5e2f\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9 </span>\u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        if (!(this.out_telephone1.getValue().equals("") && this.out_telephone2.getValue().equals("") && this.out_telephone3.getValue().equals("") || this.out_telephone1.validate(dummy) && this.out_telephone2.validate(dummy) && this.out_telephone3.validate(dummy))) {
            msgList.add("\u300e <span class='em'>\u96fb\u8a71\u756a\u53f7\uff08\u5916\u7dda\uff09</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        if (!(this.cellular_phone1.getValue().equals("") && this.cellular_phone2.getValue().equals("") && this.cellular_phone3.getValue().equals("") || this.cellular_phone1.validate(dummy) && this.cellular_phone2.validate(dummy) && this.cellular_phone3.validate(dummy))) {
            msgList.add("\u300e <span class='em'>\u96fb\u8a71\u756a\u53f7\uff08\u643a\u5e2f\uff09</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        if (this.filebean != null && this.filebean.getFileId() > 0 && this.facePhoto == null) {
            msgList.add("\u300e <span class='em'>\u9854\u5199\u771f</span> \u300f\u306b\u306fJpeg\u753b\u50cf\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            StringTokenizer token;
            ALBaseUser user = (ALBaseUser)rundata.getUser();
            if (user == null) {
                logger.debug((Object)("Not found. (" + AccountEditFormData.class.getName() + ")"));
                return false;
            }
            this.firstname.setValue(user.getFirstName());
            this.lastname.setValue(user.getLastName());
            this.email.setValue(user.getEmail());
            this.in_telephone.setValue(user.getInTelephone());
            if (user.getOutTelephone() != null && (token = new StringTokenizer(user.getOutTelephone(), "-")).countTokens() == 3) {
                this.out_telephone1.setValue(token.nextToken());
                this.out_telephone2.setValue(token.nextToken());
                this.out_telephone3.setValue(token.nextToken());
            }
            if (user.getCellularPhone() != null && (token = new StringTokenizer(user.getCellularPhone(), "-")).countTokens() == 3) {
                this.cellular_phone1.setValue(token.nextToken());
                this.cellular_phone2.setValue(token.nextToken());
                this.cellular_phone3.setValue(token.nextToken());
            }
            this.cellular_mail.setValue(user.getCellularMail());
            this.first_name_kana.setValue(user.getFirstNameKana());
            this.last_name_kana.setValue(user.getLastNameKana());
            if (user.getPhoto() != null) {
                this.filebean = new FileuploadLiteBean();
                this.filebean.initField();
                this.filebean.setFolderName("");
                this.filebean.setFileId(0);
                this.filebean.setFileName("\u4ee5\u524d\u306e\u5199\u771f\u30d5\u30a1\u30a4\u30eb");
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return false;
        }
    }

    public void loadEmail(RunData rundata) {
        try {
            ALBaseUser user = (ALBaseUser)rundata.getUser();
            if (user == null) {
                logger.debug((Object)("Not found. (" + AccountEditFormData.class.getName() + ")"));
                this.email.setValue("");
            } else {
                this.email.setValue(user.getEmail());
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
        }
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            ALBaseUser user = (ALBaseUser)rundata.getUser();
            if (user == null) {
                return false;
            }
            user.setLastAccessDate();
            user.setFirstName(this.firstname.getValue());
            user.setLastName(this.lastname.getValue());
            user.setInTelephone(this.in_telephone.getValue());
            if (!(this.out_telephone1.getValue().equals("") || this.out_telephone2.getValue().equals("") || this.out_telephone3.getValue().equals(""))) {
                user.setOutTelephone(new StringBuffer().append(this.out_telephone1.getValue()).append("-").append(this.out_telephone2.getValue()).append("-").append(this.out_telephone3.getValue()).toString());
            } else {
                user.setOutTelephone("");
            }
            if (!(this.cellular_phone1.getValue().equals("") || this.cellular_phone2.getValue().equals("") || this.cellular_phone3.getValue().equals(""))) {
                user.setCellularPhone(new StringBuffer().append(this.cellular_phone1.getValue()).append("-").append(this.cellular_phone2.getValue()).append("-").append(this.cellular_phone3.getValue()).toString());
            } else {
                user.setCellularPhone("");
            }
            user.setCellularMail(this.cellular_mail.getValue());
            user.setFirstNameKana(this.first_name_kana.getValue());
            user.setLastNameKana(this.last_name_kana.getValue());
            user.setEmail(this.email.getValue());
            if (this.filebean != null) {
                if (this.filebean.getFileId() > 0) {
                    user.setPhoto(this.facePhoto);
                }
            } else {
                user.setPhoto(null);
            }
            JetspeedSecurity.saveUser((JetspeedUser)user);
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(Integer.valueOf(user.getUserId()).intValue(), 260, null);
            File folder = FileuploadUtils.getFolder((String)this.org_id, (int)ALEipUtils.getUserId((RunData)rundata), (String)this.folderName);
            FileuploadUtils.deleteFolder((File)folder);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return false;
        }
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    public boolean doDeleteAttachments(ALAction action, RunData rundata, Context context, String mode) {
        try {
            this.init(action, rundata, context);
            action.setMode(mode);
            ArrayList msgList = new ArrayList();
            this.setValidator();
            boolean res = this.setFormData(rundata, context, msgList) && this.deleteAttachments(rundata, context, msgList);
            action.setResultData((Object)this);
            action.addErrorMessages(msgList);
            action.putData(rundata, context);
            return res;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    protected boolean deleteAttachments(RunData rundata, Context context, ArrayList msgList) {
        if (rundata == null || context == null) {
            msgList.add("\u30b7\u30b9\u30c6\u30e0\u4e0a\u306e\u554f\u984c\u306e\u305f\u3081\u3001\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            return false;
        }
        int userId = ALEipUtils.getUserId((RunData)rundata);
        ArrayList<FileuploadLiteBean> fileBeanList = new ArrayList<FileuploadLiteBean>();
        fileBeanList.add(this.filebean);
        return FileuploadUtils.deleteAttachments((String)this.org_id, (int)userId, (String)this.folderName, fileBeanList);
    }

    public ALStringField getCellularMail() {
        return this.cellular_mail;
    }

    public ALStringField getEmail() {
        return this.email;
    }

    public ALStringField getFirstNameKana() {
        return this.first_name_kana;
    }

    public ALStringField getFirstName() {
        return this.firstname;
    }

    public ALStringField getInTelephone() {
        return this.in_telephone;
    }

    public ALStringField getLastNameKana() {
        return this.last_name_kana;
    }

    public ALStringField getLastName() {
        return this.lastname;
    }

    public ALStringField getCellularPhone1() {
        return this.cellular_phone1;
    }

    public ALStringField getCellularPhone2() {
        return this.cellular_phone2;
    }

    public ALStringField getCellularPhone3() {
        return this.cellular_phone3;
    }

    public ALStringField getOutTelephone1() {
        return this.out_telephone1;
    }

    public ALStringField getOutTelephone2() {
        return this.out_telephone2;
    }

    public ALStringField getOutTelephone3() {
        return this.out_telephone3;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public List getAttachmentFileNameList() {
        if (this.filebean == null) {
            return null;
        }
        ArrayList<FileuploadLiteBean> list = new ArrayList<FileuploadLiteBean>();
        list.add(this.filebean);
        return list;
    }
}

