/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.account;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.account.util.AccountUtils;
import com.aimluck.eip.cayenne.om.account.EipMCompany;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.cayenne.access.DataContext;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AccountCompanyFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AccountCompanyFormData.class.getName());
    private ALStringField company_name;
    private ALStringField zipcode1;
    private ALStringField zipcode2;
    private ALStringField address;
    private ALStringField telephone1;
    private ALStringField telephone2;
    private ALStringField telephone3;
    private ALStringField fax_number1;
    private ALStringField fax_number2;
    private ALStringField fax_number3;
    private DataContext dataContext;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
    }

    public void initField() {
        this.company_name = new ALStringField();
        this.company_name.setFieldName("\u4f1a\u793e\u540d");
        this.company_name.setTrim(true);
        this.zipcode1 = new ALStringField();
        this.zipcode1.setFieldName("\u90f5\u4fbf\u756a\u53f7");
        this.zipcode1.setTrim(true);
        this.zipcode2 = new ALStringField();
        this.zipcode2.setFieldName("\u90f5\u4fbf\u756a\u53f7");
        this.zipcode2.setTrim(true);
        this.address = new ALStringField();
        this.address.setFieldName("\u4f4f\u6240");
        this.address.setTrim(true);
        this.telephone1 = new ALStringField();
        this.telephone1.setFieldName("\u96fb\u8a71\u756a\u53f7");
        this.telephone1.setTrim(true);
        this.telephone2 = new ALStringField();
        this.telephone2.setFieldName("\u96fb\u8a71\u756a\u53f7");
        this.telephone2.setTrim(true);
        this.telephone3 = new ALStringField();
        this.telephone3.setFieldName("\u96fb\u8a71\u756a\u53f7");
        this.telephone3.setTrim(true);
        this.fax_number1 = new ALStringField();
        this.fax_number1.setFieldName("FAX\u756a\u53f7");
        this.fax_number1.setTrim(true);
        this.fax_number2 = new ALStringField();
        this.fax_number2.setFieldName("FAX\u756a\u53f7");
        this.fax_number2.setTrim(true);
        this.fax_number3 = new ALStringField();
        this.fax_number3.setFieldName("FAX\u756a\u53f7");
        this.fax_number3.setTrim(true);
    }

    protected void setValidator() {
        this.company_name.setNotNull(true);
        this.company_name.limitMaxLength(50);
        this.address.limitMaxLength(60);
        this.zipcode1.setCharacterType(2);
        this.zipcode1.limitLength(3, 3);
        this.zipcode2.setCharacterType(2);
        this.zipcode2.limitLength(4, 4);
        this.telephone1.setCharacterType(2);
        this.telephone1.limitMaxLength(5);
        this.telephone2.setCharacterType(2);
        this.telephone2.limitMaxLength(4);
        this.telephone3.setCharacterType(2);
        this.telephone3.limitMaxLength(4);
        this.fax_number1.setCharacterType(2);
        this.fax_number1.limitMaxLength(5);
        this.fax_number2.setCharacterType(2);
        this.fax_number2.limitMaxLength(4);
        this.fax_number3.setCharacterType(2);
        this.fax_number3.limitMaxLength(4);
    }

    protected boolean validate(ArrayList msgList) {
        ArrayList dummy = new ArrayList();
        this.company_name.validate(msgList);
        this.address.validate(msgList);
        if (!(this.zipcode1.getValue().equals("") && this.zipcode2.getValue().equals("") || this.zipcode1.validate(dummy) && this.zipcode2.validate(dummy))) {
            msgList.add("\u300e <span class='em'>\u90f5\u4fbf\u756a\u53f7</span> \u300f\u306f7\u6841\u306e\u534a\u89d2\u6570\u5b57\u3067\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        if (!(this.telephone1.getValue().equals("") && this.telephone2.getValue().equals("") && this.telephone3.getValue().equals("") || this.telephone1.validate(dummy) && this.telephone2.validate(dummy) && this.telephone3.validate(dummy))) {
            msgList.add("\u300e <span class='em'>\u96fb\u8a71\u756a\u53f7</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        if (!(this.fax_number1.getValue().equals("") && this.fax_number2.getValue().equals("") && this.fax_number3.getValue().equals("") || this.fax_number1.validate(dummy) && this.fax_number2.validate(dummy) && this.fax_number3.validate(dummy))) {
            msgList.add("\u300e <span class='em'>FAX\u756a\u53f7</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            StringTokenizer token;
            EipMCompany record = AccountUtils.getEipMCompany(rundata, context);
            if (record == null) {
                return false;
            }
            this.company_name.setValue(record.getCompanyName());
            if (record.getZipcode() != null && (token = new StringTokenizer(record.getZipcode(), "-")).countTokens() == 2) {
                this.zipcode1.setValue(token.nextToken());
                this.zipcode2.setValue(token.nextToken());
            }
            this.address.setValue(record.getAddress());
            if (record.getTelephone() != null && (token = new StringTokenizer(record.getTelephone(), "-")).countTokens() == 3) {
                this.telephone1.setValue(token.nextToken());
                this.telephone2.setValue(token.nextToken());
                this.telephone3.setValue(token.nextToken());
            }
            if (record.getFaxNumber() != null && (token = new StringTokenizer(record.getFaxNumber(), "-")).countTokens() == 3) {
                this.fax_number1.setValue(token.nextToken());
                this.fax_number2.setValue(token.nextToken());
                this.fax_number3.setValue(token.nextToken());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipMCompany record = AccountUtils.getEipMCompany(rundata, context);
            if (record == null) {
                return false;
            }
            record.setCompanyName(this.company_name.getValue());
            if (!this.zipcode1.getValue().equals("") && !this.zipcode2.getValue().equals("")) {
                record.setZipcode(new StringBuffer().append(this.zipcode1.getValue()).append("-").append(this.zipcode2.getValue()).toString());
            } else {
                record.setZipcode("");
            }
            record.setAddress(this.address.getValue());
            if (!(this.telephone1.getValue().equals("") || this.telephone2.getValue().equals("") || this.telephone3.getValue().equals(""))) {
                record.setTelephone(new StringBuffer().append(this.telephone1.getValue()).append("-").append(this.telephone2.getValue()).append("-").append(this.telephone3.getValue()).toString());
            } else {
                record.setTelephone("");
            }
            if (!(this.fax_number1.getValue().equals("") || this.fax_number2.getValue().equals("") || this.fax_number3.getValue().equals(""))) {
                record.setFaxNumber(new StringBuffer().append(this.fax_number1.getValue()).append("-").append(this.fax_number2.getValue()).append("-").append(this.fax_number3.getValue()).toString());
            } else {
                record.setFaxNumber("");
            }
            record.setUpdateDate(new Date());
            this.dataContext.commitChanges();
            ALEipManager.getInstance().reloadCompany();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    public ALStringField getAddress() {
        return this.address;
    }

    public ALStringField getCompanyName() {
        return this.company_name;
    }

    public ALStringField getFaxNumber1() {
        return this.fax_number1;
    }

    public ALStringField getFaxNumber2() {
        return this.fax_number2;
    }

    public ALStringField getFaxNumber3() {
        return this.fax_number3;
    }

    public ALStringField getTelephone1() {
        return this.telephone1;
    }

    public ALStringField getTelephone2() {
        return this.telephone2;
    }

    public ALStringField getTelephone3() {
        return this.telephone3;
    }

    public ALStringField getZipcode1() {
        return this.zipcode1;
    }

    public ALStringField getZipcode2() {
        return this.zipcode2;
    }
}

