/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.account;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.account.EipMUserPosition;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AccountChangeTurnFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AccountChangeTurnFormData.class.getName());
    private ALStringField positions;
    private String[] userNames = null;
    private List userList = null;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.userList = new ArrayList();
    }

    public void initField() {
        this.positions = new ALStringField();
        this.positions.setFieldName("\u30e6\u30fc\u30b6\u540d\u30ea\u30b9\u30c8");
        this.positions.setTrim(true);
    }

    protected boolean setFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = true;
        try {
            res = super.setFormData(rundata, context, msgList);
            if (res) {
                if (this.positions.getValue() == null || this.positions.getValue().equals("")) {
                    this.userList = ALEipUtils.getUsers((String)"LoginUser");
                } else {
                    StringTokenizer st = new StringTokenizer(this.positions.getValue(), ",");
                    this.userNames = new String[st.countTokens()];
                    int count = 0;
                    while (st.hasMoreTokens()) {
                        this.userNames[count] = st.nextToken();
                        ++count;
                    }
                    DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
                    SelectQuery query = new SelectQuery(TurbineUser.class);
                    Expression exp1 = ExpressionFactory.inExp((String)"loginName", (Object[])this.userNames);
                    Expression exp2 = ExpressionFactory.matchExp((String)"disabled", (Object)"F");
                    query.setQualifier(exp1);
                    query.andQualifier(exp2);
                    List list = dataContext.performQuery((Query)query);
                    TurbineUser turbineUser = null;
                    int length = this.userNames.length;
                    for (int i = 0; i < length; ++i) {
                        turbineUser = this.getEipUserRecord(list, this.userNames[i]);
                        ALEipUser user = new ALEipUser();
                        user.initField();
                        user.setName(turbineUser.getLoginName());
                        user.setAliasName(turbineUser.getFirstName(), turbineUser.getLastName());
                        this.userList.add(user);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return res;
    }

    protected void setValidator() {
    }

    protected boolean validate(ArrayList msgList) {
        if (this.positions.getValue() != null && !this.positions.getValue().equals("")) {
            StringTokenizer st = new StringTokenizer(this.positions.getValue(), ",");
            ALStringField field = null;
            while (st.hasMoreTokens()) {
                field = new ALStringField();
                field.setTrim(true);
                field.setValue(st.nextToken());
                field.limitMaxLength(16);
                field.setCharacterType(3);
                field.validate(msgList);
            }
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return false;
        }
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        boolean res = true;
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            Expression exp1 = ExpressionFactory.inExp((String)"loginName", (Object[])this.userNames);
            SelectQuery query = new SelectQuery(TurbineUser.class, exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"disabled", (Object)"F");
            query.addOrdering("eipMUserPosition.position", true);
            query.andQualifier(exp2);
            List list = dataContext.performQuery((Query)query);
            LinkedHashMap<TurbineUser, Integer> map = new LinkedHashMap<TurbineUser, Integer>();
            TurbineUser currentUser = null;
            int length = this.userNames.length;
            for (int i = 0; i < length; ++i) {
                currentUser = (TurbineUser)list.get(i);
                if (currentUser.getLoginName().equals(this.userNames[i])) continue;
                map.put(this.getEipUserRecord(list, this.userNames[i]), i + 1);
            }
            TurbineUser key = null;
            Integer value = null;
            Map.Entry entry2 = null;
            for (Map.Entry entry2 : map.entrySet()) {
                key = (TurbineUser)entry2.getKey();
                value = (Integer)entry2.getValue();
                EipMUserPosition userPosition = key.getEipMUserPosition();
                userPosition.setPosition(value);
            }
            dataContext.commitChanges();
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            res = false;
        }
        return res;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    private TurbineUser getEipUserRecord(List userList, String userName) {
        int size = userList.size();
        for (int i = 0; i < size; ++i) {
            TurbineUser record = (TurbineUser)userList.get(i);
            if (!record.getLoginName().equals(userName)) continue;
            return record;
        }
        return null;
    }

    public List getUserList() {
        return this.userList;
    }
}

