/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.accessctl.action;

import com.aimluck.eip.cayenne.om.account.EipTAclRole;
import com.aimluck.eip.cayenne.om.account.EipTAclUserRoleMap;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.DataObjectUtils;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;

public class ALActionAccessControlHandler
extends ALAccessControlHandler {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALActionAccessControlHandler.class.getName());

    public boolean hasAuthority(int userId, String featerName, int aclType) {
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        SelectQuery query = new SelectQuery(EipTAclRole.class);
        Expression exp11 = ExpressionFactory.matchDbExp((String)"eipTAclUserRoleMaps.turbineUser.USER_ID", (Object)userId);
        Expression exp12 = ExpressionFactory.matchExp((String)"eipTAclPortletFeature.featureName", (Object)featerName);
        query.setQualifier(exp11.andExp(exp12));
        query.setDistinct(true);
        List roles = dataContext.performQuery((Query)query);
        if (roles == null || roles.size() == 0) {
            return false;
        }
        EipTAclRole role = (EipTAclRole)roles.get(0);
        int dbAclType = role.getAclType();
        return (dbAclType & aclType) == aclType;
    }

    public List getAcceptUserIdsExceptLoginUser(DataContext dataContext, int uid, String feat, int acl_type) {
        int size;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        sb.append("USER_ID");
        sb.append(" FROM TURBINE_USER WHERE (");
        sb.append("USER_ID");
        sb.append(" IN (SELECT ");
        sb.append("USER_ID");
        sb.append(" FROM EIP_T_ACL_USER_ROLE_MAP WHERE ");
        sb.append("ROLE_ID");
        sb.append(" IN (SELECT ");
        sb.append("ROLE_ID");
        sb.append(" FROM EIP_T_ACL_ROLE WHERE ((");
        sb.append("ACL_TYPE");
        sb.append(" & ");
        sb.append(Integer.toString(acl_type));
        sb.append(") = ");
        sb.append(Integer.toString(acl_type));
        sb.append(") AND (");
        sb.append("FEATURE_ID");
        sb.append(" IN (SELECT ");
        sb.append("FEATURE_ID");
        sb.append(" FROM EIP_T_ACL_PORTLET_FEATURE WHERE ");
        sb.append("FEATURE_NAME");
        sb.append("='");
        sb.append(feat.trim());
        sb.append("'))))) AND (");
        sb.append("USER_ID");
        sb.append(" != ");
        sb.append(Integer.toString(uid));
        sb.append(")");
        String sqlString = sb.toString();
        SQLTemplate query = new SQLTemplate(TurbineUser.class, sqlString, true);
        query.setFetchingDataRows(true);
        List list = dataContext.performQuery((Query)query);
        ArrayList<Integer> userIds = new ArrayList<Integer>();
        if (list == null || (size = list.size()) < 1) {
            return userIds;
        }
        for (int i = 0; i < size; ++i) {
            DataRow row = (DataRow)list.get(i);
            userIds.add((Integer)ALEipUtils.getObjFromDataRow((DataRow)row, (String)"USER_ID"));
        }
        return userIds;
    }

    public List getAcceptUserIdsInListExceptLoginUser(DataContext dataContext, int uid, String feat, int acl_type, List ulist) {
        int size;
        int u_size;
        ArrayList<Integer> userIds = new ArrayList<Integer>();
        if (ulist == null || (u_size = ulist.size()) < 1) {
            return userIds;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        sb.append("USER_ID");
        sb.append(" FROM TURBINE_USER WHERE (");
        sb.append("USER_ID");
        sb.append(" IN (SELECT ");
        sb.append("USER_ID");
        sb.append(" FROM EIP_T_ACL_USER_ROLE_MAP WHERE ");
        sb.append("ROLE_ID");
        sb.append(" IN (SELECT ");
        sb.append("ROLE_ID");
        sb.append(" FROM EIP_T_ACL_ROLE WHERE ((");
        sb.append("ACL_TYPE");
        sb.append(" & ");
        sb.append(Integer.toString(acl_type));
        sb.append(") = ");
        sb.append(Integer.toString(acl_type));
        sb.append(") AND (");
        sb.append("FEATURE_ID");
        sb.append(" IN (SELECT ");
        sb.append("FEATURE_ID");
        sb.append(" FROM EIP_T_ACL_PORTLET_FEATURE WHERE ");
        sb.append("FEATURE_NAME");
        sb.append("='");
        sb.append(feat.trim());
        sb.append("'))))) AND (");
        sb.append("USER_ID");
        sb.append(" in (");
        for (int i = 0; i < u_size; ++i) {
            ALEipUser member = (ALEipUser)ulist.get(i);
            sb.append(Long.toString(member.getUserId().getValue()));
            if (i + 1 >= u_size) continue;
            sb.append(",");
        }
        sb.append(")) AND (");
        sb.append("USER_ID");
        sb.append(" != ");
        sb.append(Integer.toString(uid));
        sb.append(")");
        String sqlString = sb.toString();
        SQLTemplate query = new SQLTemplate(TurbineUser.class, sqlString, true);
        query.setFetchingDataRows(true);
        List list = dataContext.performQuery((Query)query);
        if (list == null || (size = list.size()) < 1) {
            return userIds;
        }
        for (int i = 0; i < size; ++i) {
            DataRow raw = (DataRow)list.get(i);
            userIds.add((Integer)ALEipUtils.getObjFromDataRow((DataRow)raw, (String)"USER_ID"));
        }
        return userIds;
    }

    public List getAuthorityUsersFromGroup(RunData rundata, String feat, String groupname, boolean includeLoginuser) {
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        int listNumber = 1;
        int detailNumber = 2;
        int updateNumber = 8;
        int aclNumber = listNumber | detailNumber | updateNumber;
        StringBuffer sb = new StringBuffer();
        sb.append("(SELECT ");
        sb.append("USER_ID");
        sb.append(" FROM EIP_T_ACL_USER_ROLE_MAP WHERE ");
        sb.append("ROLE_ID");
        sb.append(" IN (SELECT ");
        sb.append("ROLE_ID");
        sb.append(" FROM EIP_T_ACL_ROLE WHERE ((");
        sb.append("ACL_TYPE");
        sb.append(" & ");
        sb.append(Integer.toString(aclNumber));
        sb.append(") = ");
        sb.append(Integer.toString(aclNumber));
        sb.append(") AND (");
        sb.append("FEATURE_ID");
        sb.append(" IN (SELECT ");
        sb.append("FEATURE_ID");
        sb.append(" FROM EIP_T_ACL_PORTLET_FEATURE WHERE ");
        sb.append("FEATURE_NAME");
        sb.append("='");
        sb.append(feat.trim());
        sb.append("'))))");
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT DISTINCT ");
        statement.append("B.USER_ID, B.LOGIN_NAME, B.FIRST_NAME, B.LAST_NAME, D.POSITION ");
        statement.append("FROM TURBINE_USER_GROUP_ROLE as A ");
        statement.append("LEFT JOIN TURBINE_USER as B ");
        statement.append("on A.USER_ID = B.USER_ID ");
        statement.append("LEFT JOIN TURBINE_GROUP as C ");
        statement.append("on A.GROUP_ID = C.GROUP_ID ");
        statement.append("LEFT JOIN EIP_M_USER_POSITION as D ");
        statement.append("on A.USER_ID = D.USER_ID ");
        statement.append("WHERE B.USER_ID IN ");
        statement.append(sb);
        statement.append(" AND B.DISABLED = 'F'");
        statement.append(" AND C.GROUP_NAME = '").append(groupname).append("' ");
        statement.append("ORDER BY D.POSITION");
        String merged2 = statement.toString();
        SQLTemplate stemp = new SQLTemplate(TurbineUser.class, merged2);
        stemp.setFetchingDataRows(true);
        List ulist = dataContext.performQuery((Query)stemp);
        return ulist;
    }

    public void insertDefaultRole(int uid) throws Exception {
        int role = 29;
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        TurbineUser tuser = (TurbineUser)DataObjectUtils.objectForPK((ObjectContext)dataContext, TurbineUser.class, (Object)uid);
        SelectQuery query = new SelectQuery(EipTAclRole.class);
        ArrayList<Integer> integerList = new ArrayList<Integer>(role);
        for (int i = 0; i < role; ++i) {
            integerList.add(i + 1);
        }
        Expression exp = ExpressionFactory.inDbExp((String)"ROLE_ID", integerList);
        query.setQualifier(exp);
        List list = dataContext.performQuery((Query)query);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            EipTAclUserRoleMap map = (EipTAclUserRoleMap)dataContext.createAndRegisterNewObject(EipTAclUserRoleMap.class);
            map.setEipTAclRole((EipTAclRole)list.get(i));
            map.setTurbineUser(tuser);
        }
    }
}

