/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.facilities.util;

import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.facilities.FacilityResultData;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class FacilitiesUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FacilitiesUtils.class.getName());

    public static EipMFacility getEipMFacility(RunData rundata, Context context) {
        String facilityid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            Expression exp;
            SelectQuery query;
            if (facilityid == null || Integer.valueOf(facilityid) == null) {
                logger.debug((Object)"[Facility] Empty ID...");
                return null;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            List facilities = dataContext.performQuery((Query)(query = new SelectQuery(EipMFacility.class, exp = ExpressionFactory.matchDbExp((String)"FACILITY_ID", (Object)facilityid))));
            if (facilities == null || facilities.size() == 0) {
                logger.debug((Object)"[Facilities] Not found ID...");
                return null;
            }
            return (EipMFacility)facilities.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static List getFacilityAllList() {
        ArrayList<FacilityResultData> facilityAllList = new ArrayList<FacilityResultData>();
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipMFacility.class);
            List aList = dataContext.performQuery((Query)query);
            int size = aList.size();
            for (int i = 0; i < size; ++i) {
                EipMFacility record = (EipMFacility)aList.get(i);
                FacilityResultData rd = new FacilityResultData();
                rd.initField();
                rd.setFacilityId(record.getFacilityId().longValue());
                rd.setFacilityName(record.getFacilityName());
                facilityAllList.add(rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        return facilityAllList;
    }

    public static List getFacilityList(String groupname) {
        ArrayList<FacilityResultData> list = new ArrayList<FacilityResultData>();
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT DISTINCT ");
        statement.append("  B.FACILITY_ID, B.FACILITY_NAME ");
        statement.append("FROM EIP_FACILITY_GROUP as A ");
        statement.append("LEFT JOIN EIP_M_FACILITY as B ");
        statement.append("  on A.FACILITY_ID = B.FACILITY_ID ");
        statement.append("LEFT JOIN TURBINE_GROUP as C ");
        statement.append("  on A.GROUP_ID = C.GROUP_ID ");
        statement.append("WHERE C.GROUP_NAME = '").append(groupname).append("'");
        String query = statement.toString();
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SQLTemplate rawSelect = new SQLTemplate(EipMFacility.class, query, true);
            rawSelect.setFetchingDataRows(true);
            List flist = dataContext.performQuery((Query)rawSelect);
            int recNum = flist.size();
            for (int j = 0; j < recNum; ++j) {
                DataRow dataRow = (DataRow)flist.get(j);
                FacilityResultData frd = new FacilityResultData();
                frd.initField();
                frd.setFacilityId(((Integer)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"FACILITY_ID")).intValue());
                frd.setFacilityName((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"FACILITY_NAME"));
                list.add(frd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"[Exception]", (Throwable)ex);
        }
        return list;
    }

    public static List getFacilityIds(String groupname) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT DISTINCT ");
        statement.append("  B.FACILITY_ID ");
        statement.append("FROM EIP_FACILITY_GROUP as A ");
        statement.append("LEFT JOIN EIP_M_FACILITY as B ");
        statement.append("  on A.FACILITY_ID = B.FACILITY_ID ");
        statement.append("LEFT JOIN TURBINE_GROUP as C ");
        statement.append("  on A.GROUP_ID = C.GROUP_ID ");
        statement.append("WHERE C.GROUP_NAME = '").append(groupname).append("'");
        String query = statement.toString();
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SQLTemplate rawSelect = new SQLTemplate(EipMFacility.class, query, true);
            rawSelect.setFetchingDataRows(true);
            List flist = dataContext.performQuery((Query)rawSelect);
            int recNum = flist.size();
            for (int j = 0; j < recNum; ++j) {
                DataRow dataRow = (DataRow)flist.get(j);
                list.add((Integer)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"FACILITY_ID"));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"[Exception]", (Throwable)ex);
        }
        return list;
    }

    public static List getFacilitiesFromSelectQuery(SelectQuery query) {
        ArrayList<FacilityResultData> list = new ArrayList<FacilityResultData>();
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            List aList = dataContext.performQuery((Query)query);
            int size = aList.size();
            for (int i = 0; i < size; ++i) {
                EipMFacility record = (EipMFacility)aList.get(i);
                FacilityResultData rd = new FacilityResultData();
                rd.initField();
                rd.setFacilityId(record.getFacilityId().longValue());
                rd.setFacilityName(record.getFacilityName());
                list.add(rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"[Exception]", (Throwable)ex);
        }
        return list;
    }

    public static boolean isContains(List facilityrList, FacilityResultData rd) {
        int size = facilityrList.size();
        long fid = rd.getFacilityId().getValue();
        FacilityResultData facility = null;
        for (int i = 0; i < size; ++i) {
            facility = (FacilityResultData)facilityrList.get(i);
            if (facility.getFacilityId().getValue() != fid) continue;
            return true;
        }
        return false;
    }
}

