/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.facilities;

import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.facilities.FacilityResultData;
import com.aimluck.eip.facilities.util.FacilitiesUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.Date;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class FacilitySelectData
extends ALAbstractSelectData
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FacilitySelectData.class.getName());
    private int facilitySum;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p2a-sort"));
        }
        super.init(action, rundata, context);
    }

    public List selectList(RunData rundata, Context context) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            List list = dataContext.performQuery((Query)query);
            this.facilitySum = list.size();
            return this.buildPaginatedList(list);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(EipMFacility.class);
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    protected Object getResultData(Object obj) {
        try {
            EipMFacility record = (EipMFacility)obj;
            FacilityResultData rd = new FacilityResultData();
            rd.initField();
            rd.setFacilityId(record.getFacilityId().longValue());
            rd.setFacilityName(record.getFacilityName());
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public Object selectDetail(RunData rundata, Context context) {
        return FacilitiesUtils.getEipMFacility(rundata, context);
    }

    protected Object getResultDataDetail(Object obj) {
        try {
            EipMFacility record = (EipMFacility)obj;
            FacilityResultData rd = new FacilityResultData();
            rd.initField();
            rd.setFacilityName(record.getFacilityName());
            rd.setFacilityId(record.getFacilityId().longValue());
            rd.setNote(record.getNote());
            rd.setCreateDate(ALDateUtil.format((Date)record.getCreateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            rd.setUpdateDate(ALDateUtil.format((Date)record.getUpdateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public int getFacilitySum() {
        return this.facilitySum;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("facility_name", "facilityName");
        return map;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }
}

