/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.facilities;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipFacilityGroup;
import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.cayenne.om.security.TurbineGroup;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.facilities.util.FacilitiesUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class FacilityFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FacilityFormData.class.getName());
    private ALStringField facility_name;
    private ALStringField note;
    private String facilityid;
    private int userId;
    private DataContext dataContext;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        this.userId = ALEipUtils.getUserId((RunData)rundata);
    }

    public void initField() {
        this.facility_name = new ALStringField();
        this.facility_name.setFieldName("\u65bd\u8a2d\u540d");
        this.facility_name.setTrim(true);
        this.note = new ALStringField();
        this.note.setFieldName("\u30e1\u30e2");
        this.note.setTrim(false);
    }

    protected void setValidator() {
        this.facility_name.setNotNull(true);
        this.facility_name.limitMaxLength(50);
        this.note.limitMaxLength(1000);
    }

    protected boolean setFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        try {
            if (res && "update".equals(this.getMode())) {
                this.facilityid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            res = false;
        }
        return res;
    }

    protected boolean validate(ArrayList msgList) {
        try {
            SelectQuery query = new SelectQuery(EipMFacility.class);
            if ("insert".equals(this.getMode())) {
                Expression exp = ExpressionFactory.matchExp((String)"facilityName", (Object)this.facility_name.getValue());
                query.setQualifier(exp);
            } else if ("update".equals(this.getMode())) {
                Expression exp1 = ExpressionFactory.matchExp((String)"facilityName", (Object)this.facility_name.getValue());
                query.setQualifier(exp1);
                Expression exp2 = ExpressionFactory.noMatchDbExp((String)"FACILITY_ID", (Object)Integer.valueOf(this.facilityid));
                query.andQualifier(exp2);
            }
            if (this.dataContext.performQuery((Query)query).size() != 0) {
                msgList.add("\u65bd\u8a2d\u540d\u300e <span class='em'>" + this.facility_name.toString() + "</span> \u300f\u306f\u65e2\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        this.facility_name.validate(msgList);
        this.note.validate(msgList);
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipMFacility facility = FacilitiesUtils.getEipMFacility(rundata, context);
            if (facility == null) {
                return false;
            }
            this.facility_name.setValue(facility.getFacilityName());
            this.note.setValue(facility.getNote());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipMFacility facility = FacilitiesUtils.getEipMFacility(rundata, context);
            if (facility == null) {
                return false;
            }
            SelectQuery query1 = new SelectQuery(EipTScheduleMap.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)facility.getFacilityId());
            Expression exp2 = ExpressionFactory.matchExp((String)"type", (Object)"F");
            query1.setQualifier(exp1.andExp(exp2));
            List slist = this.dataContext.performQuery((Query)query1);
            if (slist != null && slist.size() > 0) {
                this.dataContext.deleteObjects((Collection)slist);
            }
            this.dataContext.deleteObject((Persistent)facility);
            this.dataContext.commitChanges();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipMFacility facility = (EipMFacility)this.dataContext.createAndRegisterNewObject(EipMFacility.class);
            facility.setUserId(Integer.valueOf(this.userId));
            facility.setFacilityName(this.facility_name.getValue());
            facility.setNote(this.note.getValue());
            facility.setCreateDate(Calendar.getInstance().getTime());
            facility.setUpdateDate(Calendar.getInstance().getTime());
            Group facility_group = JetspeedSecurity.getGroup((String)"Facility");
            EipFacilityGroup fg = (EipFacilityGroup)this.dataContext.createAndRegisterNewObject(EipFacilityGroup.class);
            fg.setEipMFacility(facility);
            fg.setTurbineGroup((TurbineGroup)facility_group);
            this.dataContext.commitChanges();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipMFacility facility = FacilitiesUtils.getEipMFacility(rundata, context);
            if (facility == null) {
                return false;
            }
            facility.setFacilityName(this.facility_name.getValue());
            facility.setNote(this.note.getValue());
            facility.setUpdateDate(Calendar.getInstance().getTime());
            this.dataContext.commitChanges();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public ALStringField getFacilityName() {
        return this.facility_name;
    }
}

