/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.mygroup;

import com.aimluck.eip.cayenne.om.security.TurbineGroup;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.facilities.util.FacilitiesUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.mygroup.MyGroupResultData;
import com.aimluck.eip.mygroup.util.MyGroupUtils;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MyGroupSelectData
extends ALAbstractSelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MyGroupSelectData.class.getName());

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p2a-sort"));
        }
        super.init(action, rundata, context);
    }

    protected List selectList(RunData rundata, Context context) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            List list = dataContext.performQuery((Query)query);
            return this.buildPaginatedList(list);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(TurbineGroup.class);
        Expression exp = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
        query.setQualifier(exp);
        return query;
    }

    protected Object selectDetail(RunData rundata, Context context) {
        return MyGroupUtils.getGroup(rundata, context);
    }

    protected Object getResultData(Object obj) {
        TurbineGroup record = (TurbineGroup)obj;
        MyGroupResultData rd = new MyGroupResultData();
        rd.initField();
        rd.setGroupName(record.getGroupName());
        rd.setGroupAliasName(record.getGroupAliasName());
        return rd;
    }

    protected Object getResultDataDetail(Object obj) {
        TurbineGroup record = (TurbineGroup)obj;
        MyGroupResultData rd = new MyGroupResultData();
        rd.initField();
        rd.setGroupName(record.getGroupName());
        rd.setGroupAliasName(record.getGroupAliasName());
        return rd;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("group_alias_name", "groupAliasName");
        return map;
    }

    public List getMemberList(String name) {
        return ALEipUtils.getUsers((String)name);
    }

    public List getFacilityList(String groupname) {
        return FacilitiesUtils.getFacilityList((String)groupname);
    }
}

