/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.todo.util;

import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.cayenne.om.portlet.EipTTodoCategory;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.cayenne.DataObjectUtils;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ToDoUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ToDoUtils.class.getName());
    public static final String TARGET_GROUP_NAME = "target_group_name";
    public static final String TARGET_USER_ID = "target_user_id";
    public static final int LIMIT_STATE_BEFORE = -1;
    public static final int LIMIT_STATE_TODAY = 0;
    public static final int LIMIT_STATE_AFTER = 1;

    public static EipTTodo getEipTTodo(RunData rundata, Context context, boolean isJoin) throws ALPageNotFoundException {
        String todoid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        int uid = ALEipUtils.getUserId((RunData)rundata);
        try {
            if (todoid == null || Integer.valueOf(todoid) == null) {
                logger.debug((Object)"[Todo] Empty ID...");
                return null;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            Expression exp = ExpressionFactory.matchDbExp((String)"TODO_ID", (Object)todoid);
            exp.andExp(ExpressionFactory.matchDbExp((String)"turbineUser.USER_ID", (Object)ALEipUtils.getUserId((RunData)rundata)));
            SelectQuery query = new SelectQuery(EipTTodo.class, exp);
            List todos = dataContext.performQuery((Query)query);
            if (todos == null || todos.size() == 0) {
                logger.debug((Object)"[Todo] Not found ID...");
                return null;
            }
            EipTTodo todo = (EipTTodo)todos.get(0);
            if (uid != todo.getUserId() && "F".equals(todo.getPublicFlag())) {
                logger.debug((Object)"[Todo] Invalid user access...");
                throw new ALPageNotFoundException();
            }
            return todo;
        }
        catch (ALPageNotFoundException pageNotFound) {
            logger.error((Object)pageNotFound);
            throw pageNotFound;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static EipTTodo getEipTPublicTodo(RunData rundata, Context context, boolean isJoin) {
        String todoid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (todoid == null || Integer.valueOf(todoid) == null) {
                logger.debug((Object)"[Todo] Empty ID...");
                return null;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            Expression exp = ExpressionFactory.matchDbExp((String)"TODO_ID", (Object)todoid);
            exp.andExp(ExpressionFactory.matchExp((String)"publicFlag", (Object)"T"));
            SelectQuery query = new SelectQuery(EipTTodo.class, exp);
            List todos = dataContext.performQuery((Query)query);
            if (todos == null || todos.size() == 0) {
                logger.debug((Object)"[Todo] Not found ID...");
                return null;
            }
            return (EipTTodo)todos.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static EipTTodoCategory getEipTTodoCategory(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String categoryid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        if (categoryid == null || Integer.valueOf(categoryid) == null) {
            logger.debug((Object)"[Todo] Empty ID...");
            throw new ALPageNotFoundException();
        }
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTTodoCategory.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"CATEGORY_ID", (Object)categoryid);
            Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.setQualifier(exp1);
            query.andQualifier(exp2);
            List categories = dataContext.performQuery((Query)query);
            if (categories == null || categories.size() == 0) {
                logger.debug((Object)"[Todo] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return (EipTTodoCategory)categories.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static EipTTodoCategory getEipTTodoCategory(DataContext dataContext, Long category_id) {
        try {
            EipTTodoCategory category = (EipTTodoCategory)DataObjectUtils.objectForPK((ObjectContext)dataContext, EipTTodoCategory.class, (Object)category_id);
            return category;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static Date getEmptyDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(9999, 11, 31);
        return cal.getTime();
    }

    public static boolean isEmptyDate(Date date) {
        if (date == null) {
            return false;
        }
        return date.getYear() == 8099;
    }

    public static String getPriorityImage(int i) {
        String[] temp = new String[]{"priority_high.gif", "priority_middle_high.gif", "priority_middle.gif", "priority_middle_low.gif", "priority_low.gif"};
        String image = null;
        try {
            image = temp[i - 1];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    public static String getPriorityString(int i) {
        String[] temp = new String[]{"\u9ad8\u3044", "\u3084\u3084\u9ad8\u3044", "\u666e\u901a", "\u3084\u3084\u4f4e\u3044", "\u4f4e\u3044"};
        String string = null;
        try {
            string = temp[i - 1];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static String getStateImage(int i) {
        String[] temp = new String[]{"state_000.gif", "state_010.gif", "state_020.gif", "state_030.gif", "state_040.gif", "state_050.gif", "state_060.gif", "state_070.gif", "state_080.gif", "state_090.gif", "state_100.gif"};
        String image = null;
        try {
            image = temp[i / 10];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    public static String getStateString(int i) {
        if (i == 0) {
            return "\u672a\u7740\u624b";
        }
        if (i == 100) {
            return "\u5b8c\u4e86";
        }
        return new StringBuffer().append(i).append("%").toString();
    }

    public static String getTargetGroupName(RunData rundata, Context context) {
        String target_group_name = null;
        String idParam = rundata.getParameters().getString(TARGET_GROUP_NAME);
        target_group_name = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)TARGET_GROUP_NAME);
        if (idParam == null && target_group_name == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_GROUP_NAME, (String)"all");
            target_group_name = "all";
        } else if (idParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_GROUP_NAME, (String)idParam);
            target_group_name = idParam;
        }
        return target_group_name;
    }

    public static String getTargetUserId(RunData rundata, Context context) {
        String target_user_id = null;
        String idParam = rundata.getParameters().getString(TARGET_USER_ID);
        target_user_id = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)TARGET_USER_ID);
        if (idParam == null && target_user_id == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_USER_ID, (String)"all");
            target_user_id = "all";
        } else if (idParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_USER_ID, (String)idParam);
            target_user_id = idParam;
        }
        return target_user_id;
    }

    public static int getLimitState(Date endDate) {
        if (endDate == null) {
            return -1;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date nowDate = calendar.getTime();
        calendar.setTime(endDate);
        Date endDate1 = calendar.getTime();
        if (calendar.get(1) == 9999 && calendar.get(2) == 11 && calendar.get(5) == 31) {
            return -1;
        }
        int result = nowDate.compareTo(endDate1);
        result = result < 0 ? -1 : (result == 0 ? 0 : 1);
        return result;
    }
}

