/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.todo;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.todo.util.ToDoUtils;
import java.util.ArrayList;
import org.apache.cayenne.access.DataContext;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ToDoStateUpdateData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ToDoStateUpdateData.class.getName());
    private ALNumberField state;

    public void initField() {
        this.state = new ALNumberField();
        this.state.setFieldName("\u9032\u6357");
    }

    protected void setValidator() {
        this.state.limitValue(0L, 100L);
        this.state.setNotNull(true);
    }

    protected boolean validate(ArrayList msgList) {
        int value = (int)this.state.getValue();
        return value % 10 == 0 && this.state.validate(msgList);
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            EipTTodo todo = ToDoUtils.getEipTTodo(rundata, context, false);
            if (todo == null) {
                return false;
            }
            todo.setState(Short.valueOf((short)this.state.getValue()));
            dataContext.commitChanges();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    public ALNumberField getState() {
        return this.state;
    }

    public String getAclPortletFeature() {
        return "todo_todo_self";
    }
}

