/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.todo;

import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.cayenne.om.portlet.EipTTodoCategory;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.todo.ToDoCategoryResultData;
import com.aimluck.eip.todo.ToDoResultData;
import com.aimluck.eip.todo.util.ToDoUtils;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ToDoSelectData
extends ALAbstractSelectData
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ToDoSelectData.class.getName());
    private String currentTab;
    private ArrayList categoryList;
    private int todoSum;
    private String scheduleUrl;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p2a-sort"));
            logger.debug((Object)("[ToDoSelectData] Init Parameter. : " + ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p2a-sort")));
        }
        String tabParam = rundata.getParameters().getString("tab");
        this.currentTab = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tab");
        if (tabParam == null && this.currentTab == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)"list");
            this.currentTab = "list";
        } else if (tabParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)tabParam);
            this.currentTab = tabParam;
        }
        super.init(action, rundata, context);
    }

    public void loadCategoryList(RunData rundata, Context context) {
        try {
            this.categoryList = new ArrayList();
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            Expression exp = ExpressionFactory.matchExp((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata));
            exp.orExp(ExpressionFactory.matchExp((String)"userId", (Object)0));
            SelectQuery query = new SelectQuery(EipTTodoCategory.class, exp);
            List aList = dataContext.performQuery((Query)query);
            int size = aList.size();
            for (int i = 0; i < size; ++i) {
                EipTTodoCategory record = (EipTTodoCategory)aList.get(i);
                ToDoCategoryResultData rd = new ToDoCategoryResultData();
                rd.initField();
                rd.setCategoryId(record.getCategoryId().longValue());
                rd.setCategoryName(record.getCategoryName());
                this.categoryList.add(rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
    }

    public List selectList(RunData rundata, Context context) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            List list = dataContext.performQuery((Query)query);
            this.todoSum = list.size();
            return this.buildPaginatedList(list);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(EipTTodo.class);
        Expression exp1 = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)ALEipUtils.getUserId((RunData)rundata));
        query.setQualifier(exp1);
        if ("list".equals(this.currentTab)) {
            Expression exp2 = ExpressionFactory.noMatchExp((String)"state", (Object)100);
            query.andQualifier(exp2);
        } else if ("complete".equals(this.currentTab)) {
            Expression exp2 = ExpressionFactory.matchExp((String)"state", (Object)100);
            query.andQualifier(exp2);
        }
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    protected Object getResultData(Object obj) {
        try {
            EipTTodo record = (EipTTodo)obj;
            ToDoResultData rd = new ToDoResultData();
            rd.initField();
            rd.setTodoId(record.getTodoId().intValue());
            rd.setCategoryId(record.getEipTTodoCategory().getCategoryId().longValue());
            rd.setCategoryName(ALCommonUtils.compressString((String)record.getEipTTodoCategory().getCategoryName(), (int)this.getStrLength()));
            rd.setTodoName(ALCommonUtils.compressString((String)record.getTodoName(), (int)this.getStrLength()));
            if (!ToDoUtils.isEmptyDate(record.getEndDate())) {
                rd.setEndDate(ALDateUtil.format((Date)record.getEndDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            }
            rd.setState(record.getState().intValue());
            rd.setStateImage(ToDoUtils.getStateImage(record.getState().intValue()));
            rd.setStateString(ToDoUtils.getStateString(record.getState().intValue()));
            rd.setPriority(record.getPriority().intValue());
            rd.setPriorityImage(ToDoUtils.getPriorityImage(record.getPriority().intValue()));
            rd.setPriorityString(ToDoUtils.getPriorityString(record.getPriority().intValue()));
            rd.setPublicFlag("T".equals(record.getPublicFlag()));
            rd.setLimitState(ToDoUtils.getLimitState(record.getEndDate()));
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public Object selectDetail(RunData rundata, Context context) throws ALPageNotFoundException {
        String js_peid = rundata.getParameters().getString("sch");
        if (js_peid != null && !js_peid.equals("")) {
            this.scheduleUrl = this.getPortletURItoSchedule(rundata, js_peid);
        }
        EipTTodo todo = ToDoUtils.getEipTTodo(rundata, context, true);
        return todo;
    }

    protected String getPortletURItoSchedule(RunData rundata, String schedulePortletId) {
        int prev = rundata.getParameters().getInt("prev");
        if (prev == 2) {
            return ALEipUtils.getPortletURI((RunData)rundata, (String)schedulePortletId);
        }
        return ALEipUtils.getPortletURItoTopPage((RunData)rundata, (String)schedulePortletId);
    }

    protected Object getResultDataDetail(Object obj) {
        try {
            EipTTodo record = (EipTTodo)obj;
            ToDoResultData rd = new ToDoResultData();
            rd.initField();
            rd.setTodoName(record.getTodoName());
            rd.setTodoId(record.getTodoId().longValue());
            rd.setCategoryId(record.getEipTTodoCategory().getCategoryId().longValue());
            rd.setCategoryName(record.getEipTTodoCategory().getCategoryName());
            if (!ToDoUtils.isEmptyDate(record.getStartDate())) {
                rd.setStartDate(ALDateUtil.format((Date)record.getStartDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            }
            if (!ToDoUtils.isEmptyDate(record.getEndDate())) {
                rd.setEndDate(ALDateUtil.format((Date)record.getEndDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            }
            rd.setStateString(ToDoUtils.getStateString(record.getState().intValue()));
            rd.setPriorityString(ToDoUtils.getPriorityString(record.getPriority().intValue()));
            rd.setNote(record.getNote());
            rd.setPublicFlag("T".equals(record.getPublicFlag()));
            rd.setAddonScheduleFlg("T".equals(record.getAddonScheduleFlg()));
            rd.setCreateDate(ALDateUtil.format((Date)record.getCreateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            rd.setUpdateDate(ALDateUtil.format((Date)record.getUpdateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public ArrayList getCategoryList() {
        return this.categoryList;
    }

    public String getCurrentTab() {
        return this.currentTab;
    }

    public int getTodoSum() {
        return this.todoSum;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("todo_name", "todoName");
        map.putValue("state", "state");
        map.putValue("priority", "priority");
        map.putValue("end_date", "endDate");
        map.putValue("category_name", "eipTTodoCategory.categoryName");
        map.putValue("category", "CATEGORY_ID");
        return map;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public String getScheduleUrl() {
        return this.scheduleUrl;
    }

    public String getAclPortletFeature() {
        return "todo_todo_self";
    }
}

