/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.todo;

import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.todo.ToDoPublicResultData;
import com.aimluck.eip.todo.ToDoSelectData;
import com.aimluck.eip.todo.util.ToDoUtils;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ToDoPublicSelectData
extends ALAbstractSelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ToDoSelectData.class.getName());
    private String currentTab;
    private String target_group_name;
    private String target_user_id;
    private List myGroupList = null;
    private int publicTodoSum;
    private String scheduleUrl;
    private String aclPortletFeature;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        int uid;
        Integer entityId;
        int aimUserId;
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p3b-sort"));
            logger.debug((Object)("[ToDoPublicSelectData] Init Parameter. : " + ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p3b-sort")));
        }
        super.init(action, rundata, context);
        String entityId_Str = rundata.getParameters().getString("entityid");
        this.aclPortletFeature = entityId_Str == null || "".equals(entityId_Str) ? "todo_todo_other" : ((aimUserId = this.getUserId(rundata, context, entityId = Integer.valueOf(Integer.parseInt(entityId_Str)))) != (uid = ALEipUtils.getUserId((RunData)rundata)) ? "todo_todo_other" : "todo_todo_self");
    }

    protected List selectList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String tabParam = rundata.getParameters().getString("publictab");
        this.currentTab = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"publictab");
        if (tabParam == null && this.currentTab == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"publictab", (String)"list");
            this.currentTab = "list";
        } else if (tabParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"publictab", (String)tabParam);
            this.currentTab = tabParam;
        }
        this.target_group_name = ToDoUtils.getTargetGroupName(rundata, context);
        this.target_user_id = ToDoUtils.getTargetUserId(rundata, context);
        List myGroups = ALEipUtils.getMyGroups((RunData)rundata);
        this.myGroupList = new ArrayList();
        int length = myGroups.size();
        for (int i = 0; i < length; ++i) {
            this.myGroupList.add(myGroups.get(i));
        }
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            List list = dataContext.performQuery((Query)query);
            this.publicTodoSum = list.size();
            return this.buildPaginatedList(list);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        Expression exp3;
        SelectQuery query = new SelectQuery(EipTTodo.class);
        Expression exp0 = ExpressionFactory.matchExp((String)"publicFlag", (Object)"T");
        query.setQualifier(exp0);
        if (this.target_user_id != null && !this.target_user_id.equals("") && !this.target_user_id.equals("all")) {
            Expression exp1 = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)Integer.valueOf(this.target_user_id));
            query.andQualifier(exp1);
        }
        if (this.target_group_name != null && !this.target_group_name.equals("") && !this.target_group_name.equals("all")) {
            Expression exp2 = ExpressionFactory.matchExp((String)"turbineUser.turbineUserGroupRole.turbineGroup.groupName", (Object)this.target_group_name);
            query.andQualifier(exp2);
        }
        if ("list".equals(this.currentTab)) {
            exp3 = ExpressionFactory.noMatchExp((String)"state", (Object)100);
            query.andQualifier(exp3);
        } else if ("complete".equals(this.currentTab)) {
            exp3 = ExpressionFactory.matchExp((String)"state", (Object)100);
            query.andQualifier(exp3);
        }
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    protected Object selectDetail(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String js_peid = rundata.getParameters().getString("sch");
        if (js_peid != null && !js_peid.equals("")) {
            int prev = rundata.getParameters().getInt("prev");
            this.scheduleUrl = prev == 2 ? ALEipUtils.getPortletURI((RunData)rundata, (String)js_peid) : ALEipUtils.getPortletURItoTopPage((RunData)rundata, (String)js_peid);
        }
        return ToDoUtils.getEipTPublicTodo(rundata, context, true);
    }

    protected Object getResultData(Object obj) throws ALPageNotFoundException, ALDBErrorException {
        try {
            EipTTodo record = (EipTTodo)obj;
            ALBaseUser createdUser = ALEipUtils.getBaseUser((int)record.getTurbineUser().getUserId());
            String createdUserName = new StringBuffer().append(createdUser.getLastName()).append(" ").append(createdUser.getFirstName()).toString();
            ToDoPublicResultData rd = new ToDoPublicResultData();
            rd.initField();
            rd.setTodoId(record.getTodoId().longValue());
            rd.setCategoryName(ALCommonUtils.compressString((String)record.getEipTTodoCategory().getCategoryName(), (int)this.getStrLength()));
            rd.setCreatedUser(createdUserName);
            rd.setTodoName(ALCommonUtils.compressString((String)record.getTodoName(), (int)this.getStrLength()));
            if (!ToDoUtils.isEmptyDate(record.getEndDate())) {
                rd.setEndDate(ALDateUtil.format((Date)record.getEndDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            }
            rd.setState(record.getState().intValue());
            rd.setStateImage(ToDoUtils.getStateImage(record.getState().intValue()));
            rd.setStateString(ToDoUtils.getStateString(record.getState().intValue()));
            rd.setPriority(record.getPriority().intValue());
            rd.setPriorityImage(ToDoUtils.getPriorityImage(record.getPriority().intValue()));
            rd.setPriorityString(ToDoUtils.getPriorityString(record.getPriority().intValue()));
            rd.setLimitState(ToDoUtils.getLimitState(record.getEndDate()));
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(Object obj) throws ALPageNotFoundException, ALDBErrorException {
        try {
            EipTTodo record = (EipTTodo)obj;
            ALBaseUser createdUser = ALEipUtils.getBaseUser((int)record.getTurbineUser().getUserId());
            String createdUserName = new StringBuffer().append(createdUser.getLastName()).append(" ").append(createdUser.getFirstName()).toString();
            ToDoPublicResultData rd = new ToDoPublicResultData();
            rd.initField();
            rd.setTodoName(record.getTodoName());
            rd.setTodoId(record.getTodoId().longValue());
            rd.setCategoryName(record.getEipTTodoCategory().getCategoryName());
            rd.setCreatedUser(createdUserName);
            if (!ToDoUtils.isEmptyDate(record.getStartDate())) {
                rd.setStartDate(ALDateUtil.format((Date)record.getStartDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            }
            if (!ToDoUtils.isEmptyDate(record.getEndDate())) {
                rd.setEndDate(ALDateUtil.format((Date)record.getEndDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            }
            rd.setStateString(ToDoUtils.getStateString(record.getState().intValue()));
            rd.setPriorityString(ToDoUtils.getPriorityString(record.getPriority().intValue()));
            rd.setNote(record.getNote());
            rd.setCreateDate(ALDateUtil.format((Date)record.getCreateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            rd.setUpdateDate(ALDateUtil.format((Date)record.getUpdateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private int getUserId(RunData rundata, Context context, Integer entityId) {
        Expression exp;
        SelectQuery query;
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        List record = dataContext.performQuery((Query)(query = new SelectQuery(EipTTodo.class, exp = ExpressionFactory.matchDbExp((String)"TODO_ID", (Object)entityId))));
        if (record.size() > 0) {
            return ((EipTTodo)record.get(0)).getUserId();
        }
        return -1;
    }

    public String getCurrentTab() {
        return this.currentTab;
    }

    public int getPublicTodoSum() {
        return this.publicTodoSum;
    }

    public String getTargetGroupName() {
        return this.target_group_name;
    }

    public String getTargetUserId() {
        return this.target_user_id;
    }

    public List getUsers() {
        if (this.target_group_name != null && !this.target_group_name.equals("") && !this.target_group_name.equals("all")) {
            return ALEipUtils.getUsers((String)this.target_group_name);
        }
        return ALEipUtils.getUsers((String)"LoginUser");
    }

    public Map getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public List getMyGroupList() {
        return this.myGroupList;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("todo_name", "todoName");
        map.putValue("state", "state");
        map.putValue("priority", "priority");
        map.putValue("end_date", "endDate");
        map.putValue("category", "eipTTodoCategory.categoryName");
        map.putValue("user_name", "turbineUser.lastNameKana");
        return map;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public String getScheduleUrl() {
        return this.scheduleUrl;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }
}

