/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.todo;

import com.aimluck.commons.field.ALDateField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.cayenne.om.portlet.EipTTodoCategory;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.todo.ToDoCategoryResultData;
import com.aimluck.eip.todo.util.ToDoUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.cayenne.DataObjectUtils;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ToDoFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ToDoFormData.class.getName());
    private ALStringField todo_name;
    private ALNumberField category_id;
    private ALNumberField priority;
    private ALNumberField state;
    private ALStringField note;
    private ALDateField start_date;
    private ALDateField end_date;
    private ALStringField start_date_check;
    private ALStringField end_date_check;
    private ArrayList categoryList;
    private int currentYear;
    private ALStringField category_name;
    private boolean is_new_category;
    private ALStringField public_flag;
    private ALStringField addon_schedule_flg;
    private DataContext dataContext;
    private EipTTodoCategory category;
    private int user_id;
    private String aclPortletFeature;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.is_new_category = rundata.getParameters().getBoolean("is_new_category");
        this.user_id = ALEipUtils.getUserId((RunData)rundata);
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        this.aclPortletFeature = "todo_todo_self";
    }

    public void initField() {
        this.todo_name = new ALStringField();
        this.todo_name.setFieldName("ToDo\u540d");
        this.todo_name.setTrim(true);
        this.category_id = new ALNumberField();
        this.category_id.setFieldName("\u30ab\u30c6\u30b4\u30ea");
        this.priority = new ALNumberField(3L);
        this.priority.setFieldName("\u512a\u5148\u5ea6");
        this.state = new ALNumberField();
        this.state.setFieldName("\u9032\u6357");
        this.note = new ALStringField();
        this.note.setFieldName("\u30e1\u30e2");
        this.note.setTrim(false);
        this.start_date = new ALDateField();
        this.start_date.setFieldName("\u958b\u59cb\u65e5");
        this.start_date.setValue(new Date());
        this.end_date = new ALDateField();
        this.end_date.setFieldName("\u7de0\u3081\u5207\u308a\u65e5");
        this.end_date.setValue(new Date());
        this.start_date_check = new ALStringField();
        this.start_date_check.setFieldName("\u6307\u5b9a\u3057\u306a\u3044");
        this.end_date_check = new ALStringField();
        this.end_date_check.setFieldName("\u6307\u5b9a\u3057\u306a\u3044");
        this.currentYear = Calendar.getInstance().get(1);
        this.category_name = new ALStringField();
        this.category_name.setFieldName("\u30ab\u30c6\u30b4\u30ea\u540d");
        this.public_flag = new ALStringField();
        this.public_flag.setFieldName("\u516c\u958b\u533a\u5206");
        this.public_flag.setValue("T");
        this.public_flag.setTrim(true);
        this.addon_schedule_flg = new ALStringField();
        this.addon_schedule_flg.setFieldName("\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb\u3078\u306e\u8868\u793a");
        this.addon_schedule_flg.setValue("T");
        this.addon_schedule_flg.setTrim(true);
    }

    public void loadCategoryList(RunData rundata, Context context) {
        this.categoryList = new ArrayList();
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTTodoCategory.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)0);
            query.orQualifier(exp2);
            List aList = dataContext.performQuery((Query)query);
            int size = aList.size();
            for (int i = 0; i < size; ++i) {
                EipTTodoCategory record = (EipTTodoCategory)aList.get(i);
                ToDoCategoryResultData rd = new ToDoCategoryResultData();
                rd.initField();
                rd.setCategoryId(record.getCategoryId().longValue());
                rd.setCategoryName(record.getCategoryName());
                this.categoryList.add(rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
    }

    protected void setValidator() {
        this.todo_name.setNotNull(true);
        this.todo_name.limitMaxLength(50);
        this.note.limitMaxLength(1000);
        if (this.is_new_category) {
            this.category_name.setNotNull(true);
            this.category_name.limitMaxLength(50);
        }
    }

    protected boolean validate(ArrayList msgList) {
        try {
            SelectQuery query = new SelectQuery(EipTTodoCategory.class);
            Expression exp = ExpressionFactory.matchExp((String)"categoryName", (Object)this.category_name.getValue());
            query.setQualifier(exp);
            Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)0);
            Expression exp3 = ExpressionFactory.matchExp((String)"userId", (Object)this.user_id);
            query.andQualifier(exp2.orExp(exp3));
            if (this.dataContext.performQuery((Query)query).size() != 0) {
                msgList.add("\u30ab\u30c6\u30b4\u30ea\u540d\u300e <span class='em'>" + this.category_name.toString() + "</span> \u300f\u306f\u65e2\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        boolean isStartDate = false;
        this.todo_name.validate(msgList);
        if (this.start_date_check.getValue() == null) {
            isStartDate = this.start_date.validate(msgList);
        }
        if (this.end_date_check.getValue() == null && this.end_date.validate(msgList) && isStartDate) {
            try {
                if (this.end_date.getValue().getDate().before(this.start_date.getValue().getDate())) {
                    msgList.add("\u300e <span class='em'>\u7de0\u3081\u5207\u308a\u65e5</span> \u300f\u306f\u300e <span class='em'>\u958b\u59cb\u65e5</span> \u300f\u4ee5\u964d\u306e\u65e5\u4ed8\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                }
            }
            catch (Exception e) {
                logger.error((Object)"Exception", (Throwable)e);
            }
        }
        this.note.validate(msgList);
        if (this.is_new_category) {
            this.category_name.validate(msgList);
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        String date1 = null;
        try {
            EipTTodo todo = ToDoUtils.getEipTTodo(rundata, context, false);
            if (todo == null) {
                return false;
            }
            this.todo_name.setValue(todo.getTodoName());
            this.category_id.setValue(todo.getEipTTodoCategory().getCategoryId().longValue());
            if (ToDoUtils.isEmptyDate(todo.getStartDate())) {
                this.start_date_check.setValue("TRUE");
                this.start_date.setValue(date1);
            } else {
                this.start_date.setValue(todo.getStartDate());
            }
            if (ToDoUtils.isEmptyDate(todo.getEndDate())) {
                this.end_date_check.setValue("TRUE");
                this.end_date.setValue(date1);
            } else {
                this.end_date.setValue(todo.getEndDate());
            }
            this.state.setValue(todo.getState().longValue());
            this.priority.setValue(todo.getPriority().longValue());
            this.note.setValue(todo.getNote());
            this.public_flag.setValue(todo.getPublicFlag());
            this.addon_schedule_flg.setValue(todo.getAddonScheduleFlg());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipTTodo todo = ToDoUtils.getEipTTodo(rundata, context, false);
            if (todo == null) {
                return false;
            }
            int entityId = todo.getTodoId();
            String todoName = todo.getTodoName();
            this.dataContext.deleteObject((Persistent)todo);
            this.dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(entityId, 130, todoName);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            if (this.is_new_category) {
                if (!this.insertCategoryData(rundata, context)) {
                    // empty if block
                }
            } else {
                this.category = ToDoUtils.getEipTTodoCategory(this.dataContext, this.category_id.getValue());
            }
            EipTTodo todo = (EipTTodo)this.dataContext.createAndRegisterNewObject(EipTTodo.class);
            todo.setTodoName(this.todo_name.getValue());
            todo.setEipTTodoCategory(this.category);
            TurbineUser tuser = (TurbineUser)DataObjectUtils.objectForPK((ObjectContext)this.dataContext, TurbineUser.class, (Object)this.user_id);
            todo.setTurbineUser(tuser);
            if (this.start_date_check.getValue() == null) {
                todo.setStartDate(this.start_date.getValue().getDate());
            } else {
                todo.setStartDate(ToDoUtils.getEmptyDate());
            }
            if (this.end_date_check.getValue() == null) {
                todo.setEndDate(this.end_date.getValue().getDate());
            } else {
                todo.setEndDate(ToDoUtils.getEmptyDate());
            }
            todo.setState(Short.valueOf((short)this.state.getValue()));
            todo.setPriority(Short.valueOf((short)this.priority.getValue()));
            todo.setNote(this.note.getValue());
            todo.setPublicFlag(this.public_flag.getValue());
            todo.setAddonScheduleFlg(this.addon_schedule_flg.getValue());
            todo.setCreateDate(Calendar.getInstance().getTime());
            todo.setUpdateDate(Calendar.getInstance().getTime());
            this.dataContext.commitChanges();
            if (this.category != null) {
                this.category_id.setValue(this.category.getCategoryId().longValue());
            }
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(todo.getTodoId().intValue(), 130, this.todo_name.getValue());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean insertCategoryData(RunData rundata, Context context) {
        try {
            this.setAclPortletFeature("todo_category_self");
            this.doCheckAclPermission(rundata, context, 4);
            this.setAclPortletFeature("todo_todo_self");
            this.category = (EipTTodoCategory)this.dataContext.createAndRegisterNewObject(EipTTodoCategory.class);
            this.category.setCategoryName(this.category_name.getValue());
            this.category.setUserId(Integer.valueOf(ALEipUtils.getUserId((RunData)rundata)));
            this.category.setCreateDate(Calendar.getInstance().getTime());
            this.category.setUpdateDate(Calendar.getInstance().getTime());
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError((RunData)rundata);
            return false;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipTTodo todo = ToDoUtils.getEipTTodo(rundata, context, false);
            if (todo == null) {
                return false;
            }
            if (this.is_new_category) {
                if (!this.insertCategoryData(rundata, context)) {
                    // empty if block
                }
            } else {
                this.category = ToDoUtils.getEipTTodoCategory(this.dataContext, this.category_id.getValue());
            }
            todo.setTodoName(this.todo_name.getValue());
            todo.setEipTTodoCategory(this.category);
            TurbineUser tuser = (TurbineUser)DataObjectUtils.objectForPK((ObjectContext)this.dataContext, TurbineUser.class, (Object)this.user_id);
            todo.setTurbineUser(tuser);
            if (this.start_date_check.getValue() == null) {
                todo.setStartDate(this.start_date.getValue().getDate());
            } else {
                todo.setStartDate(ToDoUtils.getEmptyDate());
            }
            if (this.end_date_check.getValue() == null) {
                todo.setEndDate(this.end_date.getValue().getDate());
            } else {
                todo.setEndDate(ToDoUtils.getEmptyDate());
            }
            todo.setState(Short.valueOf((short)this.state.getValue()));
            todo.setPriority(Short.valueOf((short)this.priority.getValue()));
            todo.setNote(this.note.getValue());
            todo.setPublicFlag(this.public_flag.getValue());
            todo.setAddonScheduleFlg(this.addon_schedule_flg.getValue());
            todo.setUpdateDate(Calendar.getInstance().getTime());
            this.dataContext.commitChanges();
            if (this.category != null) {
                this.category_id.setValue(this.category.getCategoryId().longValue());
            }
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(todo.getTodoId().intValue(), 130, this.todo_name.getValue());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public ALNumberField getCategoryId() {
        return this.category_id;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public ALNumberField getPriority() {
        return this.priority;
    }

    public ALNumberField getState() {
        return this.state;
    }

    public ALStringField getTodoName() {
        return this.todo_name;
    }

    public ALDateField getEndDate() {
        return this.end_date;
    }

    public ALDateField getStartDate() {
        return this.start_date;
    }

    public ArrayList getCategoryList() {
        return this.categoryList;
    }

    public ALStringField getEndDateCheck() {
        return this.end_date_check;
    }

    public ALStringField getStartDateCheck() {
        return this.start_date_check;
    }

    public int getCurrentYear() {
        return this.currentYear;
    }

    public boolean isNewCategory() {
        return this.is_new_category;
    }

    public ALStringField getCategoryName() {
        return this.category_name;
    }

    public ALStringField getPublicFlag() {
        return this.public_flag;
    }

    public ALStringField getAddonScheduleFlg() {
        return this.addon_schedule_flg;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }

    public void setAclPortletFeature(String aclPortletFeature) {
        this.aclPortletFeature = aclPortletFeature;
    }
}

