/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.todo;

import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTTodoCategory;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.todo.ToDoCategoryResultData;
import com.aimluck.eip.todo.util.ToDoUtils;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.Date;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ToDoCategorySelectData
extends ALAbstractSelectData
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ToDoCategorySelectData.class.getName());
    private int categorySum;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"category_name");
            logger.debug((Object)"[ToDoCategorySelectData] Init Parameter. : category_name");
        }
        super.init(action, rundata, context);
    }

    protected List selectList(RunData rundata, Context context) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            List list = dataContext.performQuery((Query)query);
            this.categorySum = list.size();
            return this.buildPaginatedList(list);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(EipTTodoCategory.class);
        Expression exp = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)ALEipUtils.getUserId((RunData)rundata));
        query.setQualifier(exp);
        return query;
    }

    protected Object selectDetail(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        return ToDoUtils.getEipTTodoCategory(rundata, context);
    }

    protected Object getResultData(Object obj) {
        EipTTodoCategory record = (EipTTodoCategory)obj;
        ToDoCategoryResultData rd = new ToDoCategoryResultData();
        rd.initField();
        rd.setCategoryId(record.getCategoryId().longValue());
        rd.setCategoryName(ALCommonUtils.compressString((String)record.getCategoryName(), (int)this.getStrLength()));
        rd.setNote(record.getNote());
        return rd;
    }

    protected Object getResultDataDetail(Object obj) {
        EipTTodoCategory record = (EipTTodoCategory)obj;
        ToDoCategoryResultData rd = new ToDoCategoryResultData();
        rd.initField();
        rd.setCategoryId(record.getCategoryId().longValue());
        rd.setCategoryName(record.getCategoryName());
        rd.setNote(record.getNote());
        rd.setCreateDate(ALDateUtil.format((Date)record.getCreateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
        rd.setUpdateDate(ALDateUtil.format((Date)record.getUpdateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
        return rd;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("category_name", "categoryName");
        return map;
    }

    public int getCategorySum() {
        return this.categorySum;
    }

    public String getAclPortletFeature() {
        return "todo_category_self";
    }
}

