/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.todo;

import com.aimluck.eip.cayenne.om.portlet.EipTTodoCategory;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.todo.ToDoSelectData;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ToDoCategoryMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ToDoCategoryMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, ArrayList values, ArrayList msgList) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTTodoCategory.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.inDbExp((String)"CATEGORY_ID", (Collection)values);
            query.andQualifier(exp2);
            List categorylist = dataContext.performQuery((Query)query);
            if (categorylist == null || categorylist.size() == 0) {
                return false;
            }
            int categorylistsize = categorylist.size();
            for (int i = 0; i < categorylistsize; ++i) {
                EipTTodoCategory category = (EipTTodoCategory)categorylist.get(i);
                Integer entityId = category.getCategoryId();
                String categoryName = category.getCategoryName();
                dataContext.deleteObject((Persistent)category);
                dataContext.commitChanges();
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(entityId.intValue(), 131, categoryName);
            }
            String filtername = ToDoSelectData.class.getName() + "filter";
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)filtername);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected int getDefineAclType() {
        return 16;
    }

    public String getAclPortletFeature() {
        return "todo_category_self";
    }
}

