/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.todo;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTTodoCategory;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.todo.ToDoSelectData;
import com.aimluck.eip.todo.util.ToDoUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Calendar;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ToDoCategoryFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ToDoCategoryFormData.class.getName());
    private ALStringField category_name;
    private ALStringField note;
    private Integer category_id;
    private DataContext dataContext;
    private int user_id;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        String categoryid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        if (categoryid != null && Integer.valueOf(categoryid) != null) {
            this.category_id = Integer.valueOf(categoryid);
        }
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        this.user_id = ALEipUtils.getUserId((RunData)rundata);
    }

    public void initField() {
        this.category_name = new ALStringField();
        this.category_name.setFieldName("\u30ab\u30c6\u30b4\u30ea\u540d");
        this.category_name.setTrim(true);
        this.note = new ALStringField();
        this.note.setFieldName("\u30e1\u30e2");
        this.note.setTrim(true);
    }

    protected void setValidator() {
        this.category_name.setNotNull(true);
        this.category_name.limitMaxLength(50);
        this.note.limitMaxLength(1000);
    }

    protected boolean validate(ArrayList msgList) {
        try {
            SelectQuery query = new SelectQuery(EipTTodoCategory.class);
            Expression exp = ExpressionFactory.matchExp((String)"categoryName", (Object)this.category_name.getValue());
            Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)0);
            Expression exp3 = ExpressionFactory.matchExp((String)"userId", (Object)this.user_id);
            if ("update".equals(this.getMode())) {
                Expression exp4 = ExpressionFactory.noMatchDbExp((String)"CATEGORY_ID", (Object)this.category_id);
                query.setQualifier(exp4.andExp(exp.andExp(exp3.orExp(exp2))));
            } else {
                query.setQualifier(exp.andExp(exp2.orExp(exp3)));
            }
            if (this.dataContext.performQuery((Query)query).size() != 0) {
                msgList.add("\u30ab\u30c6\u30b4\u30ea\u540d\u300e <span class='em'>" + this.category_name.toString() + "</span> \u300f\u306f\u65e2\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        this.category_name.validate(msgList);
        this.note.validate(msgList);
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipTTodoCategory category = ToDoUtils.getEipTTodoCategory(rundata, context);
            if (category == null) {
                return false;
            }
            this.category_name.setValue(category.getCategoryName());
            this.note.setValue(category.getNote());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipTTodoCategory category = (EipTTodoCategory)this.dataContext.createAndRegisterNewObject(EipTTodoCategory.class);
            category.setCategoryName(this.category_name.getValue());
            category.setNote(this.note.getValue());
            category.setUserId(Integer.valueOf(ALEipUtils.getUserId((RunData)rundata)));
            category.setCreateDate(Calendar.getInstance().getTime());
            category.setUpdateDate(Calendar.getInstance().getTime());
            this.dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(category.getCategoryId().intValue(), 131, this.category_name.getValue());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipTTodoCategory category = ToDoUtils.getEipTTodoCategory(rundata, context);
            if (category == null) {
                return false;
            }
            category.setCategoryName(this.category_name.getValue());
            category.setNote(this.note.getValue());
            category.setUserId(Integer.valueOf(ALEipUtils.getUserId((RunData)rundata)));
            category.setUpdateDate(Calendar.getInstance().getTime());
            this.dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(category.getCategoryId().intValue(), 131, this.category_name.getValue());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipTTodoCategory category = ToDoUtils.getEipTTodoCategory(rundata, context);
            if (category == null) {
                return false;
            }
            Integer entityId = category.getCategoryId();
            String categoryName = category.getCategoryName();
            this.dataContext.deleteObject((Persistent)category);
            this.dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(entityId.intValue(), 131, categoryName);
            String filtername = ToDoSelectData.class.getName() + "filter";
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)filtername);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public ALStringField getCategoryName() {
        return this.category_name;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public String getAclPortletFeature() {
        return "todo_category_self";
    }
}

