/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.accessctl.util;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.eip.accessctl.bean.AccessControlFeatureBean;
import com.aimluck.eip.cayenne.om.account.EipTAclPortletFeature;
import com.aimluck.eip.cayenne.om.account.EipTAclRole;
import com.aimluck.eip.cayenne.om.account.EipTAclUserRoleMap;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AccessControlUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AccessControlUtils.class.getName());

    public static EipTAclRole getEipTAclRole(RunData rundata, Context context) {
        String aclroleid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            Expression exp;
            SelectQuery query;
            if (aclroleid == null || Integer.valueOf(aclroleid) == null) {
                logger.debug((Object)"[AccessControlUtils] Empty ID...");
                return null;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            List aclroles = dataContext.performQuery((Query)(query = new SelectQuery(EipTAclRole.class, exp = ExpressionFactory.matchDbExp((String)"ROLE_ID", (Object)aclroleid))));
            if (aclroles == null || aclroles.size() == 0) {
                logger.debug((Object)"[AccessControlUtils] Not found ID...");
                return null;
            }
            return (EipTAclRole)aclroles.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static List getEipTAclUserRoleMaps(int aclroleid) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTAclUserRoleMap.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"eipTAclRole.ROLE_ID", (Object)aclroleid);
            query.setQualifier(exp);
            List aclroles = dataContext.performQuery((Query)query);
            if (aclroles == null || aclroles.size() == 0) {
                logger.debug((Object)"[AccessControlUtils] Not found ID...");
                return null;
            }
            return aclroles;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static List getPortletFeatureList() {
        SelectQuery query;
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        List features = dataContext.performQuery((Query)(query = new SelectQuery(EipTAclPortletFeature.class)));
        if (features == null || features.size() == 0) {
            logger.debug((Object)"[AccessControlUtils] Not found ID...");
            return null;
        }
        ArrayList<AccessControlFeatureBean> list = new ArrayList<AccessControlFeatureBean>();
        EipTAclPortletFeature feature = null;
        AccessControlFeatureBean finfo = null;
        int size = features.size();
        for (int i = 0; i < size; ++i) {
            feature = (EipTAclPortletFeature)features.get(i);
            finfo = new AccessControlFeatureBean();
            finfo.initField();
            finfo.setFeatureId(feature.getFeatureId().longValue());
            finfo.setFeatureName(feature.getFeatureName());
            finfo.setFeatureAliasName(feature.getFeatureAliasName());
            list.add(finfo);
        }
        return list;
    }

    public static void setupAcl(int defineAclType, int aclType, ALNumberField acl) {
        if ((aclType & defineAclType) == defineAclType) {
            acl.setValue(1L);
        }
    }
}

