/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.eventlog.util;

import com.aimluck.eip.cayenne.om.portlet.EipMAddressGroup;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbook;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbookCompany;
import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogEntry;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogThema;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFile;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFolder;
import com.aimluck.eip.cayenne.om.portlet.EipTCommonCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTEventlog;
import com.aimluck.eip.cayenne.om.portlet.EipTMemo;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardTopic;
import com.aimluck.eip.cayenne.om.portlet.EipTNote;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTTimecard;
import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.cayenne.om.portlet.EipTTodoCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequest;
import com.aimluck.eip.cayenne.om.security.TurbineGroup;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.List;
import org.apache.cayenne.DataObjectUtils;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class EventlogUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)EventlogUtils.class.getName());

    public static EipTEventlog getEipTEventlog(RunData rundata, Context context) {
        String logid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            Expression exp;
            SelectQuery query;
            if (logid == null || Integer.valueOf(logid) == null) {
                logger.debug((Object)"[EventlogUtils] Empty ID...");
                return null;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            List logs = dataContext.performQuery((Query)(query = new SelectQuery(EipTEventlog.class, exp = ExpressionFactory.matchDbExp((String)"EVENTLOG_ID", (Object)logid))));
            if (logs == null || logs.size() == 0) {
                logger.debug((Object)"[EventlogUtils] Not found ID...");
                return null;
            }
            return (EipTEventlog)logs.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static String getPortletDataName(int portletType, int entityId) {
        if (portletType == 0) {
            return null;
        }
        if (portletType == 1) {
            return null;
        }
        if (portletType == 2) {
            return null;
        }
        if (portletType == 3) {
            return "nothing";
        }
        if (portletType == 100) {
            return "nothing";
        }
        if (portletType == 110) {
            return EventlogUtils.getBlogEntryName(entityId);
        }
        if (portletType == 111) {
            return EventlogUtils.getBlogEntryThema(entityId);
        }
        if (portletType == 120) {
            return EventlogUtils.getWorkFlowRequestName(entityId);
        }
        if (portletType == 121) {
            return EventlogUtils.getWorkFlowCategoryName(entityId);
        }
        if (portletType == 130) {
            return EventlogUtils.getTodoName(entityId);
        }
        if (portletType == 131) {
            return EventlogUtils.getTodoCategoryName(entityId);
        }
        if (portletType == 150) {
            return EventlogUtils.getTimecardName(entityId);
        }
        if (portletType == 160) {
            return EventlogUtils.getAddressBookName(entityId);
        }
        if (portletType == 161) {
            return EventlogUtils.getAddressBookCompanyName(entityId);
        }
        if (portletType == 162) {
            return EventlogUtils.getAddressBookGroupName(entityId);
        }
        if (portletType == 170) {
            return EventlogUtils.getMemoName(entityId);
        }
        if (portletType == 180) {
            return EventlogUtils.getMsgboardTopicName(entityId);
        }
        if (portletType == 181) {
            return EventlogUtils.getMsgboardCategoryName(entityId);
        }
        if (portletType == 190) {
            return "nothing";
        }
        if (portletType == 200) {
            return "nothing";
        }
        if (portletType == 210) {
            return "nothing";
        }
        if (portletType == 220) {
            return EventlogUtils.getCabinetFileName(entityId);
        }
        if (portletType == 221) {
            return EventlogUtils.getCabinetFolderName(entityId);
        }
        if (portletType == 230) {
            return "nothing";
        }
        if (portletType == 231) {
            return EventlogUtils.getWebMailAccountName(entityId);
        }
        if (portletType == 240) {
            return EventlogUtils.getScheduleName(entityId);
        }
        if (portletType == 250) {
            return "nothing";
        }
        if (portletType == 260) {
            return null;
        }
        if (portletType == 270) {
            return EventlogUtils.getMyGroupName(entityId);
        }
        if (portletType == 280) {
            return "nothing";
        }
        if (portletType == 290) {
            return "nothing";
        }
        if (portletType == 140) {
            return EventlogUtils.getNoteName(entityId);
        }
        if (portletType == 300) {
            return EventlogUtils.getCommonCategoryName(entityId);
        }
        return "nothing";
    }

    private static String getAddressBookGroupName(int entityId) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            EipMAddressGroup group = (EipMAddressGroup)DataObjectUtils.objectForPK((ObjectContext)dataContext, EipMAddressGroup.class, (Object)entityId);
            if (group == null) {
                return null;
            }
            String dataName = group.getGroupName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private static String getAddressBookCompanyName(int entityId) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            EipMAddressbookCompany company = (EipMAddressbookCompany)DataObjectUtils.objectForPK((ObjectContext)dataContext, EipMAddressbookCompany.class, (Object)entityId);
            if (company == null) {
                return null;
            }
            String dataName = company.getCompanyName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private static String getAddressBookName(int entityId) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            EipMAddressbook address = (EipMAddressbook)DataObjectUtils.objectForPK((ObjectContext)dataContext, EipMAddressbook.class, (Object)entityId);
            if (address == null) {
                return null;
            }
            String dataName = new StringBuffer().append(address.getLastName()).append(" ").append(address.getLastName()).toString();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private static String getBlogEntryThema(int entityId) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            EipTBlogThema thema = (EipTBlogThema)DataObjectUtils.objectForPK((ObjectContext)dataContext, EipTBlogThema.class, (Object)entityId);
            if (thema == null) {
                return null;
            }
            String dataName = thema.getThemaName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private static String getTodoName(int entityId) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            EipTTodo todo = (EipTTodo)DataObjectUtils.objectForPK((ObjectContext)dataContext, EipTTodo.class, (Object)entityId);
            if (todo == null) {
                return null;
            }
            String dataName = todo.getTodoName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private static String getTodoCategoryName(int category_id) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            EipTTodoCategory category = (EipTTodoCategory)DataObjectUtils.objectForPK((ObjectContext)dataContext, EipTTodoCategory.class, (Object)category_id);
            if (category == null) {
                return null;
            }
            String dataName = category.getCategoryName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private static String getBlogEntryName(int entityId) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            EipTBlogEntry blog = (EipTBlogEntry)DataObjectUtils.objectForPK((ObjectContext)dataContext, EipTBlogEntry.class, (Object)entityId);
            if (blog == null) {
                return null;
            }
            String dataName = blog.getTitle();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private static String getWorkFlowRequestName(int entityId) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            EipTWorkflowRequest request = (EipTWorkflowRequest)DataObjectUtils.objectForPK((ObjectContext)dataContext, EipTWorkflowRequest.class, (Object)entityId);
            if (request == null) {
                return null;
            }
            String dataName = request.getEipTWorkflowCategory().getCategoryName() + " " + request.getRequestName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private static String getWorkFlowCategoryName(int category_id) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            EipTWorkflowCategory category = (EipTWorkflowCategory)DataObjectUtils.objectForPK((ObjectContext)dataContext, EipTWorkflowCategory.class, (Object)category_id);
            if (category == null) {
                return null;
            }
            String dataName = category.getCategoryName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private static String getWebMailAccountName(int entityId) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            EipMMailAccount account = (EipMMailAccount)DataObjectUtils.objectForPK((ObjectContext)dataContext, EipMMailAccount.class, (Object)entityId);
            if (account == null) {
                return null;
            }
            String dataName = account.getAccountName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private static String getTimecardName(int entityId) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            EipTTimecard timecard = (EipTTimecard)DataObjectUtils.objectForPK((ObjectContext)dataContext, EipTTimecard.class, (Object)entityId);
            if (timecard == null) {
                return null;
            }
            String dataName = timecard.getReason();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private static String getScheduleName(int entityId) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            EipTSchedule schedule = (EipTSchedule)DataObjectUtils.objectForPK((ObjectContext)dataContext, EipTSchedule.class, (Object)entityId);
            if (schedule == null) {
                return null;
            }
            String dataName = schedule.getName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private static String getNoteName(int entityId) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            EipTNote note = (EipTNote)DataObjectUtils.objectForPK((ObjectContext)dataContext, EipTNote.class, (Object)entityId);
            if (note == null) {
                return null;
            }
            String subject = "";
            if (note.getSubjectType().equals("0")) {
                subject = note.getCustomSubject();
            } else if (note.getSubjectType().equals("1")) {
                subject = "\u518d\u5ea6\u96fb\u8a71\u3057\u307e\u3059";
            } else if (note.getSubjectType().equals("2")) {
                subject = "\u96fb\u8a71\u3092\u3057\u3066\u304f\u3060\u3055\u3044";
            } else if (note.getSubjectType().equals("3")) {
                subject = "\u96fb\u8a71\u304c\u3042\u308a\u307e\u3057\u305f";
            } else if (note.getSubjectType().equals("4")) {
                subject = "\u4f1d\u8a00\u304c\u3042\u308a\u307e\u3059";
            }
            String dataName = subject + " (" + note.getClientName() + ")";
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private static String getMyGroupName(int entityId) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            TurbineGroup group = (TurbineGroup)DataObjectUtils.objectForPK((ObjectContext)dataContext, TurbineGroup.class, (Object)entityId);
            if (group == null) {
                return null;
            }
            String dataName = group.getGroupName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private static String getMsgboardTopicName(int entityId) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            EipTMsgboardTopic topic = (EipTMsgboardTopic)DataObjectUtils.objectForPK((ObjectContext)dataContext, EipTMsgboardTopic.class, (Object)entityId);
            if (topic == null) {
                return null;
            }
            String dataName = topic.getTopicName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private static String getMsgboardCategoryName(int category_id) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            EipTMsgboardCategory category = (EipTMsgboardCategory)DataObjectUtils.objectForPK((ObjectContext)dataContext, EipTMsgboardCategory.class, (Object)category_id);
            if (category == null) {
                return null;
            }
            String dataName = category.getCategoryName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private static String getCabinetFileName(int entityId) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            EipTCabinetFile file = (EipTCabinetFile)DataObjectUtils.objectForPK((ObjectContext)dataContext, EipTCabinetFile.class, (Object)entityId);
            if (file == null) {
                return null;
            }
            String dataName = file.getFileTitle();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private static String getCabinetFolderName(int entityId) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            EipTCabinetFolder file = (EipTCabinetFolder)DataObjectUtils.objectForPK((ObjectContext)dataContext, EipTCabinetFolder.class, (Object)entityId);
            if (file == null) {
                return null;
            }
            String dataName = file.getFolderName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private static String getCommonCategoryName(int entityId) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            EipTCommonCategory category = (EipTCommonCategory)DataObjectUtils.objectForPK((ObjectContext)dataContext, EipTCommonCategory.class, (Object)entityId);
            if (category == null) {
                return null;
            }
            String dataName = category.getName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private static String getMemoName(int memo_id) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            EipTMemo memo = (EipTMemo)DataObjectUtils.objectForPK((ObjectContext)dataContext, EipTMemo.class, (Object)memo_id);
            if (memo == null) {
                return null;
            }
            String dataName = memo.getMemoName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }
}

