/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.eventlog;

import com.aimluck.eip.cayenne.om.portlet.EipTEventlog;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.eventlog.EventlogResultData;
import com.aimluck.eip.eventlog.util.ALEventlogUtils;
import com.aimluck.eip.eventlog.util.EventlogUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class EventlogSelectData
extends ALAbstractSelectData
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)EventlogSelectData.class.getName());
    private int eventlogSum;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort_type;
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p2a-sort"));
        }
        if ((sort_type = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR)) == null || "".equals(sort_type)) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR, (String)"desc");
        }
        super.init(action, rundata, context);
    }

    public List selectList(RunData rundata, Context context) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            List list = dataContext.performQuery((Query)query);
            this.eventlogSum = list.size();
            return this.buildPaginatedList(list);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(EipTEventlog.class);
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    protected Object getResultData(Object obj) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5\uff08EE\uff09HH\u6642mm\u5206ss\u79d2");
            EipTEventlog record = (EipTEventlog)obj;
            EventlogResultData rd = new EventlogResultData();
            rd.initField();
            rd.setEventlogId(record.getEventlogId().longValue());
            rd.setUserFullName(ALEipUtils.getUserFullName((int)record.getTurbineUser().getUserId()));
            rd.setEventDate(df.format(record.getUpdateDate()));
            rd.setPortletName(ALEventlogUtils.getPortletAliasName((int)record.getPortletType()));
            rd.setEntityId(record.getEntityId().longValue());
            rd.setIpAddr(record.getIpAddr());
            rd.setEventName(ALEventlogUtils.getEventAliasName((int)record.getEventType()));
            rd.setNote(record.getNote());
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public Object selectDetail(RunData rundata, Context context) {
        return EventlogUtils.getEipTEventlog(rundata, context);
    }

    protected Object getResultDataDetail(Object obj) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5\uff08EE\uff09HH\u6642mm\u5206ss\u79d2");
            EipTEventlog record = (EipTEventlog)obj;
            EventlogResultData rd = new EventlogResultData();
            rd.initField();
            rd.setEventlogId(record.getEventlogId().longValue());
            rd.setUserFullName(ALEipUtils.getUserFullName((int)record.getTurbineUser().getUserId()));
            rd.setEventDate(df.format(record.getUpdateDate()));
            rd.setPortletName(ALEventlogUtils.getPortletAliasName((int)record.getPortletType()));
            rd.setEntityId(record.getEntityId().longValue());
            rd.setIpAddr(record.getIpAddr());
            rd.setEventName(ALEventlogUtils.getEventAliasName((int)record.getEventType()));
            rd.setNote(record.getNote());
            String dataName = EventlogUtils.getPortletDataName(record.getPortletType(), record.getEntityId());
            if (dataName != null && !"".equals(dataName)) {
                rd.setDataName(dataName);
                rd.setDataNameFlag(true);
            } else {
                String tmp_dataName = record.getNote();
                if (tmp_dataName != null && !"".equals(tmp_dataName)) {
                    rd.setDataName(tmp_dataName);
                    rd.setDataNameFlag(true);
                }
            }
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public int getEventlogSum() {
        return this.eventlogSum;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("event_date", "eventDate");
        map.putValue("user_name", "turbineUser.lastNameKana");
        map.putValue("portlet_id", "portletType");
        map.putValue("event_type", "eventType");
        map.putValue("ip_addr", "ipAddr");
        return map;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }
}

