/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util.template;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.StringElement;
import org.apache.jetspeed.modules.ParameterLoader;
import org.apache.jetspeed.om.SecurityReference;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.PSMLDocument;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileException;
import org.apache.jetspeed.om.registry.Parameter;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletControl;
import org.apache.jetspeed.portal.PortletSet;
import org.apache.jetspeed.portal.security.portlets.PortletWrapper;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.PortalToolkit;
import org.apache.jetspeed.services.PortletFactory;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.PortalResource;
import org.apache.jetspeed.util.JetspeedClearElement;
import org.apache.turbine.services.localization.Localization;
import org.apache.turbine.services.pull.ApplicationTool;
import org.apache.turbine.util.RunData;

public class JetspeedTool
implements ApplicationTool {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedTool.class.getName());
    protected JetspeedRunData rundata = null;

    public JetspeedTool() {
    }

    public JetspeedTool(RunData data) {
        this.rundata = (JetspeedRunData)data;
    }

    public void init(Object data) {
        this.rundata = (JetspeedRunData)data;
    }

    public void refresh() {
    }

    public ConcreteElement getPane(String name) {
        StringElement result = null;
        String msg = "";
        if (null != this.rundata) {
            Profile profile = this.rundata.getProfile();
            try {
                PSMLDocument doc;
                if (null == profile) {
                    profile = Profiler.getProfile((RunData)this.rundata);
                    if (profile == null) {
                        throw new ProfileException("Profile not found.");
                    }
                    this.rundata.setProfile(profile);
                }
                if (name != null && !"default".equals(name) && !"".equals(name)) {
                    profile.setName(name);
                }
                if (null != (doc = profile.getDocument())) {
                    result = PortalToolkit.getSet(doc.getPortlets()).getContent((RunData)this.rundata);
                }
            }
            catch (Exception e) {
                logger.warn("JetspeedTool.getPane: problem getting: " + name + " from current request's profile: " + e.toString());
                msg = e.getMessage();
            }
        }
        if (result == null) {
            result = new StringElement("Error retrieving Portal Page: " + msg);
        }
        return result;
    }

    public ConcreteElement getPortlet(String name) {
        ConcreteElement result = null;
        Portlet found = null;
        Stack<Portlet> sets = new Stack<Portlet>();
        sets.push(this.rundata.getProfile().getRootSet());
        while (sets.size() > 0 && found == null) {
            PortletSet set = (PortletSet)sets.pop();
            if (set.getName().equals(name)) {
                found = set;
                continue;
            }
            Enumeration en = set.getPortlets();
            while (found == null && en.hasMoreElements()) {
                Portlet p;
                Portlet real = p = (Portlet)en.nextElement();
                while (real instanceof PortletControl) {
                    real = ((PortletControl)p).getPortlet();
                }
                if (real instanceof PortletSet) {
                    sets.push(real);
                    continue;
                }
                if (!p.getName().equals(name)) continue;
                found = p;
            }
        }
        if (found != null) {
            result = found.getContent((RunData)this.rundata);
        }
        if (result == null) {
            result = new ConcreteElement();
        }
        return result;
    }

    public static Portlet getCustomizer(Portlet p) {
        Portlet customizer = p;
        while (p instanceof PortletControl) {
            p = ((PortletControl)p).getPortlet();
        }
        if (!p.providesCustomization()) {
            String name = p.getPortletConfig().getInitParameter("_customizer");
            if (name == null) {
                String key = p instanceof PortletSet ? "PortletSet" : "Portlet";
                name = JetspeedResources.getString("customizer." + key, key + "Customizer");
            }
            try {
                customizer = PortletFactory.getPortlet(name, p.getID() + "customize");
                customizer.getPortletConfig().setPortletSkin(p.getPortletConfig().getPortletSkin());
                PortletControl control = PortalToolkit.getControl((String)null);
                if (control != null) {
                    control.setPortlet(customizer);
                    control.init();
                    return control;
                }
            }
            catch (Exception e) {
                logger.error("Exception", e);
            }
        }
        return customizer;
    }

    public static Portlet getPortletInfoPortlet(RunData data) {
        Portlet info = null;
        String name = JetspeedResources.getString("PortletInfoPortlet.name", "PortletInfoPortlet");
        try {
            if (null != data) {
                Portlet source;
                JetspeedRunData jdata = (JetspeedRunData)data;
                Profile profile = jdata.getProfile();
                if (null == profile) {
                    logger.warn("JetspeedTool: profile is null");
                    profile = Profiler.getProfile((RunData)jdata);
                    jdata.setProfile(profile);
                }
                if ((source = JetspeedTool.findPortlet(data)) != null) {
                    jdata.setPortlet(source.getName());
                    info = PortletFactory.getPortlet(name, "PortletInfoPortlet");
                    info.getPortletConfig().setPortletSkin(source.getPortletConfig().getPortletSkin());
                    PortletControl control = PortalToolkit.getControl((String)null);
                    if (control != null) {
                        control.setPortlet(info);
                        control.init();
                        return control;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception", e);
        }
        return info;
    }

    private static Portlet findPortlet(RunData rundata) {
        Portlet found = null;
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        String peid = jdata.getJs_peid();
        if (peid != null) {
            Stack<Portlet> sets = new Stack<Portlet>();
            sets.push(jdata.getProfile().getRootSet());
            while (found == null && sets.size() > 0) {
                PortletSet set = (PortletSet)sets.pop();
                if (set.getID().equals(peid)) {
                    found = set;
                    continue;
                }
                Enumeration en = set.getPortlets();
                while (found == null && en.hasMoreElements()) {
                    Portlet p;
                    Portlet real = p = (Portlet)en.nextElement();
                    while (real instanceof PortletControl) {
                        real = ((PortletControl)p).getPortlet();
                    }
                    if (real instanceof PortletSet) {
                        if (real.getID().equals(peid)) {
                            found = real;
                            continue;
                        }
                        sets.push(real);
                        continue;
                    }
                    if (!p.getID().equals(peid)) continue;
                    found = p;
                }
            }
        }
        return found;
    }

    public ConcreteElement getPortalElement(String id) {
        Object result = null;
        if (null != this.rundata) {
            Profile profile = this.rundata.getProfile();
            try {
                PSMLDocument doc;
                if (null == profile) {
                    System.out.println("profile is null");
                    profile = Profiler.getProfile((RunData)this.rundata);
                    this.rundata.setProfile(profile);
                }
                if (null != (doc = profile.getDocument())) {
                    Portlet p;
                    Entry entry = doc.getEntryById(id);
                    result = null == entry ? new StringElement("not implemented - PortletElement") : ((p = PortletFactory.getPortlet(entry)) != null ? p.getContent((RunData)this.rundata) : new StringElement("Error retrieving PortletElement"));
                }
            }
            catch (Exception e) {
                logger.error("Exception", e);
            }
        }
        if (result == null) {
            result = new StringElement("Error fetching pane");
        }
        return result;
    }

    public ConcreteElement getPortletById(String peid) {
        ConcreteElement result = null;
        Portlet found = null;
        Stack<Portlet> sets = new Stack<Portlet>();
        sets.push(this.rundata.getProfile().getRootSet());
        while (sets.size() > 0 && found == null) {
            PortletSet set = (PortletSet)sets.pop();
            if (set.getID().equals(peid)) {
                found = set;
                continue;
            }
            Enumeration en = set.getPortlets();
            while (found == null && en.hasMoreElements()) {
                Portlet p;
                Portlet real = p = (Portlet)en.nextElement();
                while (real instanceof PortletControl) {
                    real = ((PortletControl)p).getPortlet();
                }
                if (real instanceof PortletSet) {
                    sets.push(real);
                    continue;
                }
                if (!p.getID().equals(peid)) continue;
                found = p;
            }
        }
        if (found != null) {
            result = PortletWrapper.wrap(found).getContent((RunData)this.rundata);
        }
        if (result == null) {
            result = new ConcreteElement();
        }
        return result;
    }

    public ConcreteElement getPortletFromRegistry(RunData data) {
        Object result = null;
        Portlet p = null;
        String portletName = data.getParameters().getString("p");
        String controlName = data.getParameters().getString("c");
        try {
            PortletEntry entry = (PortletEntry)Registry.getEntry(Registry.PORTLET, portletName);
            boolean canAccess = JetspeedSecurity.checkPermission((JetspeedUser)data.getUser(), new PortalResource(entry), "customize");
            if (canAccess) {
                PortletControl control;
                p = PortletFactory.getPortlet(portletName, "preview");
                PortletControl portletControl = control = controlName == null ? PortalToolkit.getControl((String)null) : PortalToolkit.getControl(controlName);
                if (control != null) {
                    JetspeedRunData jdata = this.rundata;
                    p.getPortletConfig().setPortletSkin(PortalToolkit.getSkin(jdata.getProfile().getDocument().getPortlets().getSkin()));
                    control.setPortlet(p);
                    control.init();
                    result = control.getContent((RunData)this.rundata);
                } else if (p != null) {
                    result = p.getContent((RunData)this.rundata);
                }
            } else {
                result = new JetspeedClearElement(Localization.getString((RunData)data, (String)"SECURITY_NO_ACCESS_TO_PORTLET"));
            }
        }
        catch (Exception e) {
            logger.error("Exception", e);
            result = new ConcreteElement();
        }
        if (result == null) {
            result = new ConcreteElement();
        }
        return result;
    }

    public ConcreteElement getPortletFromRegistry(String portletName, String controlName) {
        ConcreteElement result = null;
        Portlet p = null;
        try {
            PortletControl control;
            p = PortletFactory.getPortlet(portletName, "preview");
            PortletControl portletControl = control = controlName == null ? PortalToolkit.getControl((String)null) : PortalToolkit.getControl(controlName);
            if (control != null) {
                JetspeedRunData jdata = this.rundata;
                p.getPortletConfig().setPortletSkin(PortalToolkit.getSkin(jdata.getProfile().getDocument().getPortlets().getSkin()));
                control.setPortlet(p);
                control.init();
                result = control.getContent((RunData)this.rundata);
            } else if (p != null) {
                result = p.getContent((RunData)this.rundata);
            }
        }
        catch (Exception e) {
            logger.error("Exception", e);
            result = new ConcreteElement();
        }
        if (result == null) {
            result = new ConcreteElement();
        }
        return result;
    }

    public static String getPortletParameter(RunData data, Portlet portlet, String parmName) {
        if (portlet != null && parmName != null) {
            String parmValue = portlet.getPortletConfig().getInitParameter(parmName, "");
            return JetspeedTool.getPortletParameter(data, portlet, parmName, parmValue);
        }
        return "";
    }

    public static String getPortletParameter(RunData data, Portlet portlet, String parmName, String parmValue) {
        String result = null;
        try {
            if (portlet != null && parmName != null) {
                PortletEntry entry = (PortletEntry)Registry.getEntry(Registry.PORTLET, portlet.getName());
                Parameter param = entry.getParameter(parmName);
                boolean canAccess = JetspeedSecurity.checkPermission((JetspeedUser)data.getUser(), new PortalResource(entry, param), "customize");
                Map portletParms = portlet.getPortletConfig().getInitParameters();
                String parmStyle = portlet.getPortletConfig().getInitParameter(parmName + ".style");
                portletParms.put(parmName.concat(".style.portlet"), portlet);
                if (canAccess) {
                    result = parmStyle != null ? ParameterLoader.getInstance().eval(data, parmStyle, parmName, parmValue, portletParms) : "<input type=\"text\" name=\"" + parmName + "\" value=\"" + parmValue + "\"";
                } else {
                    String parmNameNoAccess = portlet.getPortletConfig().getInitParameter(parmName + ".style.no-access");
                    if (parmNameNoAccess != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("JetspeedTool: access to parm [" + parmName + "] disallowed, redirecting to parm [" + parmNameNoAccess + "]");
                        }
                        String parmStyleNoAccess = portlet.getPortletConfig().getInitParameter(parmNameNoAccess + ".style");
                        result = ParameterLoader.getInstance().eval(data, parmStyleNoAccess, parmNameNoAccess, parmValue, portletParms);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception", e);
        }
        return result;
    }

    public static String getParameter(RunData data, String parmStyle, String parmName, String parmValue, String parmOptions) {
        String result = null;
        try {
            if (parmName != null) {
                if (parmStyle != null) {
                    Hashtable<String, String> options = null;
                    if (parmOptions != null && parmOptions.length() > 0) {
                        options = new Hashtable<String, String>();
                        StringTokenizer st = new StringTokenizer(parmOptions, ";");
                        String prefix = parmName + ".style.";
                        while (st.hasMoreTokens()) {
                            StringTokenizer pair = new StringTokenizer(st.nextToken(), "=");
                            if (pair.countTokens() != 2) continue;
                            options.put(prefix + pair.nextToken().trim(), pair.nextToken().trim());
                        }
                    }
                    result = ParameterLoader.getInstance().eval(data, parmStyle, parmName, parmValue, options);
                } else {
                    result = "<input type=\"text\" name=\"" + parmName + "\" value=\"" + parmValue + "\"";
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception", e);
            result = "<input type=\"text\" name=\"" + parmName + "\" value=\"" + parmValue + "\"";
        }
        return result;
    }

    public SecurityReference getSecurityReference(Entry entry) {
        return JetspeedSecurity.getSecurityReference(entry, this.rundata);
    }

    public int getSecuritySource(Entry entry) {
        return JetspeedSecurity.getSecuritySource(entry, this.rundata);
    }

    public Entry getEntryFromRequest() throws Exception {
        String jsPeid = this.rundata.getParameters().getString("js_peid");
        Profile profile = Profiler.getProfile((RunData)this.rundata);
        PSMLDocument doc = profile.getDocument();
        return doc.getEntryById(jsPeid);
    }
}

