/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util.template;

import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.portal.PanedPortletController;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletController;
import org.apache.jetspeed.portal.PortletSet;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.services.pull.ApplicationTool;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.template.TemplateLink;

public class JetspeedTemplateLink
extends TemplateLink
implements ApplicationTool {
    public static final String PORTLET_KEY = "portlet";
    public static final String ACTION_KEY = "action";
    public static final String SCREEN_KEY = "screen";
    public static final String TEMPLATE_KEY = "template";
    public static final String PANEL_KEY = "select-panel";
    private String portletName = null;
    private JetspeedRunData data = null;
    protected Portlet activePortlet = null;

    public JetspeedTemplateLink() {
    }

    public JetspeedTemplateLink(RunData data) {
        super(data);
        this.data = (JetspeedRunData)data;
        String tmpl = this.data.getRequestedTemplate();
        if (tmpl != null) {
            this.setPage(tmpl);
        }
    }

    public void init(Object data) {
        super.init(data);
        this.data = (JetspeedRunData)data;
        String tmpl = this.data.getRequestedTemplate();
        if (tmpl != null) {
            this.setPage(tmpl);
        }
    }

    public void setPortlet(Portlet portlet) {
        this.activePortlet = portlet;
    }

    public void refresh() {
        super.refresh();
        String tmpl = this.data.getRequestedTemplate();
        if (tmpl != null) {
            this.setPage(tmpl);
        }
    }

    public DynamicURI forPortlet(String portlet) {
        this.portletName = portlet;
        this.removePathInfo(this.getPortletKey());
        this.removeQueryData(this.getPortletKey());
        return this.addPathInfo(this.getPortletKey(), portlet);
    }

    public DynamicURI setPortlet(String portlet) {
        return this.forPortlet(portlet);
    }

    public String getPortlet() {
        return this.portletName;
    }

    public String getPortletKey() {
        return PORTLET_KEY;
    }

    public String getActionKey() {
        return ACTION_KEY;
    }

    public String getScreenKey() {
        return SCREEN_KEY;
    }

    public String getPageKey() {
        return TEMPLATE_KEY;
    }

    public DynamicURI setPanel(String panel) {
        this.removePathInfo("js_pane");
        this.removeQueryData("js_pane");
        PortletController controller = this.activePortlet.getPortletConfig().getPortletSet().getController();
        String id = null;
        if (controller instanceof PanedPortletController) {
            PortletSet set = controller.getPortlets();
            Portlet portlet = null;
            if (null != set) {
                portlet = set.getPortletByName(panel);
            }
            if (portlet != null) {
                id = portlet.getID();
            }
        } else {
            Portlets entry = this.data.getProfile().getDocument().getPortlets(panel);
            if (entry != null) {
                id = entry.getId();
            }
        }
        return this.addPathInfo("js_pane", id);
    }

    public String getPanelKey() {
        String panelName = PANEL_KEY;
        try {
            PortletController controller = this.activePortlet.getPortletConfig().getPortletSet().getController();
            if (controller instanceof PanedPortletController) {
                panelName = ((PanedPortletController)controller).getParameterName();
            }
        }
        catch (Exception e) {
            panelName = PANEL_KEY;
        }
        return panelName;
    }

    public String toString() {
        String tmpl = this.data.getRequestedTemplate();
        if (tmpl != null) {
            this.setPage(tmpl);
        }
        String buf = super.toString();
        return buf;
    }

    public DynamicURI getPortletByName(String portletName) {
        String id = null;
        Entry entry = this.data.getProfile().getDocument().getEntry(portletName);
        if (entry != null) {
            id = entry.getId();
        }
        System.out.println("js_peid:" + id);
        return this.addPathInfo("js_peid", id);
    }

    public void clear() {
        this.removePathInfo();
        this.removeQueryData();
    }
}

