/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.apache.oro.text.perl.Perl5Util;

public class ValidationHelper {
    public static boolean isAlphaNumeric(String evalString, boolean required) {
        if (StringUtils.isEmpty((String)evalString)) {
            return true != required;
        }
        Perl5Util util = new Perl5Util();
        return util.match("/^[\\w\\s]+$/", evalString);
    }

    public static boolean isAlphaNumeric(String evalString, boolean required, int maxLength) {
        if (ValidationHelper.isTooLong(evalString, maxLength)) {
            return false;
        }
        return ValidationHelper.isAlphaNumeric(evalString, required);
    }

    public static boolean isLooseAlphaNumeric(String evalString, boolean required) {
        if (StringUtils.isEmpty((String)evalString)) {
            return true != required;
        }
        Perl5Util util = new Perl5Util();
        return util.match("/^[\\w\\s\\.\\,\\/\\-\\(\\)\\+]+$/", evalString);
    }

    public static boolean isLooseAlphaNumeric(String evalString, boolean required, int maxLength) {
        if (ValidationHelper.isTooLong(evalString, maxLength)) {
            return false;
        }
        return ValidationHelper.isLooseAlphaNumeric(evalString, required);
    }

    public static boolean isDecimal(String evalString, boolean required) {
        if (StringUtils.isEmpty((String)evalString)) {
            return true != required;
        }
        Perl5Util util = new Perl5Util();
        return util.match("/^(\\d+\\.)?\\d+$/", evalString);
    }

    public static boolean isDecimal(String evalString, boolean required, int maxLength) {
        if (ValidationHelper.isTooLong(evalString, maxLength)) {
            return false;
        }
        return ValidationHelper.isDecimal(evalString, required);
    }

    public static boolean isInteger(String evalString, boolean required) {
        if (StringUtils.isEmpty((String)evalString)) {
            return true != required;
        }
        Perl5Util util = new Perl5Util();
        return util.match("/^\\d+$/", evalString);
    }

    public static boolean isInteger(String evalString, boolean required, int maxLength) {
        if (ValidationHelper.isTooLong(evalString, maxLength)) {
            return false;
        }
        return ValidationHelper.isInteger(evalString, required);
    }

    public static boolean isEmailAddress(String evalString, boolean required) {
        if (StringUtils.isEmpty((String)evalString)) {
            return true != required;
        }
        Perl5Util util = new Perl5Util();
        return util.match("/^(?:\\w[\\w-]*\\.)*\\w[\\w-]*@(?:\\w[\\w-]*\\.)+\\w[\\w-]*$/", evalString);
    }

    public static boolean isEmailAddress(String evalString, boolean required, int maxLength) {
        if (ValidationHelper.isTooLong(evalString, maxLength)) {
            return false;
        }
        return ValidationHelper.isEmailAddress(evalString, required);
    }

    public static boolean isURL(String evalString, boolean required) {
        try {
            if (StringUtils.isEmpty((String)evalString)) {
                return true != required;
            }
            URL url = new URL(evalString);
            return true;
        }
        catch (Exception e) {
            System.err.println(evalString + " is not a valid URL: " + e);
            return false;
        }
    }

    public static boolean isURL(String evalString, boolean required, int maxLength) {
        if (ValidationHelper.isTooLong(evalString, maxLength)) {
            return false;
        }
        return ValidationHelper.isURL(evalString, required);
    }

    public static boolean isValidIdentifier(String folderName) {
        boolean valid = true;
        char[] chars = folderName.toCharArray();
        for (int ix = 0; ix < chars.length; ++ix) {
            if (Character.isJavaIdentifierPart(chars[ix])) continue;
            valid = false;
            break;
        }
        return valid;
    }

    public static boolean isTooLong(String evalString, int maxLength) {
        if (null != evalString) {
            return evalString.length() > maxLength;
        }
        return false;
    }
}

