/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

public class MimeType {
    public static final MimeType HTML = new MimeType("text/html", "UTF-8");
    public static final MimeType XHTML = new MimeType("text/xhtml");
    public static final MimeType WML = new MimeType("text/vnd.wap.wml");
    public static final MimeType XML = new MimeType("text/xml");
    public static final MimeType VXML = new MimeType("text/vxml");
    private String mimeType = "";
    private String charSet = null;

    public MimeType(String mimeType) {
        if (mimeType == null) {
            throw new NullPointerException();
        }
        this.mimeType = mimeType;
    }

    public MimeType(String mimeType, String charSet) {
        if (mimeType == null) {
            throw new NullPointerException();
        }
        this.mimeType = mimeType;
        this.charSet = charSet;
    }

    public String getCode() {
        String type = this.mimeType;
        int idx = (type = type.substring(type.indexOf("/") + 1)).lastIndexOf(".");
        if (idx >= 0) {
            type = type.substring(idx + 1);
        }
        if ((idx = type.lastIndexOf("-")) >= 0) {
            type = type.substring(idx + 1);
        }
        return type.toLowerCase();
    }

    public String getContentType() {
        return this.mimeType;
    }

    public String getCharSet() {
        return this.charSet;
    }

    public String toString() {
        if (null == this.charSet) {
            return this.mimeType;
        }
        return this.mimeType + "; charset=" + this.charSet;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MimeType) {
            MimeType comp = (MimeType)obj;
            return this.toString().equals(comp.toString());
        }
        return false;
    }
}

