/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.webpage;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.services.webpage.Configuration;
import org.apache.jetspeed.services.webpage.SessionMap;
import org.apache.jetspeed.services.webpage.SiteSession;
import org.apache.jetspeed.services.webpage.WebPageManager;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.servlet.VelocityServlet;

public class WebPageConsoleServlet
extends VelocityServlet {
    private String servletPath = null;
    private String proxyRoot = null;

    public Template handleRequest(HttpServletRequest request, HttpServletResponse response, Context ctx) {
        String action;
        boolean online;
        if (this.servletPath == null) {
            this.servletPath = request.getServletPath();
            this.proxyRoot = this.getProxyHost(request);
        }
        if (!(online = WebPageManager.isInit())) {
            this.bootStrapProxy(request, response);
        }
        String template = (action = request.getParameter("action")) == null ? this.sessions(ctx) : (action.equals("details") ? this.elementSessions(ctx, request) : (action.equals("test") ? this.test(ctx, request) : (action.equals("kill") ? this.kill(ctx, request) : (action.equals("killne") ? this.killne(ctx) : (action.equals("clear") ? this.clear(ctx) : this.sessions(ctx))))));
        Template outty = null;
        try {
            outty = this.getTemplate(template);
        }
        catch (ParseErrorException pee) {
            System.out.println("WebPageConsoleServlet : parse error for template " + (Object)((Object)pee));
        }
        catch (ResourceNotFoundException rnfe) {
            System.out.println("WebPageConsoleServlet : template not found " + (Object)((Object)rnfe));
        }
        catch (Exception e) {
            System.out.println("Error " + e);
        }
        return outty;
    }

    protected Properties loadConfiguration(ServletConfig config) throws IOException, FileNotFoundException {
        String path;
        String log;
        String propsFile = config.getInitParameter("org.apache.velocity.properties");
        Properties p = new Properties();
        if (propsFile != null) {
            String realPath = this.getServletContext().getRealPath(propsFile);
            if (realPath != null) {
                propsFile = realPath;
            }
            p.load(new FileInputStream(propsFile));
        }
        if ((log = p.getProperty("runtime.log")) != null && (log = this.getServletContext().getRealPath(log)) != null) {
            p.setProperty("runtime.log", log);
        }
        if ((path = p.getProperty("file.resource.loader.path")) != null && (path = this.getServletContext().getRealPath(path)) != null) {
            p.setProperty("file.resource.loader.path", path);
        }
        return p;
    }

    private String sessions(Context ctx) {
        Collection sessions = WebPageManager.getSessions();
        Collection targets = WebPageManager.getSites();
        boolean online = WebPageManager.isInit();
        ctx.put("sessions", (Object)sessions);
        ctx.put("targets", (Object)targets);
        ctx.put("online", (Object)new Boolean(online));
        ctx.put("proxyError", (Object)WebPageManager.getErrorString());
        ctx.put("cmd", (Object)this);
        return "proxyConsole.vm";
    }

    private String elementSessions(Context ctx, HttpServletRequest request) {
        String sid = request.getParameter("id");
        if (sid == null) {
            return this.sessions(ctx);
        }
        SessionMap map = WebPageManager.getSession(sid);
        if (map == null) {
            return this.sessions(ctx);
        }
        boolean online = WebPageManager.isInit();
        ctx.put("online", (Object)new Boolean(online));
        ctx.put("proxyError", (Object)WebPageManager.getErrorString());
        ctx.put("cmd", (Object)this);
        ctx.put("ne_sessions", (Object)map);
        return "neConsole.vm";
    }

    private String kill(Context ctx, HttpServletRequest request) {
        boolean online = WebPageManager.isInit();
        Collection sessions = WebPageManager.getSessions();
        Collection elements = WebPageManager.getSites();
        ctx.put("xxx_sessions", (Object)sessions);
        ctx.put("elements", (Object)elements);
        ctx.put("online", (Object)new Boolean(online));
        ctx.put("proxyError", (Object)WebPageManager.getErrorString());
        ctx.put("cmd", (Object)this);
        return "proxyConsole.vm";
    }

    private String killne(Context ctx) {
        return "proxyConsole.vm";
    }

    private String clear(Context ctx) {
        return "proxyConsole.vm";
    }

    private String test(Context ctx, HttpServletRequest request) {
        String id = request.getParameter("id");
        if (id == null) {
            return this.sessions(ctx);
        }
        SessionMap map = WebPageManager.getSession(id);
        if (map == null) {
            return this.sessions(ctx);
        }
        String ipa = request.getParameter("ipa");
        if (ipa == null) {
            return this.sessions(ctx);
        }
        SiteSession session = (SiteSession)map.get(ipa);
        if (session == null) {
            return this.sessions(ctx);
        }
        boolean online = WebPageManager.isInit();
        ctx.put("online", (Object)new Boolean(online));
        ctx.put("proxyError", (Object)WebPageManager.getErrorString());
        ctx.put("cmd", (Object)this);
        ctx.put("ne_sessions", (Object)map);
        ctx.put("nes", (Object)session);
        return "testConsole.vm";
    }

    public String getRefresh() {
        return this.servletPath + "?action=refresh";
    }

    public String getClear() {
        return this.servletPath + "?action=clear";
    }

    public String getDetails() {
        return this.servletPath + "?action=details";
    }

    public String getTest() {
        return this.servletPath + "?action=test";
    }

    public String getKill() {
        return this.servletPath + "?action=kill";
    }

    public String getKillne() {
        return this.servletPath + "?action=killne";
    }

    public String getLogon() {
        String proxy = this.proxyRoot;
        Configuration config = Configuration.getInstance();
        proxy = proxy.concat("?logon-test=true&" + config.getSID() + "=");
        return proxy;
    }

    public String getProxyRoot() {
        return this.proxyRoot;
    }

    public String getWebapp() {
        Configuration config = Configuration.getInstance();
        return config.getWebapp();
    }

    private String getProxyHost(HttpServletRequest request) {
        StringBuffer root = new StringBuffer();
        String scheme = request.getScheme();
        root.append(scheme);
        root.append("://");
        int port = request.getServerPort();
        root.append(request.getServerName());
        if (port > 0 && (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443)) {
            root.append(":");
            root.append(port);
        }
        root.append("/wps");
        return root.toString();
    }

    void bootStrapProxy(HttpServletRequest request, HttpServletResponse response) {
        ServletContext ctx = this.getServletContext();
        try {
            RequestDispatcher dispatcher = ctx.getRequestDispatcher("/wps");
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

