/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.webpage;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.services.webpage.Configuration;
import org.apache.jetspeed.services.webpage.ProxyRunData;
import org.apache.jetspeed.services.webpage.SiteSession;
import org.apache.jetspeed.services.webpage.WebPageHelper;
import org.apache.log4j.Logger;
import sun.net.www.protocol.http.Handler;

public abstract class AbstractSiteSession
implements SiteSession {
    protected String targetBase;
    protected String proxyBase;
    protected HashMap cookies = new HashMap();
    protected int hitCount = 0;
    protected int cacheCount = 0;
    static Logger log = Logger.getLogger(AbstractSiteSession.class);

    public AbstractSiteSession(String targetBase, String proxyBase) {
        this.proxyBase = proxyBase;
        this.targetBase = targetBase;
    }

    public void dispatch(String url, ProxyRunData data) throws IOException {
        try {
            String cookieString;
            int contentType;
            HttpURLConnection con;
            block17: {
                String location;
                block16: {
                    Configuration config = Configuration.getInstance();
                    log.debug((Object)("=== Dispatching =" + url));
                    URL u = new URL(null, url, new Handler());
                    con = (HttpURLConnection)u.openConnection();
                    con.setDoInput(true);
                    con.setDoOutput(true);
                    con.setAllowUserInteraction(false);
                    HttpURLConnection.setFollowRedirects(false);
                    if (data.getPosting()) {
                        con.setRequestMethod("POST");
                    }
                    if (this.cookies.isEmpty()) {
                        log.debug((Object)"... no session id provided. Logging on...");
                        if (!this.logon(data)) {
                            return;
                        }
                    }
                    for (Cookie cookie : this.cookies.values()) {
                        String sessionID = WebPageHelper.buildCookieString(cookie);
                        con.setRequestProperty("Cookie", sessionID);
                        log.debug((Object)("... Sending Session ID: " + sessionID));
                    }
                    if (data.getPosting()) {
                        StringBuffer postParams = new StringBuffer();
                        int count = 0;
                        Enumeration e = data.getRequest().getParameterNames();
                        while (e.hasMoreElements()) {
                            String[] values;
                            String name = (String)e.nextElement();
                            if (name.equals(config.getSID()) || name.equals(config.getURL()) || (values = data.getRequest().getParameterValues(name)) == null) continue;
                            for (int i = 0; i < values.length; ++i) {
                                if (count > 0) {
                                    postParams.append("&");
                                }
                                postParams.append(name);
                                postParams.append("=");
                                postParams.append(URLEncoder.encode(values[i]));
                                ++count;
                            }
                        }
                        String postString = postParams.toString();
                        con.setRequestProperty("Content-length", String.valueOf(postString.length()));
                        DataOutputStream dos = new DataOutputStream(con.getOutputStream());
                        log.debug((Object)("... POST: " + postString));
                        dos.writeBytes(postString);
                        dos.close();
                    }
                    int rc = con.getResponseCode();
                    contentType = WebPageHelper.getContentType(con.getHeaderField("content-type"), u.toString());
                    location = con.getHeaderField("Location");
                    if (rc == 301) break block16;
                    if (rc != 302) break block17;
                }
                if (null != location) {
                    log.debug((Object)("+++ REDIRECT = " + location));
                    location = WebPageHelper.concatURLs(this.targetBase, location);
                    this.dispatch(location, data);
                    return;
                }
            }
            if (null != (cookieString = con.getHeaderField("Set-Cookie"))) {
                log.debug((Object)("... new SessionID found: " + cookieString));
                WebPageHelper.parseCookies(cookieString, this);
            }
            if (contentType == 4 || contentType == 1 || contentType == 2) {
                this.getBinaryContent(con, data.getResponse());
                return;
            }
            this.rewriteContent(data, con, contentType, url);
        }
        catch (IOException ex) {
            log.error((Object)("*** PROXY DISPATCH EXCEPTION = " + ex));
            throw ex;
        }
    }

    public String getHTMLContent(URLConnection con, ProxyRunData data, String resource) throws IOException {
        int CAPACITY = 4096;
        InputStream is = con.getInputStream();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        Configuration config = Configuration.getInstance();
        FileOutputStream fos = null;
        boolean logging = config.getEnableContentLog();
        if (logging && data != null) {
            String fileName = data.getServlet().getServletContext().getRealPath(config.getLogLocation());
            fos = new FileOutputStream(fileName, true);
            WebPageHelper.writeHeader(fos, resource);
        }
        byte[] bytes = new byte[CAPACITY];
        int readCount = 0;
        int total = 0;
        while ((readCount = is.read(bytes)) > 0) {
            buffer.write(bytes, 0, readCount);
            if (logging) {
                fos.write(bytes, 0, readCount);
            }
            total += readCount;
        }
        if (logging) {
            fos.close();
        }
        is.close();
        return buffer.toString();
    }

    public void getBinaryContent(URLConnection con, HttpServletResponse response) throws IOException {
        int CAPACITY = 4096;
        InputStream is = con.getInputStream();
        byte[] bytes = new byte[CAPACITY];
        int readCount = 0;
        while ((readCount = is.read(bytes)) > 0) {
            response.getOutputStream().write(bytes, 0, readCount);
        }
        is.close();
    }

    public boolean addCookieToSession(Cookie cookie) {
        boolean added = null == this.cookies.get(cookie.getName());
        this.cookies.put(cookie.getName(), cookie);
        return added;
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public void incHitCount() {
        ++this.hitCount;
    }

    public int getCacheCount() {
        return this.cacheCount;
    }

    public void incCacheCount() {
        ++this.cacheCount;
    }
}

