/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.threadpool;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.threadpool.JetspeedThreadPoolService;
import org.apache.turbine.services.TurbineServices;

public class RunnableThread
extends Thread {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(RunnableThread.class.getName());
    private boolean running = false;
    private static int next_id = 0;
    private int id = 0;
    private Runnable runnable = null;

    private static synchronized int getNextId() {
        return ++next_id;
    }

    public RunnableThread() {
        this.setDaemon(true);
    }

    public RunnableThread(ThreadGroup tg) {
        super(tg, "Provisory");
        this.id = RunnableThread.getNextId();
        super.setName("RunnableThread:" + this.id);
        this.setPriority(1);
        this.setDaemon(true);
    }

    public RunnableThread(ThreadGroup tg, int id) {
        super(tg, "RunnableThread:" + id);
        this.setPriority(1);
        this.setDaemon(true);
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean poolrunning = true;
        while (poolrunning) {
            this.setRunning(false);
            this.setRunnable(null);
            RunnableThread runnableThread = this;
            synchronized (runnableThread) {
                if (this.getPriority() != 1) {
                    this.setPriority(1);
                }
                ((JetspeedThreadPoolService)TurbineServices.getInstance().getService("ThreadPool")).release(this);
                if (this.getRunnable() == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                    }
                    catch (Throwable t) {
                        logger.error("Throwable", t);
                    }
                }
            }
            if (this.getRunnable() == null) continue;
            this.setRunning(true);
            try {
                this.getRunnable().run();
            }
            catch (Throwable t) {
                logger.error("A problem occured while trying to run your thread", t);
            }
        }
    }

    public void setRunnable(Runnable runnable) {
        this.runnable = runnable;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    private boolean isRunning() {
        return this.running;
    }

    private void setRunning(boolean running) {
        this.running = running;
    }

    public long getId() {
        return this.id;
    }
}

