/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.threadpool;

import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.threadpool.Queue;
import org.apache.jetspeed.services.threadpool.RunnableThread;
import org.apache.jetspeed.services.threadpool.ThreadPoolService;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;

public class JetspeedThreadPoolService
extends TurbineBaseService
implements ThreadPoolService {
    protected static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedThreadPoolService.class.getName());
    private int initThreads = 50;
    private int maxThreads = 100;
    private int minSpareThreads = 15;
    public static final int DEFAULT_THREAD_PRIORITY = 1;
    private Vector availableThreads = new Vector();
    private ThreadGroup tg = new ThreadGroup("JetspeedThreadPoolService");
    private Queue queue = new Queue();
    private int count = 0;
    public static final String SERVICE_NAME = "ThreadPool";

    public void init() {
        while (!this.getInit()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ie) {
                logger.info("ThreadPool service: Waiting for init()...");
            }
        }
    }

    public synchronized void init(ServletConfig config) {
        if (this.getInit()) {
            return;
        }
        try {
            logger.info("JetspeedThreadPoolService early init()....starting!");
            this.initThreadpool(config);
            this.setInit(true);
            logger.info("JetspeedThreadPoolService early init()....finished!");
        }
        catch (Exception e) {
            logger.error("Cannot initialize JetspeedThreadPoolService!", e);
        }
    }

    public void process(Runnable runnable) {
        this.process(runnable, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Runnable runnable, int priority) {
        RunnableThread thread = this.getAvailableThread();
        if (thread == null) {
            this.getQueue().add(runnable);
        } else {
            try {
                RunnableThread runnableThread = thread;
                synchronized (runnableThread) {
                    int defaultPriority = thread.getPriority();
                    if (defaultPriority != priority) {
                        thread.setPriority(priority);
                    }
                    thread.setRunnable(runnable);
                    thread.notify();
                }
            }
            catch (Throwable t) {
                logger.error("Throwable", t);
            }
        }
    }

    public int getThreadCount() {
        return this.tg.activeCount();
    }

    public int getAvailableThreadCount() {
        return this.availableThreads.size();
    }

    public int getQueueLength() {
        return this.getQueue().size();
    }

    public int getThreadProcessedCount() {
        return this.count;
    }

    Queue getQueue() {
        return this.queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(RunnableThread thread) {
        Vector vector = this.availableThreads;
        synchronized (vector) {
            this.availableThreads.addElement(thread);
            ++this.count;
            Queue queue = this.getQueue();
            synchronized (queue) {
                if (this.getQueue().size() > 0) {
                    Runnable r = this.getQueue().get();
                    if (r != null) {
                        this.process(r);
                    } else {
                        logger.info("JetspeedThreadPoolService: no Runnable found.");
                    }
                }
            }
        }
    }

    private void initThreadpool(ServletConfig config) {
        try {
            ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources(SERVICE_NAME);
            this.initThreads = serviceConf.getInt("init.count", 10);
            this.maxThreads = serviceConf.getInt("max.count", 50);
            this.minSpareThreads = serviceConf.getInt("minspare.count", 10);
        }
        catch (NumberFormatException e) {
            logger.error("Invalid number format in properties", e);
        }
        this.createThreads(this.initThreads);
    }

    private synchronized void createThreads(int count) {
        if (this.getThreadCount() < this.maxThreads && this.getThreadCount() + count > this.maxThreads) {
            count = this.maxThreads - this.getThreadCount();
        } else if (this.getThreadCount() >= this.maxThreads) {
            return;
        }
        logger.info("JetspeedThreadPoolService:  creating " + count + " more thread(s) for a total of: " + (this.getThreadCount() + count));
        for (int i = 0; i < count; ++i) {
            RunnableThread thread = new RunnableThread(this.tg);
            thread.setPriority(1);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunnableThread getAvailableThread() {
        Vector vector = this.availableThreads;
        synchronized (vector) {
            if (this.getAvailableThreadCount() < this.minSpareThreads) {
                this.createThreads(this.minSpareThreads);
            }
            if (this.getAvailableThreadCount() == 0) {
                return null;
            }
            RunnableThread thread = null;
            int id = this.availableThreads.size() - 1;
            thread = (RunnableThread)this.availableThreads.elementAt(id);
            this.availableThreads.removeElementAt(id);
            return thread;
        }
    }
}

