/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.statemanager;

import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.jetspeed.services.statemanager.BaseStateManagerService;

public class JetspeedHttpStateManagerService
extends BaseStateManagerService {
    protected void initStates() {
    }

    protected void shutdownStates() {
    }

    private HttpSession getSession() {
        HttpSession session = (HttpSession)this.m_httpSessions.get(Thread.currentThread());
        if (session == null) {
            return null;
        }
        try {
            session.isNew();
        }
        catch (IllegalStateException e) {
            return null;
        }
        return session;
    }

    private String getSessionKey(String key) {
        return JetspeedHttpStateManagerService.class.getName() + "." + key;
    }

    protected Map getState(String key) {
        HttpSession session = this.getSession();
        if (session == null) {
            return null;
        }
        StateEntry stateEntry = (StateEntry)session.getAttribute(this.getSessionKey(key));
        if (stateEntry == null) {
            return null;
        }
        return stateEntry.getMap();
    }

    protected void addState(String key, Map state) {
        HttpSession session = this.getSession();
        if (session == null) {
            return;
        }
        StateEntry stateEntry = new StateEntry(key, state);
        session.setAttribute(this.getSessionKey(key), (Object)stateEntry);
    }

    protected void removeState(String key) {
        HttpSession session = this.getSession();
        if (session == null) {
            return;
        }
        session.removeAttribute(this.getSessionKey(key));
    }

    protected String[] getStateKeys(String start) {
        HttpSession session = this.getSession();
        if (session == null) {
            return null;
        }
        String pattern = this.getSessionKey(start);
        int subStart = this.getSessionKey("").length();
        Vector<String> rv = new Vector<String>();
        Enumeration names = session.getAttributeNames();
        while (names.hasMoreElements()) {
            String sessionName = (String)names.nextElement();
            if (!sessionName.startsWith(pattern)) continue;
            rv.add(sessionName.substring(subStart));
        }
        if (rv.size() == 0) {
            return null;
        }
        return rv.toArray(new String[rv.size()]);
    }

    private class StateEntry
    implements HttpSessionBindingListener {
        private Map m_map = null;
        private String m_key = null;

        public StateEntry(String key, Map map) {
            this.m_key = key;
            this.m_map = map;
        }

        public Map getMap() {
            return this.m_map;
        }

        public void valueBound(HttpSessionBindingEvent event) {
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            JetspeedHttpStateManagerService.this.retireAttributes(this.m_key, this.m_map);
            this.m_map = null;
            this.m_key = null;
        }
    }
}

