/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.security.turbine;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.om.security.Permission;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.om.security.turbine.TurbinePermission;
import org.apache.jetspeed.om.security.turbine.TurbinePermissionPeer;
import org.apache.jetspeed.om.security.turbine.TurbineRolePermission;
import org.apache.jetspeed.om.security.turbine.TurbineRolePermissionPeer;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.rundata.JetspeedRunDataService;
import org.apache.jetspeed.services.security.JetspeedSecurityCache;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.services.security.PermissionException;
import org.apache.jetspeed.services.security.PermissionManagement;
import org.apache.torque.Torque;
import org.apache.torque.om.NumberKey;
import org.apache.torque.util.Criteria;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;

public class TurbinePermissionManagement
extends TurbineBaseService
implements PermissionManagement {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(TurbinePermissionManagement.class.getName());
    private JetspeedRunDataService runDataService = null;
    private static final String CASCADE_DELETE = "programmatic.cascade.delete";
    private static final boolean DEFAULT_CASCADE_DELETE = true;
    private static final String CONFIG_SYSTEM_PERMISSIONS = "system.permissions";
    private boolean cascadeDelete;
    private static final String CACHING_ENABLE = "caching.enable";
    private boolean cachingEnable = true;
    private Vector systemPermissions = null;

    public Iterator getPermissions(String rolename) throws JetspeedSecurityException {
        HashMap<String, TurbinePermission> perms;
        Role role = null;
        try {
            Iterator iterator;
            if (this.cachingEnable && (iterator = JetspeedSecurityCache.getPermissions(rolename)) != null) {
                return iterator;
            }
            role = JetspeedSecurity.getRole(rolename);
        }
        catch (JetspeedSecurityException e) {
            logger.error("Failed to Retrieve Role: ", (Throwable)((Object)e));
            throw new PermissionException("Failed to Retrieve Role: ", (Throwable)((Object)e));
        }
        Criteria criteria = new Criteria();
        criteria.add(TurbineRolePermissionPeer.ROLE_ID, (Object)role.getId());
        try {
            List rels = TurbineRolePermissionPeer.doSelect(criteria);
            perms = rels.size() > 0 ? new HashMap(rels.size()) : new HashMap<String, TurbinePermission>();
            for (int ix = 0; ix < rels.size(); ++ix) {
                TurbineRolePermission rel = (TurbineRolePermission)((Object)rels.get(ix));
                TurbinePermission perm = rel.getTurbinePermission();
                perms.put(perm.getName(), perm);
            }
        }
        catch (Exception e) {
            logger.error("Failed to retrieve permissions ", e);
            throw new PermissionException("Failed to retrieve permissions ", e);
        }
        return perms.values().iterator();
    }

    public Iterator getPermissions() throws JetspeedSecurityException {
        List permissions;
        Criteria criteria = new Criteria();
        try {
            permissions = TurbinePermissionPeer.doSelect(criteria);
        }
        catch (Exception e) {
            logger.error("Failed to retrieve permissions ", e);
            throw new PermissionException("Failed to retrieve permissions ", e);
        }
        return permissions.iterator();
    }

    public void addPermission(Permission permission) throws JetspeedSecurityException {
        if (this.permissionExists(permission.getName())) {
            throw new PermissionException("The permission '" + permission.getName() + "' already exists");
        }
        try {
            TurbinePermission tpermission = new TurbinePermission();
            tpermission.setPermissionName(permission.getName());
            Criteria criteria = TurbinePermissionPeer.buildCriteria(tpermission);
            NumberKey key = (NumberKey)TurbinePermissionPeer.doInsert(criteria);
            permission.setId(key.toString());
        }
        catch (Exception e) {
            String message = "Failed to create permission '" + permission.getName() + "'";
            logger.error(message, e);
            throw new PermissionException(message, e);
        }
    }

    public void savePermission(Permission permission) throws JetspeedSecurityException {
        if (!this.permissionExists(permission.getName())) {
            throw new PermissionException("The permission '" + permission.getName() + "' doesn't exists");
        }
        try {
            if (!(permission instanceof TurbinePermission)) {
                throw new PermissionException("TurbinePermissionManagment: Permission is not a Turbine permission, cannot update");
            }
            TurbinePermissionPeer.doUpdate((TurbinePermission)permission);
        }
        catch (Exception e) {
            String message = "Failed to create permission '" + permission.getName() + "'";
            logger.error(message, e);
            throw new PermissionException(message, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removePermission(String permissionName) throws JetspeedSecurityException {
        Connection conn = null;
        try {
            if (this.systemPermissions.contains(permissionName)) {
                throw new PermissionException("[" + permissionName + "] is a system permission and cannot be removed");
            }
            conn = Torque.getConnection();
            Permission permission = this.getPermission(permissionName);
            Criteria criteria = new Criteria();
            criteria.add(TurbinePermissionPeer.PERMISSION_NAME, (Object)permissionName);
            if (this.cascadeDelete) {
                Criteria critRolePerm = new Criteria();
                critRolePerm.add(TurbineRolePermissionPeer.PERMISSION_ID, (Object)permission.getId());
                TurbineRolePermissionPeer.doDelete(critRolePerm, conn);
            }
            TurbinePermissionPeer.doDelete(criteria, conn);
            conn.commit();
            if (this.cachingEnable) {
                JetspeedSecurityCache.removeAllPermissions(permissionName);
            }
        }
        catch (Exception e) {
            try {
                try {
                    conn.rollback();
                }
                catch (SQLException sqle) {
                    logger.error("SQLException", sqle);
                }
                String message = "Failed to remove permission '" + permissionName + "'";
                logger.error(message, e);
                throw new PermissionException(message, e);
            }
            catch (Throwable throwable) {
                try {
                    Torque.closeConnection(conn);
                    throw throwable;
                }
                catch (Throwable e2) {
                    logger.error("Error closing Torque connection", e2);
                }
                throw throwable;
            }
        }
        try {
            Torque.closeConnection((Connection)conn);
            return;
        }
        catch (Throwable e) {
            logger.error("Error closing Torque connection", e);
            return;
        }
    }

    public void grantPermission(String roleName, String permissionName) throws JetspeedSecurityException {
        try {
            Role role = JetspeedSecurity.getRole(roleName);
            Permission permission = this.getPermission(permissionName);
            Criteria criteria = new Criteria();
            criteria.add(TurbineRolePermissionPeer.ROLE_ID, (Object)role.getId());
            criteria.add(TurbineRolePermissionPeer.PERMISSION_ID, (Object)permission.getId());
            TurbineRolePermissionPeer.doInsert(criteria);
            if (this.cachingEnable) {
                JetspeedSecurityCache.addPermission(roleName, permission);
            }
        }
        catch (Exception e) {
            String message = "Grant permission '" + permissionName + "' to role '" + roleName + "' failed: ";
            logger.error(message, e);
            throw new PermissionException(message, e);
        }
    }

    public void revokePermission(String roleName, String permissionName) throws JetspeedSecurityException {
        try {
            Role role = JetspeedSecurity.getRole(roleName);
            Permission permission = this.getPermission(permissionName);
            Criteria criteria = new Criteria();
            criteria.add(TurbineRolePermissionPeer.ROLE_ID, (Object)role.getId());
            criteria.add(TurbineRolePermissionPeer.PERMISSION_ID, (Object)permission.getId());
            TurbineRolePermissionPeer.doDelete(criteria);
            if (this.cachingEnable) {
                JetspeedSecurityCache.removePermission(roleName, permissionName);
            }
        }
        catch (Exception e) {
            String message = "Revoke permission '" + permissionName + "' to role '" + roleName + "' failed: ";
            logger.error(message, e);
            throw new PermissionException(message, e);
        }
    }

    public boolean hasPermission(String roleName, String permissionName) throws JetspeedSecurityException {
        List permissions;
        try {
            if (this.cachingEnable) {
                return JetspeedSecurityCache.hasPermission(roleName, permissionName);
            }
            Role role = JetspeedSecurity.getRole(roleName);
            Permission permission = this.getPermission(permissionName);
            Criteria criteria = new Criteria();
            criteria.add(TurbineRolePermissionPeer.ROLE_ID, (Object)role.getId());
            criteria.add(TurbineRolePermissionPeer.PERMISSION_ID, (Object)permission.getId());
            permissions = TurbineRolePermissionPeer.doSelect(criteria);
        }
        catch (Exception e) {
            String message = "Failed to check permission '" + permissionName + "'";
            logger.error(message, e);
            throw new PermissionException(message, e);
        }
        return permissions.size() > 0;
    }

    public Permission getPermission(String permissionName) throws JetspeedSecurityException {
        List permissions;
        try {
            Criteria criteria = new Criteria();
            criteria.add(TurbinePermissionPeer.PERMISSION_NAME, (Object)permissionName);
            permissions = TurbinePermissionPeer.doSelect(criteria);
        }
        catch (Exception e) {
            String message = "Failed to retrieve permission '" + permissionName + "'";
            logger.error(message, e);
            throw new PermissionException(message, e);
        }
        if (permissions.size() > 1) {
            throw new PermissionException("Multiple Permissions with same permissionname '" + permissionName + "'");
        }
        if (permissions.size() == 1) {
            TurbinePermission permission = (TurbinePermission)((Object)permissions.get(0));
            return permission;
        }
        throw new PermissionException("Unknown permission '" + permissionName + "'");
    }

    protected JetspeedRunData getRunData() {
        JetspeedRunData rundata = null;
        if (this.runDataService != null) {
            rundata = this.runDataService.getCurrentRunData();
        }
        return rundata;
    }

    protected boolean permissionExists(String permissionName) throws PermissionException {
        List permissions;
        Criteria criteria = new Criteria();
        criteria.add(TurbinePermissionPeer.PERMISSION_NAME, (Object)permissionName);
        try {
            permissions = TurbinePermissionPeer.doSelect(criteria);
        }
        catch (Exception e) {
            logger.error("Failed to check account's presence", e);
            throw new PermissionException("Failed to check account's presence", e);
        }
        return permissions.size() >= 1;
    }

    public synchronized void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        super.init(conf);
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("JetspeedSecurity");
        this.runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
        this.cascadeDelete = serviceConf.getBoolean(CASCADE_DELETE, true);
        this.cachingEnable = serviceConf.getBoolean(CACHING_ENABLE, this.cachingEnable);
        this.systemPermissions = serviceConf.getVector(CONFIG_SYSTEM_PERMISSIONS, new Vector());
        this.setInit(true);
    }
}

