/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.security.registry;

import java.util.Iterator;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.om.SecurityReference;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.om.registry.SecurityEntry;
import org.apache.jetspeed.om.security.GroupRole;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletController;
import org.apache.jetspeed.portal.PortletSet;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.security.JetspeedRoleManagement;
import org.apache.jetspeed.services.security.PortalAccessController;
import org.apache.jetspeed.services.security.PortalResource;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;

public class RegistryAccessController
extends TurbineBaseService
implements PortalAccessController {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(RegistryAccessController.class.getName());

    public boolean checkPermission(JetspeedUser user, Portlet portlet, String action) {
        return this.checkPermission(user, portlet, action, null);
    }

    public boolean checkPermission(JetspeedUser user, Portlet portlet, String action, String owner) {
        PortletController pc;
        PortletSet ps;
        SecurityReference securityRef = portlet.getPortletConfig().getSecurityRef();
        if (securityRef != null) {
            return this.checkPermission(user, securityRef, action, owner);
        }
        String portletName = portlet.getName();
        RegistryEntry registryEntry = null;
        if (!(portlet instanceof PortletSet)) {
            registryEntry = Registry.getEntry(Registry.PORTLET, portletName);
        }
        if (registryEntry == null && (ps = portlet.getPortletConfig().getPortletSet()) != null && (pc = ps.getController()) != null) {
            portletName = pc.getConfig().getName();
            registryEntry = Registry.getEntry(Registry.PORTLET_CONTROLLER, portletName);
        }
        if (registryEntry == null) {
            return true;
        }
        return this.checkPermission(user, registryEntry, action, owner);
    }

    public boolean checkPermission(JetspeedUser user, Entry entry, String action) {
        return this.checkPermission(user, entry, action, null);
    }

    public boolean checkPermission(JetspeedUser user, Entry entry, String action, String owner) {
        SecurityReference securityRef = entry.getSecurityRef();
        if (securityRef == null) {
            return this.checkPermission(user, Registry.getEntry(Registry.PORTLET, entry.getParent()), action, owner);
        }
        return this.checkPermission(user, securityRef, action, owner);
    }

    public boolean checkPermission(JetspeedUser user, PortalResource resource, String action) {
        switch (resource.getResourceType()) {
            case 200: {
                return this.checkPermission(user, resource.getEntry(), action, resource.getOwner());
            }
            case 100: {
                return this.checkPermission(user, resource.getPortlet(), action, resource.getOwner());
            }
            case 300: {
                return this.checkPermission(user, resource.getRegistryEntry(), action, resource.getOwner());
            }
            case 301: {
                return this.checkPermission(user, resource.getRegistryParameter(), action, resource.getOwner());
            }
        }
        logger.error("In " + this.getClass().getName() + ".checkPermission(user, resource, action) - Unkown resource = " + resource.getResourceType());
        return false;
    }

    private boolean checkPermission(JetspeedUser user, RegistryEntry regEntry, String action, String owner) {
        SecurityReference securityRef = regEntry.getSecurityRef();
        if (securityRef == null) {
            return true;
        }
        return this.checkPermission(user, securityRef, action, owner);
    }

    private boolean checkPermission(JetspeedUser user, SecurityReference securityRef, String action, String owner) {
        SecurityEntry securityEntry = (SecurityEntry)((Object)Registry.getEntry(Registry.SECURITY, securityRef.getParent()));
        if (securityEntry == null) {
            logger.warn("Security id " + securityRef.getParent() + " does not exist.  This was requested by the user " + user.getUserName());
            return false;
        }
        if (securityEntry.allowsUser(user.getUserName(), action, owner)) {
            return true;
        }
        try {
            Iterator roles = JetspeedRoleManagement.getRoles(user.getUserName());
            while (roles.hasNext()) {
                String rolename;
                GroupRole grouprole = (GroupRole)roles.next();
                String groupname = grouprole.getGroup().getName();
                if (!securityEntry.allowsGroupRole(groupname, rolename = grouprole.getRole().getName(), action)) continue;
                return true;
            }
        }
        catch (Exception e) {
            logger.error("Exception", e);
            return false;
        }
        return false;
    }

    public synchronized void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        super.init(conf);
        this.setInit(true);
    }
}

