/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.security.nosecurity;

import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.rundata.JetspeedRunDataService;
import org.apache.jetspeed.services.security.LoginException;
import org.apache.jetspeed.services.security.PortalAuthentication;
import org.apache.jetspeed.services.security.nosecurity.FakeJetspeedUser;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;

public class NoAuthentication
extends TurbineBaseService
implements PortalAuthentication {
    private JetspeedRunDataService m_runDataService = null;

    public JetspeedUser login(String username, String password) throws LoginException {
        FakeJetspeedUser user = new FakeJetspeedUser(username, true);
        this.putUserIntoContext(user);
        return user;
    }

    public JetspeedUser getAnonymousUser() throws LoginException {
        FakeJetspeedUser user = new FakeJetspeedUser(JetspeedSecurity.getAnonymousUserName(), false);
        this.putUserIntoContext(user);
        return user;
    }

    public void logout() throws LoginException {
        this.getAnonymousUser();
    }

    public synchronized void init() throws InitializationException {
        super.init();
        this.m_runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
    }

    protected JetspeedRunData getRunData() {
        JetspeedRunData rundata = null;
        if (this.m_runDataService != null) {
            rundata = this.m_runDataService.getCurrentRunData();
        }
        return rundata;
    }

    protected JetspeedUser getUserFromContext() {
        JetspeedRunData rundata = this.getRunData();
        JetspeedUser user = null;
        if (rundata != null) {
            user = (JetspeedUser)rundata.getUser();
        }
        return user;
    }

    protected JetspeedRunData putUserIntoContext(JetspeedUser user) {
        JetspeedRunData rundata = this.getRunData();
        if (rundata != null) {
            rundata.setUser(user);
            rundata.save();
        }
        return rundata;
    }
}

