/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.security.ldap;

import java.security.Principal;
import java.util.Iterator;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.UserNamePrincipal;
import org.apache.jetspeed.om.security.ldap.LDAPUser;
import org.apache.jetspeed.services.JetspeedLDAP;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.PsmlManager;
import org.apache.jetspeed.services.ldap.LDAPURL;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.rundata.JetspeedRunDataService;
import org.apache.jetspeed.services.security.CredentialsManagement;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.services.security.NotUniqueUserException;
import org.apache.jetspeed.services.security.UnknownUserException;
import org.apache.jetspeed.services.security.UserException;
import org.apache.jetspeed.services.security.UserManagement;
import org.apache.jetspeed.services.security.ldap.UnixCrypt;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;
import org.apache.turbine.util.RunData;

public class LDAPUserManagement
extends TurbineBaseService
implements UserManagement,
CredentialsManagement {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(LDAPUserManagement.class.getName());
    private static final String CONFIG_SECURE_PASSWORDS_KEY = "secure.passwords";
    private static final String CONFIG_SECURE_PASSWORDS_ALGORITHM = "secure.passwords.algorithm";
    private static final String CONFIG_SECURE_PASSWORDS_SUFFIX = "secure.passwords.suffix";
    private static final String CONFIG_NEWUSER_ROLES = "newuser.roles";
    private static final String[] DEFAULT_CONFIG_NEWUSER_ROLES = new String[]{"user"};
    private static final String[] ATTRS = new String[]{"ou", "userPassword", "uid", "mail", "sn", "givenName", "uidNumber", "name", "objectdata", "objectClass", "usergrouprole", "lastlogindate", "lastmodifieddate", "creationdate", "confirm", "disabled"};
    protected static boolean securePasswords = false;
    protected static String passwordsAlgorithm = "crypt";
    protected static String passwordsSuffix = "{crypt}";
    protected JetspeedRunDataService runDataService = null;
    protected String[] roles = null;

    public JetspeedUser getUser(Principal principal) throws JetspeedSecurityException {
        Vector userurls;
        LDAPUser user = null;
        try {
            userurls = JetspeedLDAP.search(JetspeedLDAP.buildURL("ou=users"), "(&(uid=" + principal.getName() + ")(objectclass=jetspeeduser))", ATTRS, true);
        }
        catch (Exception e) {
            logger.error("Failed to retrieve user '" + principal.getName() + "'", e);
            throw new UserException("Failed to retrieve user '" + principal.getName() + "'", e);
        }
        if (userurls != null) {
            if (userurls.size() == 1) {
                user = new LDAPUser((LDAPURL)((Vector)userurls.elementAt(0)).firstElement());
                return user;
            }
            if (userurls.size() > 1) {
                throw new UserException("Multiple Users with same username '" + principal.getName() + "'");
            }
            throw new UnknownUserException("Unknown user '" + principal.getName() + "'");
        }
        throw new UnknownUserException("Unknown user '" + principal.getName() + "'");
    }

    public JetspeedUser getUser(RunData rundata, Principal principal) throws JetspeedSecurityException {
        return null;
    }

    public Iterator getUsers() throws JetspeedSecurityException {
        String filter = "(objectclass=jetspeeduser)";
        return this.getUsersUsingLDAPSpecificFilter(filter, null);
    }

    public Iterator getUsers(String filter) throws JetspeedSecurityException {
        return this.getUsersUsingLDAPSpecificFilter(filter, null);
    }

    protected Iterator getUsersUsingLDAPSpecificFilter(String filter, String[] attributesToFetch) throws JetspeedSecurityException {
        String baseDN = "ou=users";
        NamingEnumeration userEnum = null;
        Vector<LDAPUser> resultList = new Vector<LDAPUser>(1024);
        try {
            LDAPURL url = JetspeedLDAP.buildURL(baseDN);
            DirContext ctx = JetspeedLDAP.getService().connect(url);
            String string = url.getDN();
            JetspeedLDAP.getService();
            userEnum = JetspeedLDAP.search(ctx, string, filter, attributesToFetch, 2);
            while (userEnum.hasMoreElements()) {
                LDAPUser user = this.buildUser(((SearchResult)userEnum.nextElement()).getAttributes());
                resultList.add(user);
            }
            JetspeedLDAP.getService().checkAndCloseContext(ctx);
        }
        catch (Exception e) {
            logger.error("Failed to retrieve user with filter:" + filter, e);
            throw new UserException("Failed to retrieve user with filter:" + filter, e);
        }
        return resultList.iterator();
    }

    protected LDAPUser buildUser(Attributes attributes) {
        return new LDAPUser(attributes);
    }

    public void saveUser(JetspeedUser user) throws JetspeedSecurityException {
        if (!this.accountExists(user, true)) {
            throw new UnknownUserException("Cannot save user '" + user.getUserName() + "', User doesn't exist");
        }
        try {
            ((LDAPUser)user).update(false);
        }
        catch (Exception e) {
            logger.error("Failed to save user object ", e);
            throw new UserException("Failed to save user object ", e);
        }
    }

    public void addUser(JetspeedUser user) throws JetspeedSecurityException {
        if (this.accountExists(user)) {
            throw new NotUniqueUserException("The account '" + user.getUserName() + "' already exists");
        }
        String initialPassword = user.getPassword();
        String encrypted = JetspeedSecurity.encryptPassword(initialPassword);
        user.setPassword(encrypted);
        ((LDAPUser)user).update(true);
        this.addDefaultPSML(user);
    }

    protected void addDefaultPSML(JetspeedUser user) throws JetspeedSecurityException {
        for (int ix = 0; ix < this.roles.length; ++ix) {
            try {
                JetspeedSecurity.grantRole(user.getUserName(), JetspeedSecurity.getRole(this.roles[ix]).getName());
                continue;
            }
            catch (Exception e) {
                logger.error("Could not grant role: " + this.roles[ix] + " to user " + user.getUserName(), e);
            }
        }
        try {
            JetspeedRunData rundata = this.getRunData();
            if (rundata != null) {
                Profile profile = Profiler.createProfile();
                profile.setUser(user);
                profile.setMediaType("html");
                Profiler.createProfile((RunData)this.getRunData(), profile);
            }
        }
        catch (Exception e) {
            logger.error("Failed to create profile for new user ", e);
            this.removeUser(new UserNamePrincipal(user.getUserName()));
            throw new UserException("Failed to create profile for new user ", e);
        }
    }

    public void removeUser(Principal principal) throws JetspeedSecurityException {
        LDAPUser user = (LDAPUser)this.getUser(principal);
        try {
            JetspeedLDAP.deleteEntry(user.getldapurl());
            PsmlManager.removeUserDocuments(user);
        }
        catch (Exception e) {
            logger.error("Failed to remove account '" + user.getUserName() + "'", e);
            throw new UserException("Failed to remove account '" + user.getUserName() + "'", e);
        }
    }

    public void changePassword(JetspeedUser user, String oldPassword, String newPassword) throws JetspeedSecurityException {
        oldPassword = JetspeedSecurity.convertPassword(oldPassword);
        newPassword = JetspeedSecurity.convertPassword(newPassword);
        if (!this.accountExists(user)) {
            throw new UnknownUserException("The account '" + user.getUserName() + "' does not exist");
        }
        if (!LDAPUserManagement.passwordsMatch(user, oldPassword)) {
            throw new UserException("The supplied old password for '" + user.getUserName() + "' was incorrect");
        }
        String encrypted = JetspeedSecurity.encryptPassword(newPassword);
        user.setPassword(encrypted);
        this.saveUser(user);
    }

    public void forcePassword(JetspeedUser user, String password) throws JetspeedSecurityException {
        if (!this.accountExists(user)) {
            throw new UnknownUserException("The account '" + user.getUserName() + "' does not exist");
        }
        String encrypted = JetspeedSecurity.encryptPassword(password);
        user.setPassword(encrypted);
        this.saveUser(user);
    }

    public String encryptPassword(String password) throws JetspeedSecurityException {
        if (!securePasswords) {
            return password;
        }
        if (password == null) {
            return null;
        }
        if (password.startsWith(passwordsSuffix)) {
            return password;
        }
        return passwordsSuffix + UnixCrypt.crypt(password);
    }

    public static boolean passwordsMatch(JetspeedUser user, String suppliedPassword) {
        if (!securePasswords) {
            return user.getPassword().equals(suppliedPassword);
        }
        return UnixCrypt.matches(user.getPassword().substring(passwordsSuffix.length()), suppliedPassword);
    }

    public synchronized void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        super.init(conf);
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("JetspeedSecurity");
        securePasswords = serviceConf.getBoolean(CONFIG_SECURE_PASSWORDS_KEY, securePasswords);
        passwordsAlgorithm = serviceConf.getString(CONFIG_SECURE_PASSWORDS_ALGORITHM, passwordsAlgorithm);
        passwordsSuffix = serviceConf.getString(CONFIG_SECURE_PASSWORDS_SUFFIX, passwordsSuffix);
        try {
            this.roles = serviceConf.getStringArray(CONFIG_NEWUSER_ROLES);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == this.roles || this.roles.length == 0) {
            this.roles = DEFAULT_CONFIG_NEWUSER_ROLES;
        }
        this.runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
        this.setInit(true);
    }

    protected boolean accountExists(JetspeedUser user) throws UserException {
        return this.accountExists(user, false);
    }

    protected boolean accountExists(JetspeedUser user, boolean checkUniqueId) throws UserException {
        UserNamePrincipal principal = new UserNamePrincipal(user.getUserName());
        try {
            this.getUser(principal);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected JetspeedRunData getRunData() {
        JetspeedRunData rundata = null;
        if (this.runDataService != null) {
            rundata = this.runDataService.getCurrentRunData();
        }
        return rundata;
    }
}

