/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.security.ldap;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileException;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.om.security.UserNamePrincipal;
import org.apache.jetspeed.om.security.ldap.LDAPRole;
import org.apache.jetspeed.om.security.ldap.LDAPUser;
import org.apache.jetspeed.services.JetspeedLDAP;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.PsmlManager;
import org.apache.jetspeed.services.ldap.LDAPURL;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.rundata.JetspeedRunDataService;
import org.apache.jetspeed.services.security.CachedAcl;
import org.apache.jetspeed.services.security.JetspeedSecurityCache;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.services.security.RoleException;
import org.apache.jetspeed.services.security.RoleManagement;
import org.apache.jetspeed.services.security.UnknownUserException;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;
import org.apache.turbine.util.RunData;

public class LDAPRoleManagement
extends TurbineBaseService
implements RoleManagement {
    private static final String CASCADE_DELETE = "programmatic.cascade.delete";
    private static final String CACHING_ENABLE = "caching.enable";
    private static final boolean DEFAULT_CASCADE_DELETE = true;
    private static final boolean DEFAULT_CACHING_ENABLE = true;
    private static final String[] ATTRS = new String[]{"ou", "uid", "rolename", "rolepermissions"};
    private JetspeedRunDataService runDataService = null;
    private boolean cascadeDelete = false;
    private boolean cachingEnable = false;

    public Iterator getRoles(String username) throws JetspeedSecurityException {
        LDAPUser user;
        try {
            Iterator result;
            if (this.cachingEnable && null != (result = JetspeedSecurityCache.getRoles(username))) {
                return result;
            }
            user = (LDAPUser)JetspeedSecurity.getUser(new UserNamePrincipal(username));
        }
        catch (JetspeedSecurityException e) {
            throw new RoleException("Failed to Retrieve User: ", (Throwable)((Object)e));
        }
        Vector<LDAPRole> roles = new Vector<LDAPRole>();
        try {
            Enumeration enu = user.getGroupRoles().elements();
            while (enu.hasMoreElements()) {
                StringTokenizer st = new StringTokenizer((String)enu.nextElement(), ",");
                st.nextToken();
                roles.add(new LDAPRole(st.nextToken(), false));
            }
        }
        catch (Exception e) {
            throw new RoleException("Failed to retrieve groups ", e);
        }
        return roles.iterator();
    }

    public Iterator getRoles() throws JetspeedSecurityException {
        Vector<LDAPRole> roles;
        block4: {
            roles = new Vector<LDAPRole>();
            try {
                Vector roleurls = JetspeedLDAP.search(JetspeedLDAP.buildURL("ou=roles"), "(objectclass=jetspeedrole)", ATTRS, true);
                if (roleurls.size() > 0) {
                    Enumeration enu = roleurls.elements();
                    while (enu.hasMoreElements()) {
                        roles.add(new LDAPRole((LDAPURL)((Vector)enu.nextElement()).firstElement()));
                    }
                    break block4;
                }
                throw new UnknownUserException("No role ");
            }
            catch (Exception e) {
                throw new RoleException("Failed to retrieve roles ", e);
            }
        }
        return roles.iterator();
    }

    public void addRole(Role role) throws JetspeedSecurityException {
        LDAPRole ldapRole = null;
        if (this.roleExists(role.getName())) {
            throw new RoleException("The role '" + role.getName() + "' already exists");
        }
        try {
            ldapRole = new LDAPRole(role.getName(), true);
            ldapRole.update(true);
        }
        catch (Exception e) {
            throw new RoleException("Failed to create role '" + role.getName() + "'", e);
        }
        if (this.cachingEnable) {
            JetspeedSecurityCache.addRole(ldapRole);
        }
        try {
            this.addDefaultRolePSML(ldapRole);
        }
        catch (Exception e) {
            try {
                this.removeRole(ldapRole.getName());
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw new RoleException("failed to add default PSML for Role resource", e);
        }
    }

    protected void addDefaultRolePSML(Role role) throws RoleException {
        try {
            JetspeedRunDataService runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
            JetspeedRunData rundata = runDataService.getCurrentRunData();
            Profile profile = Profiler.createProfile();
            profile.setRole(role);
            profile.setMediaType("html");
            Profiler.createProfile((RunData)rundata, profile);
        }
        catch (ProfileException e) {
            try {
                this.removeRole(role.getName());
            }
            catch (Exception e2) {
                e.printStackTrace();
            }
            throw new RoleException("Failed to create Role PSML", e);
        }
    }

    public void saveRole(Role role) throws JetspeedSecurityException {
        if (!this.roleExists(role.getName())) {
            throw new RoleException("The role '" + role.getName() + "' doesn't exists");
        }
    }

    public void removeRole(String roleName) throws JetspeedSecurityException {
        try {
            LDAPRole role = new LDAPRole(roleName, false);
            JetspeedLDAP.deleteEntry(role.getldapurl());
            PsmlManager.removeRoleDocuments(role);
            if (this.cascadeDelete) {
                // empty if block
            }
            if (this.cachingEnable) {
                JetspeedSecurityCache.removeAllRoles(roleName);
            }
        }
        catch (Exception e) {
            throw new RoleException("Failed to remove group '" + roleName + "'", e);
        }
    }

    public void grantRole(String username, String roleName) throws JetspeedSecurityException {
        this.grantRole(username, roleName, "Jetspeed");
    }

    public void grantRole(String username, String roleName, String groupName) throws JetspeedSecurityException {
        LDAPRole role;
        LDAPUser user;
        try {
            user = (LDAPUser)JetspeedSecurity.getUser(new UserNamePrincipal(username));
            role = (LDAPRole)JetspeedSecurity.getRole(roleName);
        }
        catch (JetspeedSecurityException e) {
            throw new RoleException("Failed to Retrieve User or Role: ", (Throwable)((Object)e));
        }
        try {
            user.addGroupRole(groupName, roleName);
            user.update(false);
            if (this.cachingEnable) {
                JetspeedSecurityCache.addRole(username, role);
            }
        }
        catch (Exception e) {
            throw new RoleException("Failed to add role info ", e);
        }
    }

    public void revokeRole(String username, String rolename) throws JetspeedSecurityException {
        this.revokeRole(username, rolename, "Jetspeed");
    }

    public void revokeRole(String username, String rolename, String groupname) throws JetspeedSecurityException {
        LDAPUser user;
        try {
            user = (LDAPUser)JetspeedSecurity.getUser(new UserNamePrincipal(username));
        }
        catch (JetspeedSecurityException e) {
            throw new RoleException("Failed to Retrieve User: ", (Throwable)((Object)e));
        }
        try {
            user.removeGroupRole(groupname, rolename);
            user.update(false);
            if (this.cachingEnable) {
                JetspeedSecurityCache.removeRole(username, rolename, groupname);
            }
        }
        catch (Exception e) {
            throw new RoleException("Failed to add role info ", e);
        }
    }

    public boolean hasRole(String username, String roleName) throws JetspeedSecurityException {
        return this.hasRole(username, roleName, "Jetspeed");
    }

    public boolean hasRole(String username, String roleName, String groupName) throws JetspeedSecurityException {
        LDAPUser user;
        try {
            CachedAcl acl;
            if (this.cachingEnable && null != (acl = JetspeedSecurityCache.getAcl(username))) {
                return acl.hasRole(roleName, groupName);
            }
            user = (LDAPUser)JetspeedSecurity.getUser(new UserNamePrincipal(username));
        }
        catch (JetspeedSecurityException e) {
            throw new RoleException("Failed to Retrieve User: ", (Throwable)((Object)e));
        }
        try {
            Enumeration enu = user.getGroupRoles().elements();
            while (enu.hasMoreElements()) {
                StringTokenizer st = new StringTokenizer((String)enu.nextElement(), ",");
                String gn = st.nextToken();
                String rn = st.nextToken();
                if (!rn.equalsIgnoreCase(roleName) || !gn.equalsIgnoreCase(groupName)) continue;
                return true;
            }
        }
        catch (Exception e) {
            throw new RoleException("Failed to retrieve roles ", e);
        }
        return false;
    }

    public Role getRole(String roleName) throws JetspeedSecurityException {
        try {
            Vector roleurls = JetspeedLDAP.search(JetspeedLDAP.buildURL("ou=roles"), "(&(uid=" + roleName + ")(objectclass=jetspeedrole))", ATTRS, true);
            if (roleurls.size() == 1) {
                return new LDAPRole((LDAPURL)((Vector)roleurls.elementAt(0)).firstElement());
            }
            if (roleurls.size() > 1) {
                throw new RoleException("Multiple roles with same name");
            }
        }
        catch (Exception e) {
            throw new RoleException("Failed to retrieve roles ", e);
        }
        throw new RoleException("Unknown role '" + roleName + "'");
    }

    protected JetspeedRunData getRunData() {
        JetspeedRunData rundata = null;
        if (this.runDataService != null) {
            rundata = this.runDataService.getCurrentRunData();
        }
        return rundata;
    }

    protected boolean roleExists(String roleName) throws RoleException {
        try {
            Vector roleurls = JetspeedLDAP.search(JetspeedLDAP.buildURL("ou=roles"), "(&(uid=" + roleName + ")(objectclass=jetspeedrole))", ATTRS, true);
            if (roleurls.size() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            throw new RoleException("Failed to retrieve roles ", e);
        }
        return false;
    }

    public synchronized void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        super.init(conf);
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("JetspeedSecurity");
        this.runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
        this.cascadeDelete = serviceConf.getBoolean(CASCADE_DELETE, true);
        this.cachingEnable = serviceConf.getBoolean(CACHING_ENABLE, true);
        this.setInit(true);
    }
}

