/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.security.ldap;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.om.security.Permission;
import org.apache.jetspeed.om.security.ldap.LDAPPermission;
import org.apache.jetspeed.om.security.ldap.LDAPRole;
import org.apache.jetspeed.services.JetspeedLDAP;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.ldap.LDAPURL;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.rundata.JetspeedRunDataService;
import org.apache.jetspeed.services.security.JetspeedSecurityCache;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.services.security.PermissionException;
import org.apache.jetspeed.services.security.PermissionManagement;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;

public class LDAPPermissionManagement
extends TurbineBaseService
implements PermissionManagement {
    private static final String CASCADE_DELETE = "programmatic.cascade.delete";
    private static final String CACHING_ENABLE = "caching.enable";
    private static final boolean DEFAULT_CASCADE_DELETE = true;
    private static final boolean DEFAULT_CACHING_ENABLE = true;
    private static final String[] ATTRS = new String[]{"ou", "uid", "permissionname"};
    private JetspeedRunDataService runDataService = null;
    private boolean cascadeDelete = false;
    private boolean cachingEnable = false;

    public Iterator getPermissions(String roleName) throws JetspeedSecurityException {
        Vector<LDAPPermission> perms = new Vector<LDAPPermission>();
        try {
            Iterator iterator;
            if (this.cachingEnable && (iterator = JetspeedSecurityCache.getPermissions(roleName)) != null) {
                return iterator;
            }
            Vector userurls = JetspeedLDAP.search(JetspeedLDAP.buildURL("ou=roles"), "(&(uid=" + roleName + ")(objectclass=jetspeedrole))", ATTRS, true);
            if (userurls.size() > 0) {
                LDAPRole role = new LDAPRole((LDAPURL)((Vector)userurls.elementAt(0)).firstElement());
                Enumeration enu = role.getRolePermissions().elements();
                while (enu.hasMoreElements()) {
                    LDAPPermission permission = new LDAPPermission((String)enu.nextElement(), false);
                    perms.add(permission);
                }
            }
        }
        catch (Exception e) {
            throw new PermissionException("Failed to retrieve permissions ", e);
        }
        return perms.iterator();
    }

    public Iterator getPermissions() throws JetspeedSecurityException {
        Vector<LDAPPermission> permissions;
        block4: {
            permissions = new Vector<LDAPPermission>();
            try {
                Vector permissionurls = JetspeedLDAP.search(JetspeedLDAP.buildURL("ou=permissions"), "(objectclass=jetspeedpermission)", ATTRS, true);
                if (permissionurls.size() > 0) {
                    Enumeration enu = permissionurls.elements();
                    while (enu.hasMoreElements()) {
                        permissions.add(new LDAPPermission((LDAPURL)((Vector)enu.nextElement()).firstElement()));
                    }
                    break block4;
                }
                throw new PermissionException("No permission ");
            }
            catch (Exception e) {
                throw new PermissionException("Failed to retrieve permissions ", e);
            }
        }
        return permissions.iterator();
    }

    public void addPermission(Permission permission) throws JetspeedSecurityException {
        if (this.permissionExists(permission.getName())) {
            throw new PermissionException("The permission '" + permission.getName() + "' already exists");
        }
        try {
            new LDAPPermission(permission.getName(), true).update(true);
        }
        catch (Exception e) {
            throw new PermissionException("Failed to create permission '" + permission.getName() + "'", e);
        }
    }

    public void savePermission(Permission permission) throws JetspeedSecurityException {
    }

    public void removePermission(String permissionName) throws JetspeedSecurityException {
        try {
            LDAPPermission permission = new LDAPPermission(permissionName, false);
            JetspeedLDAP.deleteEntry(permission.getldapurl());
            if (this.cascadeDelete) {
                // empty if block
            }
            if (this.cachingEnable) {
                JetspeedSecurityCache.removeAllPermissions(permissionName);
            }
        }
        catch (Exception e) {
            throw new PermissionException("Failed to remove permission '" + permissionName + "'", e);
        }
    }

    public void grantPermission(String roleName, String permissionName) throws JetspeedSecurityException {
        try {
            LDAPRole role = (LDAPRole)JetspeedSecurity.getRole(roleName);
            LDAPPermission permission = (LDAPPermission)JetspeedSecurity.getPermission(permissionName);
            role.addRolePermissions(permissionName);
            role.update(false);
            if (this.cachingEnable) {
                JetspeedSecurityCache.addPermission(roleName, permission);
            }
        }
        catch (Exception e) {
            throw new PermissionException("Grant permission '" + permissionName + "' to role '" + roleName + "' failed: ", e);
        }
    }

    public void revokePermission(String roleName, String permissionName) throws JetspeedSecurityException {
        try {
            Vector userurls = JetspeedLDAP.search(JetspeedLDAP.buildURL("ou=roles"), "(&(uid=" + roleName + ")(objectclass=jetspeedrole))", ATTRS, true);
            if (userurls.size() == 0) {
                throw new PermissionException("Role '" + roleName + "' does not exist!");
            }
            LDAPRole role = new LDAPRole((LDAPURL)((Vector)userurls.elementAt(0)).firstElement());
            role.getRolePermissions().remove(permissionName);
            role.update(false);
            if (this.cachingEnable) {
                JetspeedSecurityCache.removePermission(roleName, permissionName);
            }
        }
        catch (Exception e) {
            throw new PermissionException("Revoke permission '" + permissionName + "' to role '" + roleName + "' failed: ", e);
        }
    }

    public boolean hasPermission(String roleName, String permissionName) throws JetspeedSecurityException {
        try {
            if (this.cachingEnable) {
                return JetspeedSecurityCache.hasPermission(roleName, permissionName);
            }
            Vector userurls = JetspeedLDAP.search(JetspeedLDAP.buildURL("ou=roles"), "(&(uid=" + roleName + ")(objectclass=jetspeedrole))", ATTRS, true);
            if (userurls.size() > 0) {
                LDAPRole role = new LDAPRole((LDAPURL)((Vector)userurls.elementAt(0)).firstElement());
                return role.permissionExists(permissionName);
            }
        }
        catch (Exception e) {
            throw new PermissionException("Grant permission '" + permissionName + "' to role '" + roleName + "' failed: ", e);
        }
        return false;
    }

    public Permission getPermission(String permissionName) throws JetspeedSecurityException {
        if (this.permissionExists(permissionName)) {
            return new LDAPPermission(permissionName, false);
        }
        throw new PermissionException("Unknown permission '" + permissionName + "'");
    }

    protected JetspeedRunData getRunData() {
        JetspeedRunData rundata = null;
        if (this.runDataService != null) {
            rundata = this.runDataService.getCurrentRunData();
        }
        return rundata;
    }

    protected boolean permissionExists(String permissionName) throws PermissionException {
        try {
            Vector permissionurls = JetspeedLDAP.search(JetspeedLDAP.buildURL("ou=permissions"), "(&(uid=" + permissionName + ")(objectclass=jetspeedpermission))", ATTRS, true);
            return permissionurls.size() > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PermissionException("Failed to retrieve permission ", e);
        }
    }

    public synchronized void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        super.init(conf);
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("JetspeedSecurity");
        this.runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
        this.cascadeDelete = serviceConf.getBoolean(CASCADE_DELETE, true);
        this.cachingEnable = serviceConf.getBoolean(CACHING_ENABLE, this.cachingEnable);
        this.setInit(true);
    }
}

