/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.security.ldap;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileException;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.om.security.UserNamePrincipal;
import org.apache.jetspeed.om.security.ldap.LDAPGroup;
import org.apache.jetspeed.om.security.ldap.LDAPRole;
import org.apache.jetspeed.om.security.ldap.LDAPUser;
import org.apache.jetspeed.services.JetspeedLDAP;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.PsmlManager;
import org.apache.jetspeed.services.ldap.LDAPURL;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.rundata.JetspeedRunDataService;
import org.apache.jetspeed.services.security.GroupException;
import org.apache.jetspeed.services.security.GroupManagement;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.services.security.UnknownUserException;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;
import org.apache.turbine.util.RunData;

public class LDAPGroupManagement
extends TurbineBaseService
implements GroupManagement {
    private static final String CONFIG_DEFAULT_ROLE = "role.default";
    private static final String CASCADE_DELETE = "programmatic.cascade.delete";
    private static final String DEFAULT_DEFAULT_ROLE = "user";
    private static final boolean DEFAULT_CASCADE_DELETE = true;
    private static final String[] ATTRS = new String[]{"ou", "uid", "groupname"};
    private JetspeedRunDataService runDataService = null;
    private boolean cascadeDelete = false;
    private String defaultRole = null;

    public Iterator getGroups(String username) throws JetspeedSecurityException {
        LDAPUser user;
        Vector<LDAPGroup> groups = new Vector<LDAPGroup>();
        try {
            user = (LDAPUser)JetspeedSecurity.getUser(new UserNamePrincipal(username));
        }
        catch (JetspeedSecurityException e) {
            throw new GroupException("Failed to Retrieve User: ", (Throwable)((Object)e));
        }
        try {
            Enumeration enu = user.getGroupRoles().elements();
            while (enu.hasMoreElements()) {
                StringTokenizer st = new StringTokenizer((String)enu.nextElement(), ",");
                groups.add(new LDAPGroup(st.nextToken(), false));
            }
        }
        catch (Exception e) {
            throw new GroupException("Failed to retrieve groups ", e);
        }
        return groups.iterator();
    }

    public Iterator getGroups() throws JetspeedSecurityException {
        Vector<LDAPGroup> groups;
        block4: {
            groups = new Vector<LDAPGroup>();
            try {
                Vector groupurls = JetspeedLDAP.search(JetspeedLDAP.buildURL("ou=groups"), "(objectclass=jetspeedgroup)", ATTRS, true);
                if (groupurls.size() > 0) {
                    Enumeration enu = groupurls.elements();
                    while (enu.hasMoreElements()) {
                        groups.add(new LDAPGroup((LDAPURL)((Vector)enu.nextElement()).firstElement()));
                    }
                    break block4;
                }
                throw new UnknownUserException("No groups");
            }
            catch (Exception e) {
                throw new GroupException("Failed to retrieve groups ", e);
            }
        }
        return groups.iterator();
    }

    public void addGroup(Group group) throws JetspeedSecurityException {
        LDAPGroup ldapGroup = null;
        if (this.groupExists(group.getName())) {
            throw new GroupException("The group '" + group.getName() + "' already exists");
        }
        try {
            ldapGroup = new LDAPGroup(group.getName(), true);
            ldapGroup.update(true);
        }
        catch (Exception e) {
            throw new GroupException("Failed to create group '" + group.getName() + "'", e);
        }
        try {
            this.addDefaultGroupPSML(ldapGroup);
        }
        catch (Exception e) {
            try {
                this.removeGroup(ldapGroup.getName());
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw new GroupException("failed to add default PSML for Group resource", e);
        }
    }

    protected void addDefaultGroupPSML(Group group) throws GroupException {
        try {
            JetspeedRunDataService runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
            JetspeedRunData rundata = runDataService.getCurrentRunData();
            Profile profile = Profiler.createProfile();
            profile.setGroup(group);
            profile.setMediaType("html");
            Profiler.createProfile((RunData)rundata, profile);
        }
        catch (ProfileException e) {
            try {
                this.removeGroup(group.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new GroupException("Failed to create Group PSML", e);
        }
    }

    public void saveGroup(Group group) throws JetspeedSecurityException {
        if (!this.groupExists(group.getName())) {
            throw new GroupException("The group '" + group.getName() + "' doesn't exists");
        }
    }

    public void removeGroup(String groupname) throws JetspeedSecurityException {
        try {
            LDAPGroup group = new LDAPGroup(groupname, false);
            JetspeedLDAP.deleteEntry(group.getldapurl());
            if (this.cascadeDelete) {
                // empty if block
            }
            PsmlManager.removeGroupDocuments(group);
        }
        catch (Exception e) {
            throw new GroupException("Failed to remove group '" + groupname + "'", e);
        }
    }

    public void joinGroup(String username, String groupname) throws JetspeedSecurityException {
        LDAPUser user;
        try {
            user = (LDAPUser)JetspeedSecurity.getUser(new UserNamePrincipal(username));
        }
        catch (JetspeedSecurityException e) {
            throw new GroupException("Failed to Retrieve User: ", (Throwable)((Object)e));
        }
        try {
            user.addGroupRole(groupname, this.defaultRole);
            user.update(false);
        }
        catch (Exception e) {
            throw new GroupException("Failed to add group info ", e);
        }
    }

    public void joinGroup(String username, String groupname, String rolename) throws JetspeedSecurityException {
        LDAPUser user;
        try {
            user = (LDAPUser)JetspeedSecurity.getUser(new UserNamePrincipal(username));
            LDAPRole role = (LDAPRole)JetspeedSecurity.getRole(rolename);
        }
        catch (JetspeedSecurityException e) {
            throw new GroupException("Failed to Retrieve User: ", (Throwable)((Object)e));
        }
        try {
            user.addGroupRole(groupname, rolename);
            user.update(false);
        }
        catch (Exception e) {
            throw new GroupException("Failed to add group info ", e);
        }
    }

    public void unjoinGroup(String username, String groupName) throws JetspeedSecurityException {
        LDAPUser user;
        try {
            user = (LDAPUser)JetspeedSecurity.getUser(new UserNamePrincipal(username));
        }
        catch (JetspeedSecurityException e) {
            throw new GroupException("Failed to Retrieve User: ", (Throwable)((Object)e));
        }
        try {
            user.removeGroup(groupName);
            user.update(false);
        }
        catch (Exception e) {
            throw new GroupException("Failed to add group info ", e);
        }
    }

    public void unjoinGroup(String username, String groupName, String rolename) throws JetspeedSecurityException {
        LDAPUser user;
        try {
            user = (LDAPUser)JetspeedSecurity.getUser(new UserNamePrincipal(username));
        }
        catch (JetspeedSecurityException e) {
            throw new GroupException("Failed to Retrieve User: ", (Throwable)((Object)e));
        }
        try {
            user.removeGroup(groupName);
            user.update(false);
        }
        catch (Exception e) {
            throw new GroupException("Failed to add group info ", e);
        }
    }

    public boolean inGroup(String username, String groupname) throws JetspeedSecurityException {
        LDAPUser user;
        try {
            user = (LDAPUser)JetspeedSecurity.getUser(new UserNamePrincipal(username));
        }
        catch (JetspeedSecurityException e) {
            throw new GroupException("Failed to Retrieve User: ", (Throwable)((Object)e));
        }
        try {
            Enumeration enu = user.getGroupRoles().elements();
            while (enu.hasMoreElements()) {
                StringTokenizer st = new StringTokenizer((String)enu.nextElement(), ",");
                if (!st.nextToken().equalsIgnoreCase(groupname)) continue;
                return true;
            }
        }
        catch (Exception e) {
            throw new GroupException("Failed to retrieve groups ", e);
        }
        return false;
    }

    public Group getGroup(String groupname) throws JetspeedSecurityException {
        try {
            Vector groupurls = JetspeedLDAP.search(JetspeedLDAP.buildURL("ou=groups"), "(&(uid=" + groupname + ")(objectclass=jetspeedgroup))", ATTRS, true);
            if (groupurls.size() == 1) {
                return new LDAPGroup((LDAPURL)((Vector)groupurls.elementAt(0)).firstElement());
            }
            if (groupurls.size() > 1) {
                throw new GroupException("Multiple groups with same name");
            }
            throw new GroupException("Unknown group '" + groupname + "'");
        }
        catch (Exception e) {
            throw new GroupException("Failed to retrieve groups ", e);
        }
    }

    public HashMap getTurbineGroupRole(String username) throws JetspeedSecurityException {
        HashMap h = new HashMap();
        return h;
    }

    protected JetspeedRunData getRunData() {
        JetspeedRunData rundata = null;
        if (this.runDataService != null) {
            rundata = this.runDataService.getCurrentRunData();
        }
        return rundata;
    }

    protected boolean groupExists(String groupName) throws GroupException {
        try {
            Vector groupurls = JetspeedLDAP.search(JetspeedLDAP.buildURL("ou=groups"), "(&(uid=" + groupName + ")(objectclass=jetspeedgroup))", ATTRS, true);
            return groupurls.size() > 0;
        }
        catch (Exception e) {
            throw new GroupException("Failed to retrieve groups ", e);
        }
    }

    public synchronized void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        super.init(conf);
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("JetspeedSecurity");
        this.runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
        this.defaultRole = serviceConf.getString(CONFIG_DEFAULT_ROLE, DEFAULT_DEFAULT_ROLE);
        this.cascadeDelete = serviceConf.getBoolean(CASCADE_DELETE, true);
        this.setInit(true);
    }
}

