/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.security.ldap;

import javax.naming.directory.BasicAttributes;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.UserNamePrincipal;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.JetspeedUserManagement;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.rundata.JetspeedRunDataService;
import org.apache.jetspeed.services.security.FailedLoginException;
import org.apache.jetspeed.services.security.JetspeedSecurityCache;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.services.security.LoginException;
import org.apache.jetspeed.services.security.PortalAuthentication;
import org.apache.jetspeed.services.security.UnknownUserException;
import org.apache.jetspeed.services.security.ldap.LDAPUserManagement;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;

public class LDAPAuthentication
extends TurbineBaseService
implements PortalAuthentication {
    private static final String CONFIG_ANONYMOUS_USER = "user.anonymous";
    private static final String CACHING_ENABLE = "caching.enable";
    private JetspeedRunDataService runDataService = null;
    private String anonymousUser = "anon";
    private boolean cachingEnable = true;

    public JetspeedUser login(String username, String password) throws LoginException {
        if (username.equals(this.anonymousUser)) {
            throw new LoginException("Anonymous user cannot login");
        }
        JetspeedUser user = null;
        BasicAttributes attr = new BasicAttributes();
        String[] attrs = new String[]{"ou", "userPassword", "uid", "mail"};
        Object dN = null;
        username = JetspeedSecurity.convertUserName(username);
        password = JetspeedSecurity.convertPassword(password);
        try {
            user = JetspeedUserManagement.getUser(new UserNamePrincipal(username));
        }
        catch (UnknownUserException e) {
            throw new FailedLoginException(e.toString());
        }
        catch (JetspeedSecurityException e) {
            throw new LoginException(e.toString());
        }
        if (!LDAPUserManagement.passwordsMatch(user, password)) {
            throw new FailedLoginException("Credential authentication failure");
        }
        user.setHasLoggedIn(new Boolean(true));
        user.setTemp("sessionPassword", password);
        try {
            user.updateLastLogin();
            this.putUserIntoContext(user);
            if (this.cachingEnable) {
                JetspeedSecurityCache.load(username);
            }
        }
        catch (Exception e) {
            this.putUserIntoContext(JetspeedSecurity.getAnonymousUser());
            throw new LoginException("Failed to update last login ", e);
        }
        return user;
    }

    public JetspeedUser getAnonymousUser() throws LoginException {
        JetspeedUser user = null;
        try {
            user = JetspeedUserManagement.getUser(new UserNamePrincipal(this.anonymousUser));
            user.setHasLoggedIn(new Boolean(false));
            this.putUserIntoContext(user);
            if (this.cachingEnable) {
                JetspeedSecurityCache.load(user.getUserName());
            }
        }
        catch (JetspeedSecurityException e) {
            throw new LoginException("Failed to get anonymous user: " + (Object)((Object)e));
        }
        return user;
    }

    public void logout() throws LoginException {
        try {
            this.getAnonymousUser();
        }
        catch (Exception e) {
            throw new LoginException("Exception logging user out ", e);
        }
    }

    public synchronized void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        super.init(conf);
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("JetspeedSecurity");
        this.anonymousUser = serviceConf.getString(CONFIG_ANONYMOUS_USER, this.anonymousUser);
        this.cachingEnable = serviceConf.getBoolean(CACHING_ENABLE, this.cachingEnable);
        this.runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
        this.setInit(true);
    }

    protected JetspeedRunData getRunData() {
        JetspeedRunData rundata = null;
        if (this.runDataService != null) {
            rundata = this.runDataService.getCurrentRunData();
        }
        return rundata;
    }

    protected JetspeedUser getUserFromContext() {
        JetspeedRunData rundata = this.getRunData();
        JetspeedUser user = null;
        if (rundata != null) {
            user = (JetspeedUser)rundata.getUser();
        }
        return user;
    }

    protected JetspeedRunData putUserIntoContext(JetspeedUser user) {
        JetspeedRunData rundata = this.getRunData();
        if (rundata != null) {
            rundata.setUser(user);
            rundata.save();
        }
        return rundata;
    }
}

