/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.security;

import java.util.Date;

public class UserLogonStats {
    private int failures = 0;
    private int total = 0;
    private long firstLogon = 0L;
    private final String username;
    private boolean disabled = false;
    private Object sem;

    UserLogonStats(String username) {
        this.username = username;
        this.sem = new Object();
    }

    public int getFailures() {
        return this.failures;
    }

    public int getTotalFailures() {
        return this.total;
    }

    public long getFirstLogon() {
        return this.firstLogon;
    }

    public String getUserName() {
        return this.username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean failCheck(int allowed, long secondsAllowed, int max) {
        Object object = this.sem;
        synchronized (object) {
            long diff;
            if (this.disabled) {
                return true;
            }
            ++this.failures;
            ++this.total;
            if (this.total >= max) {
                this.reset();
                this.disabled = true;
                return true;
            }
            long msAllowed = secondsAllowed * 1000L;
            long now = new Date().getTime();
            if (this.firstLogon == 0L) {
                this.firstLogon = now;
            }
            if ((diff = now - this.firstLogon) > msAllowed) {
                this.reset();
            }
            if (this.failures >= allowed) {
                this.reset();
                this.disabled = true;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.sem;
        synchronized (object) {
            this.failures = 0;
            Date now = new Date();
            this.firstLogon = now.getTime();
            this.disabled = false;
        }
    }
}

