/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.security;

import java.util.Iterator;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.om.security.Permission;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.services.security.CachedAcl;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.services.security.SecurityCacheService;
import org.apache.turbine.services.TurbineServices;

public abstract class JetspeedSecurityCache {
    public String SERVICE_NAME = "SecurityCache";

    protected static SecurityCacheService getService() {
        return (SecurityCacheService)TurbineServices.getInstance().getService("SecurityCache");
    }

    public static void load(String username) throws JetspeedSecurityException {
        JetspeedSecurityCache.getService().load(username);
    }

    public static void unload(String username) {
        JetspeedSecurityCache.getService().unload(username);
    }

    public static void loadRolePermissions() {
        JetspeedSecurityCache.getService().loadRolePermissions();
    }

    public static Role getRole(String username, String roleName) {
        return JetspeedSecurityCache.getService().getRole(username, roleName);
    }

    public static Role getRole(String username, String roleName, String groupName) {
        return JetspeedSecurityCache.getService().getRole(username, roleName, groupName);
    }

    public static void addRole(Role role) {
        JetspeedSecurityCache.getService().addRole(role);
    }

    public static void addRole(String username, Role role) {
        JetspeedSecurityCache.getService().addRole(username, role);
    }

    public static void addRole(String username, Role role, Group group) {
        JetspeedSecurityCache.getService().addRole(username, role, group);
    }

    public static boolean hasRole(String username, String roleName) {
        return JetspeedSecurityCache.getService().hasRole(username, roleName);
    }

    public static boolean hasRole(String username, String roleName, String groupName) {
        return JetspeedSecurityCache.getService().hasRole(username, roleName, groupName);
    }

    public static void removeRole(String username, String roleName) {
        JetspeedSecurityCache.getService().removeRole(username, roleName);
    }

    public static void removeRole(String username, String roleName, String groupName) {
        JetspeedSecurityCache.getService().removeRole(username, roleName, groupName);
    }

    public static Iterator getRoles(String username) {
        return JetspeedSecurityCache.getService().getRoles(username);
    }

    public static CachedAcl getAcl(String username) {
        return JetspeedSecurityCache.getService().getAcl(username);
    }

    public static void removeAllRoles(String rolename) {
        JetspeedSecurityCache.getService().removeAllRoles(rolename);
    }

    public static void removeAllPermissions(String permissionName) {
        JetspeedSecurityCache.getService().removeAllPermissions(permissionName);
    }

    public static Permission getPermission(String roleName, String permissionName) {
        return JetspeedSecurityCache.getService().getPermission(roleName, permissionName);
    }

    public static void addPermission(String roleName, Permission permission) {
        JetspeedSecurityCache.getService().addPermission(roleName, permission);
    }

    public static boolean hasPermission(String roleName, String permissionName) {
        return JetspeedSecurityCache.getService().hasPermission(roleName, permissionName);
    }

    public static void removePermission(String roleName, String permissionName) {
        JetspeedSecurityCache.getService().removePermission(roleName, permissionName);
    }

    public static Iterator getPermissions(String roleName) {
        return JetspeedSecurityCache.getService().getPermissions(roleName);
    }
}

