/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.security;

import java.util.Iterator;
import org.apache.jetspeed.om.security.Permission;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.services.security.PermissionManagement;
import org.apache.turbine.services.TurbineServices;

public abstract class JetspeedPermissionManagement {
    public String SERVICE_NAME = "PermissionManagement";

    protected static PermissionManagement getService() {
        return (PermissionManagement)TurbineServices.getInstance().getService("PermissionManagement");
    }

    public static Iterator getPermissions(String rolename) throws JetspeedSecurityException {
        return JetspeedPermissionManagement.getService().getPermissions(rolename);
    }

    public static Iterator getPermissions() throws JetspeedSecurityException {
        return JetspeedPermissionManagement.getService().getPermissions();
    }

    public static void addPermission(Permission permission) throws JetspeedSecurityException {
        JetspeedPermissionManagement.getService().addPermission(permission);
    }

    public static void savePermission(Permission permission) throws JetspeedSecurityException {
        JetspeedPermissionManagement.getService().savePermission(permission);
    }

    public static void removePermission(String permissionName) throws JetspeedSecurityException {
        JetspeedPermissionManagement.getService().removePermission(permissionName);
    }

    public static void grantPermission(String roleName, String permissionName) throws JetspeedSecurityException {
        JetspeedPermissionManagement.getService().grantPermission(roleName, permissionName);
    }

    public static void revokePermission(String roleName, String permissionName) throws JetspeedSecurityException {
        JetspeedPermissionManagement.getService().revokePermission(roleName, permissionName);
    }

    public static boolean hasPermission(String roleName, String permissionName) throws JetspeedSecurityException {
        return JetspeedPermissionManagement.getService().hasPermission(roleName, permissionName);
    }

    public static Permission getPermission(String permissionName) throws JetspeedSecurityException {
        return JetspeedPermissionManagement.getService().getPermission(permissionName);
    }
}

