/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.search.handlers;

import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.search.AbstractObjectHandler;
import org.apache.jetspeed.services.search.BaseParsedObject;
import org.apache.jetspeed.services.search.ParsedObject;

public class URLToDocHandler
extends AbstractObjectHandler {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(URLToDocHandler.class.getName());

    public ParsedObject parseObject(Object o) {
        BaseParsedObject result = new BaseParsedObject();
        if (!(o instanceof URL)) {
            logger.error("URLToDocHandler: invalid object type: " + o);
            return null;
        }
        URL pageToAdd = (URL)o;
        HttpClient client = new HttpClient();
        client.startSession(pageToAdd);
        GetMethod method = new GetMethod(pageToAdd.getPath());
        method.setFollowRedirects(true);
        int statusCode = -1;
        int attempt = 0;
        while (statusCode == -1 && attempt < 3) {
            try {
                client.executeMethod((HttpMethod)method);
                statusCode = method.getStatusCode();
                if (!logger.isDebugEnabled()) continue;
                logger.debug("URL = " + pageToAdd.toString() + "Status code = " + statusCode);
            }
            catch (HttpException e) {
            }
            catch (IOException e) {
                return null;
            }
        }
        if (statusCode != -1) {
            String content = null;
            try {
                content = method.getDataAsString();
            }
            catch (IOException ioe) {
                logger.error("Getting content for " + pageToAdd.toString(), ioe);
            }
            if (content != null) {
                try {
                    result.setKey(URLEncoder.encode(pageToAdd.toString()));
                    result.setType("url");
                    result.setTitle(pageToAdd.toString());
                    result.setContent(content);
                    result.setDescription("");
                    result.setLanguage("");
                    result.setURL(pageToAdd);
                    result.setClassName(o.getClass().getName());
                    logger.info("Parsed '" + pageToAdd.toString() + "'");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("Adding document to index", e);
                }
            }
        }
        try {
            client.endSession();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            logger.error("Ending session to " + pageToAdd.toString(), ioe);
        }
        return result;
    }
}

