/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.rundata;

import java.util.Stack;
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.capability.CapabilityMapFactory;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.jetspeed.services.statemanager.StateManagerService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.rundata.DefaultTurbineRunData;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.security.AccessControlList;

public class DefaultJetspeedRunData
extends DefaultTurbineRunData
implements JetspeedRunData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(DefaultJetspeedRunData.class.getName());
    private Profile profile = null;
    private CapabilityMap map = null;
    private String peid = null;
    private String pid = null;
    private int mode = 0;
    private String template = null;

    public String getPortlet() {
        return this.pid;
    }

    public void setPortlet(String id) {
        this.pid = id;
    }

    public Portlet getCustomized() {
        SessionState customizationState = this.getPageSessionState();
        Stack stack = (Stack)customizationState.getAttribute("customize-stack");
        Portlet p = null;
        if (stack != null && !stack.empty()) {
            p = (Portlet)stack.peek();
        }
        if (p != null && stack.size() > 1) {
            customizationState.setAttribute("customize-paneName", p.getTitle());
        } else {
            customizationState.setAttribute("customize-paneName", "*");
        }
        return p;
    }

    public void setCustomized(Portlet p) {
        SessionState customizationState = this.getPageSessionState();
        Stack<Portlet> stack = (Stack<Portlet>)customizationState.getAttribute("customize-stack");
        if (stack == null) {
            stack = new Stack<Portlet>();
            customizationState.setAttribute("customize-stack", stack);
        }
        if (p == null) {
            if (!stack.empty()) {
                stack.pop();
            }
            customizationState.setAttribute("customize-paneName", "*");
        } else {
            if (stack.size() > 0) {
                Portlet last = (Portlet)stack.peek();
                if (last == null || !p.getName().equals(last.getName()) || !p.getTitle().equals(last.getTitle())) {
                    stack.push(p);
                }
            } else {
                stack.push(p);
            }
            customizationState.setAttribute("customize-paneName", p.getTitle());
        }
    }

    public Profile getCustomizedProfile() {
        SessionState customizationState = this.getPageSessionState();
        return (Profile)customizationState.getAttribute("customize-profile");
    }

    public void setCustomizedProfile(Profile profile) {
        SessionState customizationState = this.getPageSessionState();
        customizationState.setAttribute("customize-profile", profile);
    }

    public void cleanupFromCustomization() {
        SessionState customizationState = this.getPageSessionState();
        customizationState.removeAttribute("customize-stack");
        customizationState.removeAttribute("customize-paneName");
        customizationState.removeAttribute("customize-profile");
        customizationState.removeAttribute("customize-columns");
        customizationState.removeAttribute("customize-mode");
        customizationState.removeAttribute("customize-parameters");
        this.setMode("default");
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setMode(String mode) {
        if ("customize".equals(mode)) {
            this.setMode(1);
        } else if ("maximize".equals(mode)) {
            this.setMode(2);
        } else {
            this.setMode(0);
            this.setCustomized(null);
        }
    }

    public String getRequestedTemplate() {
        return this.template;
    }

    public void setRequestedTemplate(String id) {
        this.template = id;
    }

    public CapabilityMap getCapability() {
        if (this.map == null) {
            this.map = CapabilityMapFactory.getCapabilityMap((RunData)this);
        }
        return this.map;
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public void dispose() {
        this.mode = 0;
        this.map = null;
        this.peid = null;
        this.pid = null;
        this.profile = null;
        this.template = null;
        super.dispose();
    }

    public String getJs_peid() {
        return this.peid;
    }

    public void setJs_peid(String peid) {
        this.peid = peid;
    }

    public String getUserId() {
        JetspeedUser user = this.getJetspeedUser();
        if (user == null) {
            return "";
        }
        return user.getUserId();
    }

    public String getPageSessionId() {
        String sessionId = "?";
        if (this.getSession() != null) {
            sessionId = this.getSession().getId();
        } else {
            logger.warn("DefaultJetspeedRunData.getPageSessionId: no session");
        }
        String profileId = "?";
        if (this.getProfile() != null) {
            profileId = this.getProfile().getId();
        } else {
            logger.warn("DefaultJetspeedRunData.getPageSessionId: no profile");
        }
        return sessionId + profileId;
    }

    public SessionState getUserSessionState() {
        StateManagerService service = (StateManagerService)TurbineServices.getInstance().getService("StateManagerService");
        if (service == null) {
            return null;
        }
        return service.getSessionState(this.getSession().getId());
    }

    public SessionState getPageSessionState() {
        StateManagerService service = (StateManagerService)TurbineServices.getInstance().getService("StateManagerService");
        if (service == null) {
            return null;
        }
        return service.getSessionState(this.getPageSessionId());
    }

    public SessionState getPortletSessionState(String id) {
        StateManagerService service = (StateManagerService)TurbineServices.getInstance().getService("StateManagerService");
        if (service == null) {
            return null;
        }
        String pageInstanceId = this.getPageSessionId();
        return service.getSessionState(pageInstanceId + id);
    }

    public JetspeedUser getJetspeedUser() {
        return (JetspeedUser)this.getUser();
    }

    public AccessControlList getACL() {
        return null;
    }
}

