/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.registry;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.jetspeed.services.registry.FileRegistry;
import org.apache.jetspeed.services.registry.RegistryFragment;
import org.apache.turbine.util.Log;

public class DatabaseRegistryWatcher
extends Thread {
    public static final int SCAN_RATE = 10;
    private Hashtable files = new Hashtable();
    private long refreshRate = 0L;
    private FileRegistry subscriber = null;
    private boolean done = false;

    public DatabaseRegistryWatcher() {
        this.setDaemon(true);
        this.setPriority(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubscriber(FileRegistry registry) {
        DatabaseRegistryWatcher databaseRegistryWatcher = this;
        synchronized (databaseRegistryWatcher) {
            Enumeration en;
            if (this.subscriber != null) {
                en = this.files.keys();
                while (en.hasMoreElements()) {
                    try {
                        this.subscriber.removeFragment((String)en.nextElement());
                    }
                    catch (Exception e) {
                        Log.error((String)"RegistryWatcher: Can't remove fragment", (Throwable)e);
                    }
                }
            }
            this.subscriber = registry;
            if (this.subscriber != null) {
                en = this.files.keys();
                while (en.hasMoreElements()) {
                    try {
                        this.subscriber.loadFragment((String)en.nextElement());
                    }
                    catch (Exception e) {
                        Log.error((String)"RegistryWatcher: Can't load fragment", (Throwable)e);
                    }
                }
            }
        }
    }

    public FileRegistry getSubscriber() {
        return this.subscriber;
    }

    public void setRefreshRate(long refresh) {
        this.refreshRate = (refresh > 10L ? refresh : 10L) * 1000L;
    }

    public long getRefreshRate() {
        return this.refreshRate / 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeBase(Vector f) {
        DatabaseRegistryWatcher databaseRegistryWatcher = this;
        synchronized (databaseRegistryWatcher) {
            if (this.subscriber != null) {
                Enumeration en = this.files.keys();
                while (en.hasMoreElements()) {
                    try {
                        this.subscriber.removeFragment((String)en.nextElement());
                    }
                    catch (Exception e) {
                        Log.error((String)"RegistryWatcher: Can't remove fragment", (Throwable)e);
                    }
                }
            }
            this.files.clear();
            this.findFiles(f);
        }
    }

    private void findFiles(Vector s) {
        Enumeration en = s.elements();
        while (en.hasMoreElements()) {
            String f = (String)en.nextElement();
            if (f == null) continue;
            this.files.put(f, "now");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (!this.done) {
                boolean needRefresh = false;
                DatabaseRegistryWatcher databaseRegistryWatcher = this;
                synchronized (databaseRegistryWatcher) {
                    Map fragments = this.subscriber.getFragmentMap();
                    if (Log.getLogger().isDebugEnabled()) {
                        Log.debug((String)"RegistryWatcher: Saving dirty fragments.");
                    }
                    Iterator i = fragments.keySet().iterator();
                    while (i.hasNext()) {
                        try {
                            String filename = (String)i.next();
                            RegistryFragment fragment = (RegistryFragment)this.subscriber.getFragmentMap().get(filename);
                            if (!fragment.isDirty()) continue;
                            Enumeration en = this.files.keys();
                            while (en.hasMoreElements()) {
                                String f = (String)en.nextElement();
                                SimpleDateFormat sdf = new SimpleDateFormat("dd-mm-yyyy hh:mm:ss");
                                Date now = new Date();
                                String currentTime = sdf.format(now);
                                if (!filename.equals(f)) continue;
                                this.files.put(f, currentTime);
                            }
                        }
                        catch (Exception e) {
                            Log.error((String)"RegistryWatcher: exception during update", (Throwable)e);
                        }
                    }
                    if (Log.getLogger().isDebugEnabled()) {
                        Log.debug((String)"RegistryWatcher: Checking for updated files.");
                    }
                    Enumeration en = this.files.keys();
                    while (en.hasMoreElements()) {
                        try {
                            String f = (String)en.nextElement();
                            String modified = (String)this.files.get(f);
                            this.subscriber.loadFragment(f);
                            RegistryFragment frag = (RegistryFragment)fragments.get(f);
                            if (frag != null) {
                                frag.setChanged(true);
                            }
                            needRefresh = true;
                        }
                        catch (Exception e) {
                            Log.error((String)"RegistryWatcher: exception during update", (Throwable)e);
                        }
                    }
                    if (needRefresh) {
                        this.subscriber.refresh();
                        needRefresh = false;
                    }
                    i = fragments.keySet().iterator();
                    while (i.hasNext()) {
                        RegistryFragment frag = (RegistryFragment)fragments.get((String)i.next());
                        frag.setDirty(false);
                        frag.setChanged(false);
                    }
                }
                DatabaseRegistryWatcher.sleep(this.refreshRate);
            }
        }
        catch (InterruptedException e) {
            Log.error((String)"RegistryWatcher: Stopping monitor: ");
            Log.error((Throwable)e);
            return;
        }
    }

    public void setDone() {
        this.done = true;
        Log.info((String)"RegistryWatcher: Watching thread stop requested");
    }
}

