/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.registry;

import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.om.registry.DBRegistry;
import org.apache.jetspeed.om.registry.Registry;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.om.registry.RegistryException;
import org.apache.jetspeed.om.registry.base.BaseRegistry;
import org.apache.jetspeed.om.registry.base.LocalRegistry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.registry.CastorRegistryService;
import org.apache.jetspeed.services.registry.DatabaseRegistryWatcher;
import org.apache.jetspeed.services.registry.FileRegistry;
import org.apache.jetspeed.services.registry.RegistryFragment;
import org.apache.jetspeed.services.registry.RegistryService;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;

public class DatabaseRegistryService
extends TurbineBaseService
implements RegistryService,
FileRegistry {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(CastorRegistryService.class.getName());
    public static final String SERVICE_NAME = "DatabaseRegistry";
    public static final int DEFAULT_VERBOSE = 1;
    private Hashtable registries = new Hashtable();
    private Hashtable defaults = new Hashtable();
    private Hashtable fragments = new Hashtable();
    private Hashtable entryIndex = new Hashtable();
    private DatabaseRegistryWatcher watcher = null;
    private static final String POOL_NAME = "database";
    private int verbose = 1;
    private static Hashtable baseClass = new Hashtable();

    public Registry get(String regName) {
        return (Registry)this.registries.get(regName);
    }

    public Enumeration getNames() {
        return this.registries.keys();
    }

    public RegistryEntry createEntry(String regName) {
        RegistryEntry entry = null;
        Registry registry = (Registry)this.registries.get(regName);
        if (registry != null) {
            entry = registry.createEntry();
        }
        return entry;
    }

    public RegistryEntry getEntry(String regName, String entryName) {
        try {
            return ((Registry)this.registries.get(regName)).getEntry(entryName);
        }
        catch (RegistryException e) {
            if (logger.isInfoEnabled()) {
                logger.info("RegistryService: Failed to retrieve " + entryName + " from " + regName);
            }
        }
        catch (NullPointerException e) {
            logger.error("DatabaseRegistryService: " + regName + " registry is not known ");
            logger.error(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(String regName, RegistryEntry entry) throws RegistryException {
        if (entry == null) {
            return;
        }
        LocalRegistry registry = (LocalRegistry)this.registries.get(regName);
        if (registry != null) {
            RegistryFragment fragment;
            String fragmentName = (String)this.entryIndex.get(entry.getName());
            if (fragmentName == null) {
                fragmentName = (String)this.defaults.get(regName);
            }
            if ((fragment = (RegistryFragment)this.fragments.get(fragmentName)) == null) {
                fragment = new RegistryFragment();
                fragment.put(regName, new Vector());
                this.fragments.put(fragmentName, fragment);
            } else {
                Vector vectRegistry = (Vector)fragment.get(regName);
                if (vectRegistry == null) {
                    fragment.put(regName, new Vector());
                }
            }
            Hashtable hashtable = this.entryIndex;
            synchronized (hashtable) {
                if (registry.hasEntry(entry.getName())) {
                    fragment.setEntry(regName, entry);
                    registry.setLocalEntry(entry);
                } else {
                    fragment.addEntry(regName, entry);
                    registry.addLocalEntry(entry);
                }
                this.entryIndex.put(entry.getName(), fragmentName);
                fragment.setDirty(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(String regName, String entryName) {
        if (entryName == null) {
            return;
        }
        LocalRegistry registry = (LocalRegistry)this.registries.get(regName);
        if (registry != null) {
            String fragmentName = (String)this.entryIndex.get(entryName);
            if (fragmentName != null) {
                RegistryFragment fragment = (RegistryFragment)this.fragments.get(fragmentName);
                Hashtable hashtable = this.entryIndex;
                synchronized (hashtable) {
                    fragment.removeEntry(regName, entryName);
                    this.entryIndex.remove(entryName);
                    fragment.setDirty(true);
                }
            }
            registry.removeLocalEntry(entryName);
        }
    }

    public synchronized void init(ServletConfig conf) throws InitializationException {
        String name;
        int refreshRate = 0;
        Vector<String> names = new Vector<String>();
        TurbineServices.getInstance().initService("ServletService", (Object)conf);
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources(SERVICE_NAME);
        try {
            refreshRate = serviceConf.getInt("refreshRate", 300);
            ResourceService defaults = serviceConf.getResources("default");
            Iterator i = defaults.getKeys();
            while (i.hasNext()) {
                name = (String)i.next();
                names.add(name);
                try {
                    String registryClass = "org.apache.jetspeed.om.registry.database.BaseJetspeed" + name + "Peer";
                    baseClass.put(name, (DBRegistry)Class.forName(registryClass).newInstance());
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn("DatabaseRegistryService: Class " + name + " not found");
                }
            }
        }
        catch (Throwable t) {
            throw new InitializationException("Unable to initialize DatabaseRegistryService, missing config keys");
        }
        this.watcher = new DatabaseRegistryWatcher();
        this.watcher.setSubscriber(this);
        if (refreshRate == 0) {
            this.watcher.setDone();
        } else {
            this.watcher.setRefreshRate(refreshRate);
        }
        this.watcher.changeBase(names);
        this.setInit(true);
        Enumeration en = names.elements();
        RegistryService localeService = (RegistryService)TurbineServices.getInstance().getService("Registry");
        while (en.hasMoreElements()) {
            name = (String)en.nextElement();
            Registry registry = (Registry)this.registries.get(name);
            if (registry == null) {
                String registryClass = null;
                try {
                    registry = localeService.get(name);
                }
                catch (Exception e) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("DatabaseRegistryService: Class " + registryClass + " not found, reverting to default Registry");
                    }
                    registry = new BaseRegistry();
                }
                this.registries.put(name, registry);
            }
            this.refresh(name);
        }
        if (this.watcher != null) {
            this.watcher.start();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("DatabaseRegistryService: early init()....end!, this.getInit()= " + this.getInit());
        }
    }

    public Map getFragmentMap() {
        return (Map)this.fragments.clone();
    }

    public void init() throws InitializationException {
        if (logger.isDebugEnabled()) {
            logger.debug("DatabaseRegistryService: Late init called");
        }
        while (!this.getInit()) {
            try {
                Thread.sleep(500L);
                if (this.verbose <= 2 || !logger.isDebugEnabled()) continue;
                logger.debug("DatabaseRegistryService: Waiting for init of Registry...");
            }
            catch (InterruptedException ie) {
                logger.error(ie);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("DatabaseRegistryService: We are done");
        }
    }

    public void shutdown() {
        this.watcher.setDone();
        Iterator i = this.fragments.keySet().iterator();
        while (i.hasNext()) {
            this.saveFragment((String)i.next());
        }
    }

    protected void refresh(String regName) {
        if (logger.isDebugEnabled()) {
            logger.debug("DatabaseRegistryService: Updating the " + regName + " registry");
        }
        int count = 0;
        boolean counDeleted = false;
        LocalRegistry registry = (LocalRegistry)this.get(regName);
        if (registry == null) {
            logger.error("DatabaseRegistryService: Null " + this.name + " registry in refresh");
            return;
        }
        Vector toDelete = new Vector();
        Iterator i = registry.listEntryNames();
        while (i.hasNext()) {
            toDelete.add(i.next());
        }
        Enumeration en = this.fragments.keys();
        while (en.hasMoreElements()) {
            Vector entries;
            String location = (String)en.nextElement();
            RegistryFragment fragment = (RegistryFragment)this.fragments.get(location);
            int fragCount = 0;
            if (!fragment.hasChanged()) {
                if (this.verbose > 2 && logger.isDebugEnabled()) {
                    logger.debug("DatabaseRegistryService: Skipping fragment " + location);
                }
                entries = fragment.getEntries(regName);
                i = entries.iterator();
                while (i.hasNext()) {
                    toDelete.remove(((RegistryEntry)i.next()).getName());
                }
                continue;
            }
            entries = fragment.getEntries(regName);
            if (entries != null) {
                Enumeration en2 = entries.elements();
                while (en2.hasMoreElements()) {
                    RegistryEntry entry = (RegistryEntry)en2.nextElement();
                    try {
                        if (registry.hasEntry(entry.getName())) {
                            if (registry.getEntry(entry.getName()).equals(entry)) {
                                if (this.verbose > 2 && logger.isDebugEnabled()) {
                                    logger.debug("DatabaseRegistryService: No changes to entry " + entry.getName());
                                }
                            } else {
                                if (this.verbose > 1 && logger.isDebugEnabled()) {
                                    logger.debug("DatabaseRegistryService: Updating entry " + entry.getName() + " of class " + entry.getClass() + " to registry " + this.name);
                                }
                                registry.setLocalEntry(entry);
                                this.entryIndex.put(entry.getName(), location);
                                ++fragCount;
                            }
                        } else {
                            registry.addLocalEntry(entry);
                            this.entryIndex.put(entry.getName(), location);
                            ++fragCount;
                            if (this.verbose > 1 && logger.isDebugEnabled()) {
                                logger.debug("DatabaseRegistryService: Adding entry " + entry.getName() + " of class " + entry.getClass() + " to registry " + this.name);
                            }
                        }
                    }
                    catch (RegistryException e) {
                        logger.error("DatabaseRegistryService: RegistryException while adding " + entry.getName() + "from " + location, e);
                    }
                    toDelete.remove(entry.getName());
                }
            }
            count += fragCount;
        }
        for (String entryName : toDelete) {
            if (this.verbose <= 1 || !logger.isDebugEnabled()) continue;
            logger.debug("DatabaseRegistryService: removing entry " + entryName);
        }
        if (this.verbose > 1 && logger.isDebugEnabled()) {
            logger.debug("DatabaseRegistryService: Merged " + count + " entries and deleted " + toDelete.size() + " in " + this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        DatabaseRegistryWatcher databaseRegistryWatcher = this.watcher;
        synchronized (databaseRegistryWatcher) {
            Enumeration en = this.getNames();
            while (en.hasMoreElements()) {
                this.refresh((String)en.nextElement());
            }
        }
    }

    public void loadFragment(String file) {
        try {
            RegistryFragment fragment = this.createFragment(file);
            fragment.setChanged(true);
            this.updateFragment(file, fragment);
        }
        catch (Throwable t) {
            logger.error("DatabaseRegistryService: Could not unmarshal: " + file, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFragment(String name, Reader reader, boolean persistent) {
        Object file = null;
        try {
            reader.close();
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    public void saveFragment(String file) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFragment(String file) {
        RegistryFragment fragment = (RegistryFragment)this.fragments.get(file);
        if (fragment != null) {
            Hashtable hashtable = this.entryIndex;
            synchronized (hashtable) {
                Iterator i = this.entryIndex.keySet().iterator();
                while (i.hasNext()) {
                    if (!file.equals(this.entryIndex.get(i.next()))) continue;
                    i.remove();
                }
                fragment.clear();
                this.fragments.remove(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFragment(String name, RegistryFragment fragment) {
        Hashtable hashtable = this.entryIndex;
        synchronized (hashtable) {
            Iterator i = this.entryIndex.keySet().iterator();
            while (i.hasNext()) {
                if (!name.equals(this.entryIndex.get(i.next()))) continue;
                i.remove();
            }
            this.fragments.put(name, fragment);
            Enumeration enu = fragment.keys();
            while (enu.hasMoreElements()) {
                String strReg = (String)enu.nextElement();
                Vector v = fragment.getEntries(strReg);
                for (int counter = 0; counter < v.size(); ++counter) {
                    RegistryEntry str = (RegistryEntry)v.elementAt(counter);
                    this.entryIndex.put(str.getName(), name);
                }
            }
        }
    }

    private static List getData(String name) {
        List list = null;
        try {
            DBRegistry BaseClass = (DBRegistry)baseClass.get(name);
            if (BaseClass != null) {
                list = BaseClass.getXREGDataFromDb();
            } else {
                logger.warn("DatabaseRegistryService: Base class  for service " + name + " not found");
            }
        }
        catch (Exception ex) {
            logger.warn("DatabaseRegistryService: Base class  for service " + name + " not found");
        }
        return list;
    }

    private RegistryFragment createFragment(String regName) {
        RegistryFragment fragment = (RegistryFragment)this.fragments.get(regName);
        if (fragment == null) {
            fragment = new RegistryFragment();
            fragment.put(regName, new Vector());
        } else {
            Vector vectRegistry = (Vector)fragment.get(regName);
            if (vectRegistry == null) {
                fragment.put(regName, new Vector());
            }
        }
        List entries = DatabaseRegistryService.getData(regName);
        if (entries != null) {
            for (int i = 0; i < entries.size(); ++i) {
                fragment.setEntry(regName, (RegistryEntry)entries.get(i));
                fragment.setDirty(true);
            }
        } else {
            logger.warn("DatabaseRegistryService:no data fouund for service " + this.name);
        }
        return fragment;
    }
}

