/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.registry;

import com.aimluck.eip.common.ALEipConstants;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.jetspeed.om.registry.Registry;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.om.registry.RegistryException;
import org.apache.jetspeed.om.registry.base.BaseRegistry;
import org.apache.jetspeed.om.registry.base.LocalRegistry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.registry.FileRegistry;
import org.apache.jetspeed.services.registry.RegistryFragment;
import org.apache.jetspeed.services.registry.RegistryService;
import org.apache.jetspeed.services.registry.RegistryWatcher;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;
import org.apache.turbine.services.servlet.TurbineServlet;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class CastorRegistryService
extends TurbineBaseService
implements RegistryService,
FileRegistry {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(CastorRegistryService.class.getName());
    public static final int DEFAULT_REFRESH = 300;
    public static final String DEFAULT_EXTENSION = ".xreg";
    public static final String DEFAULT_MAPPING = "${webapp}/WEB-INF/conf/mapping.xml";
    private Hashtable registries = new Hashtable();
    private Hashtable fragments = new Hashtable();
    private Hashtable defaults = new Hashtable();
    private Hashtable entryIndex = new Hashtable();
    private RegistryWatcher watcher = null;
    private Mapping mapping = null;
    private OutputFormat format = null;
    private String directory = null;
    private String extension = null;

    public Registry get(String regName) {
        return (Registry)this.registries.get(regName);
    }

    public Enumeration getNames() {
        return this.registries.keys();
    }

    public RegistryEntry createEntry(String regName) {
        RegistryEntry entry = null;
        Registry registry = (Registry)this.registries.get(regName);
        if (registry != null) {
            entry = registry.createEntry();
        }
        return entry;
    }

    public RegistryEntry getEntry(String regName, String entryName) {
        try {
            return ((Registry)this.registries.get(regName)).getEntry(entryName);
        }
        catch (RegistryException e) {
            if (logger.isInfoEnabled()) {
                logger.info("RegistryService: Failed to retrieve " + entryName + " from " + regName);
            }
        }
        catch (NullPointerException e) {
            logger.error("RegistryService: " + regName + " registry is not known ", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(String regName, RegistryEntry entry) throws RegistryException {
        if (entry == null) {
            return;
        }
        LocalRegistry registry = (LocalRegistry)this.registries.get(regName);
        if (registry != null) {
            RegistryFragment fragment;
            String fragmentName = (String)this.entryIndex.get(entry.getName());
            if (fragmentName == null) {
                fragmentName = (String)this.defaults.get(regName);
            }
            if ((fragment = (RegistryFragment)this.fragments.get(fragmentName)) == null) {
                fragment = new RegistryFragment();
                fragment.put(regName, new Vector());
                this.fragments.put(fragmentName, fragment);
            } else {
                Vector vectRegistry = (Vector)fragment.get(regName);
                if (vectRegistry == null) {
                    fragment.put(regName, new Vector());
                }
            }
            Hashtable hashtable = this.entryIndex;
            synchronized (hashtable) {
                if (registry.hasEntry(entry.getName())) {
                    fragment.setEntry(regName, entry);
                    registry.setLocalEntry(entry);
                } else {
                    fragment.addEntry(regName, entry);
                    registry.addLocalEntry(entry);
                }
                this.entryIndex.put(entry.getName(), fragmentName);
                fragment.setDirty(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(String regName, String entryName) {
        if (entryName == null) {
            return;
        }
        LocalRegistry registry = (LocalRegistry)this.registries.get(regName);
        if (registry != null) {
            String fragmentName = (String)this.entryIndex.get(entryName);
            if (fragmentName != null) {
                RegistryFragment fragment = (RegistryFragment)this.fragments.get(fragmentName);
                Hashtable hashtable = this.entryIndex;
                synchronized (hashtable) {
                    fragment.removeEntry(regName, entryName);
                    this.entryIndex.remove(entryName);
                    fragment.setDirty(true);
                }
            }
            registry.removeLocalEntry(entryName);
        }
    }

    public synchronized void init(ServletConfig conf) throws InitializationException {
        File base;
        String name;
        TurbineServices.getInstance().initService("ServletService", (Object)conf);
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("Registry");
        String mapFile = null;
        Vector<String> names = new Vector<String>();
        int refreshRate = 0;
        try {
            this.directory = serviceConf.getString("directory");
            mapFile = serviceConf.getString("mapping", DEFAULT_MAPPING);
            this.extension = serviceConf.getString("extension", DEFAULT_EXTENSION);
            refreshRate = serviceConf.getInt("refreshRate", 300);
            mapFile = TurbineServlet.getRealPath((String)mapFile);
            this.directory = TurbineServlet.getRealPath((String)this.directory);
        }
        catch (Throwable t) {
            throw new InitializationException("Unable to initialize CastorRegistryService, missing config keys");
        }
        try {
            ResourceService defaults = serviceConf.getResources("default");
            Iterator i = defaults.getKeys();
            while (i.hasNext()) {
                name = (String)i.next();
                String fragmentFileName = defaults.getString(name);
                String absFileName = new File(this.directory, fragmentFileName + this.extension).getCanonicalPath();
                names.add(name);
                this.defaults.put(name, absFileName);
            }
        }
        catch (Exception e) {
            logger.error("RegistryService: Registry init error", e);
            throw new InitializationException("Unable to initialize CastorRegistryService, invalid registries definition");
        }
        this.format = new OutputFormat();
        this.format.setIndenting(true);
        this.format.setIndent(4);
        this.format.setLineWidth(0);
        if (mapFile != null) {
            File map = new File(mapFile);
            if (map.exists() && map.isFile() && map.canRead()) {
                try {
                    this.mapping = new Mapping();
                    InputSource is = new InputSource(new FileReader(map));
                    is.setSystemId(mapFile);
                    this.mapping.loadMapping(is);
                }
                catch (Exception e) {
                    logger.error("RegistryService: Error in mapping creation", e);
                    throw new InitializationException("Error in mapping", (Throwable)e);
                }
            } else {
                throw new InitializationException("Mapping not found or not a file or unreadable: " + mapFile);
            }
        }
        if ((base = new File(this.directory)).exists() && base.isDirectory() && base.canRead()) {
            this.watcher = new RegistryWatcher();
            this.watcher.setSubscriber(this);
            this.watcher.setFilter(new ExtFileFilter(this.extension));
            if (refreshRate == 0) {
                this.watcher.setDone();
            } else {
                this.watcher.setRefreshRate(refreshRate);
            }
            this.watcher.changeBase(base);
        }
        this.setInit(true);
        Enumeration en = names.elements();
        while (en.hasMoreElements()) {
            name = (String)en.nextElement();
            Registry registry = (Registry)this.registries.get(name);
            if (registry == null) {
                String registryClass = null;
                try {
                    registryClass = "org.apache.jetspeed.om.registry.base.Base" + name + "Registry";
                    registry = (Registry)Class.forName(registryClass).newInstance();
                }
                catch (Exception e) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("RegistryService: Class " + registryClass + " not found, reverting to default Registry");
                    }
                    registry = new BaseRegistry();
                }
                this.registries.put(name, registry);
            }
            this.refresh(name);
        }
        if (this.watcher != null) {
            this.watcher.start();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("RegistryService: early init()....end!, this.getInit()= " + this.getInit());
        }
    }

    public void init() throws InitializationException {
        if (logger.isDebugEnabled()) {
            logger.debug("RegistryService: Late init called");
        }
        while (!this.getInit()) {
            try {
                Thread.sleep(500L);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("RegistryService: Waiting for init of Registry...");
            }
            catch (InterruptedException ie) {
                logger.error("Exception", ie);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("RegistryService: We are done");
        }
    }

    public void shutdown() {
        this.watcher.setDone();
        Iterator i = this.fragments.keySet().iterator();
        while (i.hasNext()) {
            this.saveFragment((String)i.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        RegistryWatcher registryWatcher = this.watcher;
        synchronized (registryWatcher) {
            Enumeration en = this.getNames();
            while (en.hasMoreElements()) {
                this.refresh((String)en.nextElement());
            }
        }
    }

    public Map getFragmentMap() {
        return (Map)this.fragments.clone();
    }

    public void loadFragment(String file) {
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            Document d = builder.parse(new File(file));
            Unmarshaller unmarshaller = new Unmarshaller(this.mapping);
            RegistryFragment fragment = (RegistryFragment)unmarshaller.unmarshal((Node)d);
            fragment.setChanged(true);
            this.updateFragment(file, fragment);
        }
        catch (Throwable t) {
            logger.error("RegistryService: Could not unmarshal: " + file, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFragment(String name, Reader reader, boolean persistent) {
        String file = null;
        try {
            RegistryWatcher registryWatcher = this.watcher;
            synchronized (registryWatcher) {
                file = new File(this.directory, name + this.extension).getCanonicalPath();
                Unmarshaller unmarshaller = new Unmarshaller(this.mapping);
                RegistryFragment fragment = (RegistryFragment)unmarshaller.unmarshal(reader);
                fragment.setChanged(true);
                this.updateFragment(file, fragment);
                if (persistent) {
                    this.saveFragment(file);
                }
            }
        }
        catch (Throwable t) {
            logger.error("RegistryService: Could not create fragment: " + file, t);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {
                logger.error("Exception", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFragment(String file) {
        OutputStreamWriter writer = null;
        FileOutputStream fos = null;
        RegistryFragment fragment = (RegistryFragment)this.fragments.get(file);
        if (fragment != null) {
            try {
                fos = new FileOutputStream(file);
                writer = new OutputStreamWriter((OutputStream)fos, ALEipConstants.DEF_CONTENT_ENCODING);
                this.format.setEncoding(ALEipConstants.DEF_CONTENT_ENCODING);
                XMLSerializer serializer = new XMLSerializer((Writer)writer, this.format);
                Marshaller marshaller = new Marshaller(serializer.asDocumentHandler());
                marshaller.setMapping(this.mapping);
                marshaller.marshal((Object)fragment);
            }
            catch (Throwable t) {
                logger.error("RegistryService: Could not marshal: " + file, t);
            }
            finally {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    logger.error("Exception", e);
                }
                try {
                    fos.close();
                }
                catch (Exception e) {
                    logger.error("Exception", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFragment(String file) {
        RegistryFragment fragment = (RegistryFragment)this.fragments.get(file);
        if (fragment != null) {
            Hashtable hashtable = this.entryIndex;
            synchronized (hashtable) {
                Iterator i = this.entryIndex.keySet().iterator();
                while (i.hasNext()) {
                    if (!file.equals(this.entryIndex.get(i.next()))) continue;
                    i.remove();
                }
                fragment.clear();
                this.fragments.remove(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFragment(String name, RegistryFragment fragment) {
        Hashtable hashtable = this.entryIndex;
        synchronized (hashtable) {
            Iterator i = this.entryIndex.keySet().iterator();
            while (i.hasNext()) {
                if (!name.equals(this.entryIndex.get(i.next()))) continue;
                i.remove();
            }
            this.fragments.put(name, fragment);
            Enumeration enu = fragment.keys();
            while (enu.hasMoreElements()) {
                String strReg = (String)enu.nextElement();
                Vector v = fragment.getEntries(strReg);
                for (int counter = 0; counter < v.size(); ++counter) {
                    RegistryEntry str = (RegistryEntry)v.elementAt(counter);
                    this.entryIndex.put(str.getName(), name);
                }
            }
        }
    }

    protected void refresh(String regName) {
        if (logger.isDebugEnabled()) {
            logger.debug("RegistryService: Updating the " + regName + " registry");
        }
        int count = 0;
        boolean counDeleted = false;
        LocalRegistry registry = (LocalRegistry)this.get(regName);
        if (registry == null) {
            logger.error("RegistryService: Null " + this.name + " registry in refresh");
            return;
        }
        Vector toDelete = new Vector();
        Iterator i = registry.listEntryNames();
        while (i.hasNext()) {
            toDelete.add(i.next());
        }
        Enumeration en = this.fragments.keys();
        while (en.hasMoreElements()) {
            Vector entries;
            String location = (String)en.nextElement();
            RegistryFragment fragment = (RegistryFragment)this.fragments.get(location);
            int fragCount = 0;
            if (!fragment.hasChanged()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("RegistryService: Skipping fragment " + location);
                }
                entries = fragment.getEntries(regName);
                i = entries.iterator();
                while (i.hasNext()) {
                    toDelete.remove(((RegistryEntry)i.next()).getName());
                }
                continue;
            }
            entries = fragment.getEntries(regName);
            if (entries != null) {
                Enumeration en2 = entries.elements();
                while (en2.hasMoreElements()) {
                    RegistryEntry entry = (RegistryEntry)en2.nextElement();
                    try {
                        if (registry.hasEntry(entry.getName())) {
                            if (registry.getEntry(entry.getName()).equals(entry)) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("RegistryService: No changes to entry " + entry.getName());
                                }
                            } else {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("RegistryService: Updating entry " + entry.getName() + " of class " + entry.getClass() + " to registry " + this.name);
                                }
                                registry.setLocalEntry(entry);
                                this.entryIndex.put(entry.getName(), location);
                                ++fragCount;
                            }
                        } else {
                            registry.addLocalEntry(entry);
                            this.entryIndex.put(entry.getName(), location);
                            ++fragCount;
                            if (logger.isDebugEnabled()) {
                                logger.debug("RegistryService: Adding entry " + entry.getName() + " of class " + entry.getClass() + " to registry " + this.name);
                            }
                        }
                    }
                    catch (RegistryException e) {
                        logger.error("RegistryService: RegistryException while adding " + entry.getName() + "from " + location, e);
                    }
                    toDelete.remove(entry.getName());
                }
            }
            count += fragCount;
        }
        for (String entryName : toDelete) {
            if (logger.isDebugEnabled()) {
                logger.debug("RegistryService: removing entry " + entryName);
            }
            registry.removeLocalEntry(entryName);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("RegistryService: Merged " + count + " entries and deleted " + toDelete.size() + " in " + this.name);
        }
    }

    class ExtFileFilter
    implements FileFilter {
        private String extension = null;

        ExtFileFilter(String extension) {
            this.extension = extension;
        }

        public boolean accept(File f) {
            return f.toString().endsWith(this.extension);
        }
    }
}

